<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/legacyRender/class/AbstractFilterForm.class.php";

define('BANNER_SORT_KEY_BID', 1);
define('BANNER_SORT_KEY_CID', 2);
define('BANNER_SORT_KEY_IMPTOTAL', 3);
define('BANNER_SORT_KEY_IMPMADE', 4);
define('BANNER_SORT_KEY_CLICKS', 5);
define('BANNER_SORT_KEY_IMAGEURL', 6);
define('BANNER_SORT_KEY_CLICKURL', 7);
define('BANNER_SORT_KEY_DATE', 8);
define('BANNER_SORT_KEY_HTMLBANNER', 9);
define('BANNER_SORT_KEY_HTMLCODE', 10);
define('BANNER_SORT_KEY_MAXVALUE', 10);

define('BANNER_SORT_KEY_DEFAULT', BANNER_SORT_KEY_BID);

class LegacyRender_BannerFilterForm extends LegacyRender_AbstractFilterForm
{
	var $mSort = 0;
	var $_mSortKeys = array(
		BANNER_SORT_KEY_BID => 'bid',
		BANNER_SORT_KEY_CID => 'cid',
		BANNER_SORT_KEY_IMPTOTAL => 'imptotal',
		BANNER_SORT_KEY_IMPMADE => 'impmade',
		BANNER_SORT_KEY_CLICKS => 'clicks',
		BANNER_SORT_KEY_IMAGEURL => 'imageurl',
		BANNER_SORT_KEY_CLICKURL => 'clickurl',
		BANNER_SORT_KEY_DATE => 'date',
		BANNER_SORT_KEY_HTMLBANNER => 'htmlbanner',
		BANNER_SORT_KEY_HTMLCODE => 'htmlcode'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : BANNER_SORT_KEY_DEFAULT;
	
		if ($this->mSort > BANNER_SORT_KEY_MAXVALUE) {
			$this->mSort = BANNER_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['cid'])) {
			$this->_mNavi->addExtra('cid', xoops_getrequest('cid'));
			$this->_mCriteria->add(new Criteria('cid', array(XOBJ_DTYPE_INT, xoops_getrequest('cid'))));
		}
	
		if (isset($_REQUEST['htmlbanner'])) {
			$this->_mNavi->addExtra('htmlbanner', xoops_getrequest('htmlbanner'));
			$this->_mCriteria->add(new Criteria('htmlbanner', array(XOBJ_DTYPE_BOOL, xoops_getrequest('htmlbanner'))));
		}
		
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
