<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/legacyRender/class/AbstractFilterForm.class.php";

define('BANNERFINISH_SORT_KEY_BID', 1);
define('BANNERFINISH_SORT_KEY_CID', 2);
define('BANNERFINISH_SORT_KEY_IMPRESSIONS', 3);
define('BANNERFINISH_SORT_KEY_CLICKS', 4);
define('BANNERFINISH_SORT_KEY_DATESTART', 5);
define('BANNERFINISH_SORT_KEY_DATEEND', 6);
define('BANNERFINISH_SORT_KEY_MAXVALUE', 6);

define('BANNERFINISH_SORT_KEY_DEFAULT', BANNERFINISH_SORT_KEY_BID);

class LegacyRender_BannerfinishFilterForm extends LegacyRender_AbstractFilterForm
{
	var $mSort = 0;
	var $_mSortKeys = array(
		BANNERFINISH_SORT_KEY_BID => 'bid',
		BANNERFINISH_SORT_KEY_CID => 'cid',
		BANNERFINISH_SORT_KEY_IMPRESSIONS => 'impressions',
		BANNERFINISH_SORT_KEY_CLICKS => 'clicks',
		BANNERFINISH_SORT_KEY_DATESTART => 'datestart',
		BANNERFINISH_SORT_KEY_DATEEND => 'dateend'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : BANNERFINISH_SORT_KEY_DEFAULT;
	
		if ($this->mSort > BANNERFINISH_SORT_KEY_MAXVALUE) {
			$this->mSort = BANNERFINISH_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['cid'])) {
			$this->_mNavi->addExtra('cid', xoops_getrequest('cid'));
			$this->_mCriteria->add(new Criteria('cid', array(XOBJ_DTYPE_INT, xoops_getrequest('cid'))));
		}
		
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
