<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH."/pm/forms/PmliteEditForm.class.php";
require_once XOOPS_MODULE_PATH."/pm/kernel/PrivateMessage.class.php";	// Wmm..

class PmPmliteAction extends PmAction
{
	var $mActionForm=null;

	function isSecure()
	{
		return true;
	}

	function getDefaultView(&$controller,&$xoopsUser)
	{
		$this->_processActionForm();

		//
		// Fetch request only (no validate).
		//
		$this->mActionForm->fetch();

		return PM_FRAME_VIEW_INPUT;
	}

	function execute(&$controller,&$xoopsUser)
	{
		$this->_processActionForm();

		//
		// Fetch request and validate.
		//
		$this->mActionForm->fetch();
		$this->mActionForm->validate();

		//
		// If error, go to re-input.
		//
		if($this->mActionForm->hasError())
			return PM_FRAME_VIEW_INPUT;
			
		//
		// Send PM
		//
		$pmManager=new PrivateMessageManager();	//< TODO
		$pm=&$pmManager->create();

		$this->mActionForm->update($pm);
		$pm->setFromUsers($xoopsUser);
		if($pm->send()) {
			return PM_FRAME_VIEW_SUCCESS;
		}
		else {
			return PM_FRAME_VIEW_ERROR;
		}
	}

	function _processActionForm()
	{
		//
		// Create action form object by reply mode? or not?
		//
		$this->mActionForm=($this->mConfig['send_type']==0) ? new PmliteComboEditForm() : new PmliteDirectEditForm();
		if(isset($_GET['reply'])&&$_GET['reply']==1)
			$this->mActionForm->changeStateReply();

		$this->mActionForm->prepare();
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("pm_pmlite_success.html");
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader("pmlite.php",3,_MD_PM_ERROR_MESSAGE_SEND);
	}

	function executeViewInput(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("pmlite.html");
		$renderSystem->setAttribute("actionForm",$this->mActionForm);
		$renderSystem->setAttribute("send_type",$this->mConfig['send_type']);

		//
		// If the request doesn't have uid, list up users to template.
		//
		if($this->mConfig['send_type']==0 && $this->mActionForm->getVar('to_userid')==0) {
			$userHandler=&xoops_gethandler('user');
			$userObjects=&$userHandler->getObjectsByLevel(0);
			$renderSystem->setAttribute("userList",$userObjects);
		}
	}
}

?>