<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH."/user/admin/actions/GroupPropertyAction.class.php";
require_once XOOPS_MODULE_PATH."/user/admin/forms/GroupPermEditForm.class.php";

/**
 *
 * This function keeps difficult problems that this depens on the column's block of X2 theme format.
 */
class User_GroupPermAction extends User_GroupPropertyAction
{
	var $mActionForm = null;
	
	function prepare(&$controller, &$xoopsUser, &$moduleConfig)
	{
		$this->mActionForm =& new User_GroupPermEditForm();
		$this->mActionForm->prepare();
	}
	
	/**
	 * This function don't use actionform, now.
	 * I (minahito) must remove code-clone.
	 */
	function execute(&$controller, &$xoopsUser)
	{
		$this->_loadGroup();
		
		if (!is_object($this->mGroup)) {
			return USER_FRAME_VIEW_ERROR;
		}
		
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		if ($this->mActionForm->hasError()) {
			return $this->getDefaultView($controller, $xoopsUser);
		}
		
		//
		// Reset group permission
		//
		$gpermHandler =& xoops_gethandler('groupperm');
		$gpermHandler->deleteBasicPermission($this->mGroup->getVar('groupid'));
		
		foreach ($this->mActionForm->get('system') as $sid => $value)
		{
			$item =& new User_PermissionSystemAdminItem($sid, null);
			$perm =& new User_Permission($this->mGroup->getVar('groupid'), $item);
			
			$perm->save();

			unset($perm);
		}
		
		$moduleHandler =& xoops_gethandler('module');
		$modPerms = array();

		//
		// Store module read permission
		//
		foreach ($this->mActionForm->get('module') as $mid => $value)
		{
			$module =& $moduleHandler->get($mid);
			if (is_object($module) && $value) {
				$gpermHandler->addRight('module_read', $mid, $this->mGroup->getVar('groupid'));
			}
		}

		foreach ($this->mActionForm->get('module_admin') as $mid => $value)
		{
			$module =& $moduleHandler->get($mid);
			if (is_object($module) && $value) {
				$gpermHandler->addRight('module_admin', $mid, $this->mGroup->getVar('groupid'));
			}
		}

		$blockHandler =& xoops_gethandler('block');

		foreach ($this->mActionForm->get('block') as $bid => $value)
		{
			$block =& $blockHandler->get($bid);
			if (is_object($block) && $value) {
				$gpermHandler->addRight('block_read', $bid, $this->mGroup->getVar('groupid'));
			}
		}
		
		return USER_FRAME_VIEW_SUCCESS;
	}
	
	function executeViewIndex(&$controller,&$xoopsUser,&$render)
	{
		$render->setTemplateName("group_perm.html");
		$render->setAttribute("group",$this->mGroup);
		$render->setAttribute("actionForm",$this->mActionForm);
		$render->setAttribute("modulePermissions",$this->mPermissions);
		$render->setAttribute("blockPermissions",$this->mBlockPermissions);
		$render->setAttribute("systemPermissions",$this->mSystemPermissions);
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$render)
	{
		$controller->executeForward("index.php?action=GroupPerm&groupid=" . $this->mGroup->getVar('groupid'));
	}
}

?>