<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/MailjobAdminEditForm.class.php";
require_once XOOPS_MODULE_PATH . "/user/class/PageNavigator.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/UserSearchFilterForm.class.php";

class User_MailjobEditAction extends User_AbstractEditAction
{
	var $mPageNavi = null;
	var $mFilter = null;
	
	function _getId()
	{
		return isset($_REQUEST['mailjob_id']) ? $_REQUEST['mailjob_id'] : 0;
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('mailjob');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new User_MailjobAdminEditForm();
		$this->mActionForm->prepare();

		$this->mPageNavi =& new User_PageNavigator('./index?action=MailjobEdit', 0, XCUBE_PAGENAVI_START | XCUBE_PAGENAVI_PERPAGE);
		$this->mFilter =& new User_UserSearchFilterForm($this->mPageNavi);
		
		$this->mFilter->fetch();
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		$isNew = $this->mObject->isNew();
		
		$ret = parent::execute($controller, $xoopsUser);
		
		if ($ret == USER_FRAME_VIEW_SUCCESS && $isNew) {
			$handler =& xoops_getmodulehandler('users');
			$uidArr = $handler->getUids($this->mFilter->getCriteria());
			
			$handler =& xoops_getmodulehandler('mailjob_link');
			foreach ($uidArr as $uid) {
				$obj =& $handler->create();
				$obj->set('mailjob_id', $this->mObject->get('mailjob_id'));
				$obj->set('uid', $uid);
				$handler->insert($obj);
			}
		}
		
		return $ret;
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("mailjob_edit.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('pageNavi', $this->mPageNavi);
		$render->setAttribute('object', $this->mObject);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=MailjobList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		redirect_header("./index.php?action=MailjobList", 1, _AD_USER_ERROR_DBUPDATE_FAILED);
	}
}

?>
