<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/admin/forms/MailjobAdminSendForm.class.php";

class User_MailjobSendAction extends User_Action
{
	var $mMailjob = null;
	var $mActionForm = null;
	
	function User_MailjobSendAction()
	{
	}

	function prepare(&$controller, &$xoopsUser)
	{
		$id = intval(xoops_getrequest('mailjob_id'));
		
		$handler =& xoops_getmodulehandler('mailjob');
		
		$this->mMailjob =& $handler->get($id);

		if (is_object($this->mMailjob)) {
			$this->mActionForm =& new User_MailjobAdminSendForm();
			$this->mActionForm->prepare();
			$this->mActionForm->load($this->mMailjob);
		}
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		if (!is_object($this->mMailjob)) {
			return USER_FRAME_VIEW_ERROR;
		}

		//
		//
		//
		$this->mMailjob->loadUser();
		
		return USER_FRAME_VIEW_INPUT;
	}

	function execute(&$controller, &$xoopsUser)
	{
		if (!is_object($this->mMailjob)) {
			return USER_FRAME_VIEW_ERROR;
		}
		
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		if ($this->mActionForm->hasError()) {
			return USER_FRAME_VIEW_INPUT;
		}

		$root =& XCube_Root::getSingleton();		
		if ($this->mMailjob->get('is_pm')) {
			$root->mEventManager->add("Module.User.Mailjob.Send", new XCube_InstanceDelegate($this, "sendPM"));
		}

		if ($this->mMailjob->get('is_mail')) {
			$root->mEventManager->add("Module.User.Mailjob.Send", new XCube_InstanceDelegate($this, "sendMail"));
		}

		$this->mMailjob->send($xoopsUser);
		
		$this->mMailjob->loadUserCount();
		
		return ($this->mMailjob->mUserCount > 0) ? USER_FRAME_VIEW_INPUT : USER_FRAME_VIEW_SUCCESS;
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward('./index.php?action=MailjobList');
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		XCube_Utils::redirectHeader('./index.php?action=MailjobList', 1, _AD_USER_ERROR_MAILJOB_SEND_FAIL);
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("mailjob_send.html");
		$render->setAttribute('object', $this->mMailjob);
		$render->setAttribute('actionForm', $this->mActionForm);
	}

	function sendPM(&$sender, &$eventArgs)
	{
		$root =& XCube_Root::getSingleton();
		$serviceMgr =& $root->getServiceManager();
		$pmService =& $serviceMgr->searchXCubeService('PrivateMessage');
		
		$pmClient =& new XCube_ServiceClient($pmService);
		
		//
		// Convert body message.
		//
		$replaceEventArgs = array();
		$replaceEventArgs['body'] = $eventArgs['mailjob']->get('body');
		$replaceEventArgs['to_user'] =& $eventArgs['to_user'];
		$replaceEventArgs['from_user'] =& $eventArgs['from_user'];
		$replaceEventArgs['mailjob'] =& $eventArgs['mailjob'];
		$root->mEventManager->raiseEvent('Module.User.Mailjob.ReplaceBody', $this, $replaceEventArgs);
		
		$param = array(
			'to_uid' => $eventArgs['to_user']->get('uid'),
			'from_uid' => $eventArgs['from_user']->get('uid'),
			'subject' => $eventArgs['mailjob']->get('title'),
			'message' => $replaceEventArgs['body']
		);
		
		$result =& $pmClient->call('send', $param);
	}

	function sendMail(&$sender, &$eventArgs)
	{
		$xoopsMailer =& getMailer();
		$xoopsMailer->useMail();

		//
		// Set To
		//		
		$xoopsMailer->setToUsers($eventArgs['to_user']);
		
		//
		// Set From
		//
		$xoopsMailer->setFromEmail($eventArgs['mailjob']->get('from_email'));
		$xoopsMailer->setFromName($eventArgs['mailjob']->get('from_name'));

		//
		// Convert body message.
		//
		$replaceEventArgs = array();
		$replaceEventArgs['body'] = $eventArgs['mailjob']->get('body');
		$replaceEventArgs['to_user'] =& $eventArgs['to_user'];
		$replaceEventArgs['from_user'] =& $eventArgs['from_user'];
		$replaceEventArgs['mailjob'] =& $eventArgs['mailjob'];
		
		$root =& XCube_Root::getSingleton();
		$root->mEventManager->raiseEvent('Module.User.Mailjob.ReplaceBody', $this, $replaceEventArgs);
		
		$xoopsMailer->setBody($replaceEventArgs['body']);

		//
		// TODO Error handling.
		//		
		$xoopsMailer->send(true);
	}
}

?>
