<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

class UserMailjobObject extends XoopsSimpleObject
{
	var $mUsers = array();
	var $_mUsersLoadedFlag = false;
	var $mUserCount = 0;
	
	function UserMailjobObject()
	{
		$this->initVar('mailjob_id', XOBJ_DTYPE_INT, '', false);
		$this->initVar('title', XOBJ_DTYPE_STRING, '', true, 255);
		$this->initVar('body', XOBJ_DTYPE_TEXT, '', true);
		$this->initVar('from_name', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('from_email', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('is_pm', XOBJ_DTYPE_BOOL, '0', true);
		$this->initVar('is_mail', XOBJ_DTYPE_BOOL, '0', true);
		$this->initVar('create_unixtime', XOBJ_DTYPE_INT, time(), true);
	}

	/**
	 * Count the number of target users, and set it to mUserCount. 
	 */	
	function loadUserCount()
	{
		$handler =& xoops_getmodulehandler('mailjob_link', 'user');
		$this->mUserCount = $handler->getCount(new Criteria('mailjob_id', $this->get('mailjob_id')));
	}
	
	/**
	 * Load the uid list of target users.
	 */
	function loadUser()
	{
		if (!$this->_mUsersLoadedFlag) {
			$handler =& xoops_getmodulehandler('mailjob_link', 'user');
			$this->mUsers =& $handler->getObjects(new Criteria('mailjob_id', $this->get('mailjob_id')));
			$this->_mUsersLoadedFlag = true;
		}
	}
	
	function send($from_user)
	{
		$root =& XCube_Root::getSingleton();
		
		$root->mEventManager->add("Module.User.Mailjob.ReplaceBody", new XCube_InstanceDelegate($this, "getReplaceBody"));

		$this->loadUser();
		$handler =& xoops_getmodulehandler('mailjob_link', 'user');

		$userHandler =& xoops_gethandler('user');
		
		foreach ($this->mUsers as $link) {
			$to_user =& $userHandler->get($link->get('uid'));
			
			if (is_object($to_user)) {
				$eventArgs = array();
				$eventArgs['from_user'] =& $from_user;
				$eventArgs['to_user'] =& $to_user;
				$eventArgs['mailjob'] =& $this;
			
				$root->mEventManager->raiseEvent('Module.User.Mailjob.Send', $this, $eventArgs);
			}
			
			$handler->delete($link);
		}
	}
	
	function getReplaceBody(&$sender, &$eventArgs)
	{
		//
		// TODO Replace subject, too. (We wait new delegate class)
		//
		$eventArgs['body'] = str_replace('{X_UID}', $eventArgs['to_user']->get('uid'), $eventArgs['body']);
		$eventArgs['body'] = str_replace('{X_UNAME}', $eventArgs['to_user']->get('uname'), $eventArgs['body']);
		$eventArgs['body'] = str_replace('{X_UEMAIL}', $eventArgs['to_user']->get('email'), $eventArgs['body']);
		$eventArgs['body'] = str_replace('{X_UEMAIL}', $eventArgs['to_user']->get('email'), $eventArgs['body']);
		// TODO {X_UACTLINK}
	}
}

class UserMailjobHandler extends XoopsObjectGenericHandler
{
	var $mTable = "user_mailjob";
	var $mPrimary = "mailjob_id";
	var $mClass = "UserMailjobObject";
}

?>
