<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * Static methods' collection for delegates.
 */
class UserEventFunction
{
	/**
	 * @param $sender Base_Controller
	 */
	function AccessToUserinfo(&$controller,&$eventArgs)
	{
		// $controller=(Base_Controller)$sender;
		$uid=isset($_REQUEST['uid']) ? intval($_REQUEST['uid']) : 0;
		if($uid>0) {
			$url=XOOPS_MODULE_URL."/user/index.php?action=UserInfo&uid=".$uid;
		}
		else {
			$xoopsUser=&$controller->getXoopsUser();
			if(is_object($xoopsUser))
				$url=XOOPS_MODULE_URL."/user/index.php?action=UserInfo&uid=".$xoopsUser->get('uid');
		}

		$controller->executeForward($url);
	}

	/**
	 * @param $sender Base_Controller
	 */
	function AccessToEdituser(&$controller,&$eventArgs)
	{
		// $controller=(Base_Controller)$sender;
		$uid=isset($_REQUEST['uid']) ? intval($_REQUEST['uid']) : 0;

		$url=XOOPS_URL;
		if($uid>0) {
			$url=XOOPS_MODULE_URL."/user/index.php?action=EditUser&uid=".$uid;
		}
		else {
			$xoopsUser=&$controller->getXoopsUser();
			if(is_object($xoopsUser))
				$url=XOOPS_MODULE_URL."/user/index.php?action=EditUser&uid=".$xoopsUser->get('uid');
		}

		$controller->executeForward($url);
	}

	/**
	 * @param $sender Base_Controller
	 */
	function AccessToUser(&$controller,&$eventArgs)
	{
		// $controller=(Base_Controller)$sender;
		$op=isset($_REQUEST['op']) ? trim($_REQUEST['op']) : "main";
		$xoopsUser=&$controller->getXoopsUser();
		
		switch($op) {
			case "main":
				$url=is_object($xoopsUser) ? XOOPS_MODULE_URL."/user/index.php?action=UserInfo&uid=".$xoopsUser->get('uid')
				                             : XOOPS_MODULE_URL."/user/index.php"; 
				$controller->executeForward($url);
				break;
				
			case "login":
				$checkLoginEventArgs = new CheckLoginEventArgs();
				$controller->mRoot->mEventManager->raiseEvent("Site.CheckLogin",$controller,$checkLoginEventArgs);
				break;
			
			case "logout":
				$args=array();
				$args['successFlag']=false;
				$controller->mRoot->mEventManager->raiseEvent("Site.Logout",$controller,$args);
				break;
		}
	}

	/**
	 * @param $sender Base_Controller
	 */
	function AccessToRegister(&$controller,&$eventArgs)
	{
		$xoopsUser =& $controller->getXoopsUser();
		if (is_object($xoopsUser)) {
			$controller->executeForward(XOOPS_URL);
		}
		else {
			$controller->executeForward(XOOPS_MODULE_URL . "/user/index.php?action=UserRegister");
		}
	}
	
	function CheckLogin(&$controller,&$eventArgs)
	{
		if($eventArgs->isSuccess())
			return;

		$controller->mRoot->mLanguageManager->loadModuleLanguage('user');

		$userHandler =& xoops_gethandler('user');
		
		$criteria =& new CriteriaCompo();
		$criteria->add(new Criteria('uname', xoops_getrequest('uname')));
		$criteria->add(new Criteria('pass', md5(xoops_getrequest('pass'))));
		
		$userArr =& $userHandler->getObjects($criteria);
		
		if (count($userArr) != 1) {
			$eventArgs->setRedirectUrl(XOOPS_URL."/user.php");
			$eventArgs->setRedirectMessage(_US_INCORRECTLOGIN);
			return;
		}
		
		$user =& $userArr[0];
			
		if($user->get('level')==0) {
			$eventArgs->setRedirectUrl(XOOPS_URL);
			$eventArgs->setRedirectMessage(_US_NOACTTPADM);
			return;
		}
	
		// Regist to session
		$_SESSION = array();
		$_SESSION['xoopsUserId'] = $user->get('uid');
		$_SESSION['xoopsUserGroups'] = $user->getGroups();
		
		if (!empty($_POST['xoops_redirect']) && !strpos($_POST['xoops_redirect'], 'register')) {
			$parsed = parse_url(XOOPS_URL);
			$url = isset($parsed['scheme']) ? $parsed['scheme'].'://' : 'http://';
			if (isset($parsed['host'])) {
				$url .= isset($parsed['port']) ?$parsed['host'].':'.$parsed['port'].trim($_POST['xoops_redirect']): $parsed['host'].trim($_POST['xoops_redirect']);
			} else {
				$url .= xoops_getenv('HTTP_HOST').trim($_POST['xoops_redirect']);
			}
		} else {
			$url = XOOPS_URL.'/index.php';
		}
		
		$eventArgs->setXoopsUser($user);

		$eventArgs->setRedirectUrl($url);
		$eventArgs->setSuccessFlag(true);
	}

	function Logout(&$controller,&$eventArgs)
	{
		// @Todo: this function depends global variable
		global $xoopsConfig;
		global $xoopsUser;

		$controller->mRoot->mLanguageManager->loadModuleLanguage('user');

		// Reset session
		$_SESSION = array();
		session_destroy();

		if ($xoopsConfig['use_mysession'] && $xoopsConfig['session_name'] != '') {
			setcookie($xoopsConfig['session_name'], '', time()- 3600, '/',  '', 0);
		}

		// clear entry from online users table
		if (is_object($xoopsUser)) {
			$onlineHandler =& xoops_gethandler('online');
			$onlineHandler->destroy($xoopsUser->get('uid'));
		}
		
		$eventArgs['successFlag']=true;
    }
    
	/**
	 * Update last login time
	 */
    function CheckLoginSuccess(&$sender,&$eventArgs)
    {
		if(is_object($eventArgs['xoopsUser'])) {
			$userHandler=&xoops_gethandler('user');
			$eventArgs['xoopsUser']->setVar('last_login', time());
			$userHandler->insert($eventArgs['xoopsUser']);
		}
	}

	/**
	 * If the current user is registered user, kick out to the top page.
	 * Else, forward to the lost-pass page.
	 */
	function AccessToLostpass(&$controller, &$eventArgs)
	{
		$xoopsUser =& $controller->getXoopsUser();
		if (is_object($xoopsUser)) {
			$controller->executeForward(XOOPS_URL);
		}
		else {
			$controller->executeForward(XOOPS_MODULE_URL . "/user/index.php?action=LostPass");
		}
	}

}


?>