<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH."/class/XCube_EventManager.class.php";

class UserEventProxyRegister extends XCube_EventProxyRegister
{
	var $_mList=array("Legacypage.Userinfo.Access","Legacypage.Edituser.Access",
	                   "Legacypage.User.Access", "Site.CheckLogin", "Site.Logout",
	                   "Legacypage.Register.Access","Site.CheckLogin.Success",
					   "Legacypage.Lostpass.Access");
	
	function getEventNameList()
	{
		return $this->_mList;
	}
	
	function &createLegacypage_Userinfo_AccessDelegate()
	{
		require_once XOOPS_MODULE_PATH."/user/kernel/UserEventFunction.class.php";
		$delegate=new XCube_Delegate("UserEventFunction","AccessToUserinfo");
		return $delegate;
	}

	function &createLegacypage_Edituser_AccessDelegate()
	{
		require_once XOOPS_MODULE_PATH."/user/kernel/UserEventFunction.class.php";
		$delegate=new XCube_Delegate("UserEventFunction","AccessToEdituser");
		return $delegate;
	}

	function &createLegacypage_User_AccessDelegate()
	{
		require_once XOOPS_MODULE_PATH."/user/kernel/UserEventFunction.class.php";
		$delegate=new XCube_Delegate("UserEventFunction","AccessToUser");
		return $delegate;
	}

	function &createLegacypage_Register_AccessDelegate()
	{
		require_once XOOPS_MODULE_PATH."/user/kernel/UserEventFunction.class.php";
		$delegate=new XCube_Delegate("UserEventFunction","AccessToRegister");
		return $delegate;
	}

	function &createSite_CheckLoginDelegate()
	{
		require_once XOOPS_MODULE_PATH."/user/kernel/UserEventFunction.class.php";
		$delegate=new XCube_Delegate("UserEventFunction","CheckLogin");
		return $delegate;
	}

	function &createSite_LogoutDelegate()
	{
		require_once XOOPS_MODULE_PATH."/user/kernel/UserEventFunction.class.php";
		$delegate=new XCube_Delegate("UserEventFunction","Logout");
		return $delegate;
	}

	function &createSite_CheckLogin_SuccessDelegate()
	{
		require_once XOOPS_MODULE_PATH."/user/kernel/UserEventFunction.class.php";
		$delegate=new XCube_Delegate("UserEventFunction","CheckLoginSuccess");
		return $delegate;
	}

	function &createLegacypage_Lostpass_AccessDelegate()
	{
		require_once XOOPS_MODULE_PATH."/user/kernel/UserEventFunction.class.php";
		$delegate=new XCube_Delegate("UserEventFunction","AccessToLostpass");
		return $delegate;
	}
}

class UserCommonEventFunction
{
	function &Login(&$controller,&$loginEventArgs)
	{
		if (!empty($_SESSION['xoopsUserId'])) {
			$memberHandler=xoops_gethandler('member');
			$xoopsUser=&$memberHandler->getUser($_SESSION['xoopsUserId']);
			if(!is_object($xoopsUser)) {
				$xoopsUser = null;
				$_SESSION=array();
			}
			else {
				$xoopsUser->setGroups($_SESSION['xoopsUserGroups']);
			}
			$loginEventArgs->setXoopsUser($xoopsUser);
			$controller->mXoopsUser=&$xoopsUser;
		}

		return $loginEventArgs;
	}
}

?>