<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/class/PageNavigator.class.php";
require_once XOOPS_MODULE_PATH . "/base/class/AbstractListAction.class.php";
require_once XOOPS_MODULE_PATH . "/base/admin/forms/ImageFilterForm.class.php";

class Legacy_ImageListAction extends Legacy_AbstractListAction
{
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('image');
		return $handler;
	}

	function &_getFilterForm(&$navi)
	{
		$filter =& new Legacy_ImageFilterForm($navi);
		return $filter;
	}

	function _getBaseUrl()
	{
		return "./index.php?action=ImageList";
	}
	
	function getDefaultView(&$contoller, &$xoopsUser)
	{
		$result = parent::getDefaultView($controller, $xoopsUser);
		if ($result == LEGACY_FRAME_VIEW_INDEX) {
			$cat_id = xoops_getrequest('imgcat_id');
			$handler =& xoops_getmodulehandler('imagecategory');
			$this->mCategory =& $handler->get($cat_id);
			
			if ($this->mCategory == null) {
				$result = LEGACY_FRAME_VIEW_ERROR;
			}
		}
		
		return $result;
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("image_list.html");
		
		foreach (array_keys($this->mObjects) as $key) {
			$this->mObjects[$key]->loadImagecategory();
		}
		
		$render->setAttribute("objects", $this->mObjects);
		$render->setAttribute("pageNavi", $this->mNavi);
		
		$render->setAttribute("category", $this->mCategory);
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?Action=ImagecategoryList");
	}
}

?>
