<?php
/**
 * @package Legacy
 * @version $Id: Legacy_AdminModuleController.class.php,v 1.1.2.18 2006/08/04 04:34:43 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/modules/base/kernel/Legacy_ModuleController.class.php";

/**
 * When user accesses admin panel, this class is be used.
 * (This class does not need to confirm it)
 */
class Legacy_AdminModuleController extends Legacy_ModuleController
{
	function _isActiveCheck()
	{
		return false;
	}

	/**
	 * Return true.
	 * When user accesses admin panel, this class is be used.
	 * @return boolean
	 */
	function isModuleProcess()
	{
		return true;
	}
	
	function isActive()
	{
		return is_object($this->mModuleObject) && $this->mModuleObject->getVar('isactive');
	}
	
	/**
	 *  Check current user's permission, return boolean as its result. If current
	 * module's dirname is Base or System, check whether current user has one of
	 * the permissions of administrator.
	 *
	 *  The check of this method is loose for Base module and System module only.
	 * But, In Base module's controller, system must check his permission strictly.
	 *
	 * @access public
	 * @todo This method re-writes $GLOBAL['xoopsUserIsAdmin']! Wmm...
	 * @return bool
	 */
	function hasPermission()
	{
		$xoopsUser =& $this->mController->getXoopsUser();

		//
		// The guest user is never administrator.
		//
		if (!is_object($xoopsUser))
			return false;

		//
		// Decide $mid as a argument for checkRight() by current module's dirname.
		//
		$mid = 0;
		if ($this->mModuleObject->get('dirname') == 'base' || $this->mModuleObject->get('dirname') == 'system') {
			$mid = -1;
		}
		else {
			$mid = $this->mModuleObject->get('mid');
		}
		
        $modPermHandler =& xoops_gethandler('groupperm');
		return $modPermHandler->checkRight('module_admin', $mid, $xoopsUser->getGroups());
	}

	/**
	 @return void
	*/
	function setupModuleObject($dirname = null)
	{
		if ($dirname == null) {
			$dirname = $this->_getDirname();
		}

		$moduleHandler =& xoops_gethandler('module');

		//
		// When user accesses to root/admin.php, $dirname is null.
		//
		$module = null;
		if($dirname != null) {
			$module=&$moduleHandler->getByDirname($dirname);
		}
		else {
			$module =& $moduleHandler->getByDirname("base");
		}
		
		//
		// We must set $xoopsModule to some module that use $xoopsModule in message catalog file.
		//
		$GLOBALS['xoopsModule']=&$module;

		$dmy =& $module->getInfo();

		//
		// Load admin menu, and add preference menu by own judge.
		//
		$module->loadAdminMenu();
		if ($module->getVar('hasnotification')
		    || ($module->getInfo('config') && is_array($module->getInfo('config')))
		    || ($module->getInfo('comments') && is_array($module->getInfo('comments')))) {
				$module->adminmenu[] = array(
    				'link' => XOOPS_URL.'/modules/base/admin/index.php?action=PreferenceEdit&amp;confmod_id=' . $module->getVar('mid'),
					'title' => _PREFERENCES,
					'absolute' => true);
		}
		
		$this->mModuleObject =& $module;
	}


	/**
	 * @access private
	 */
	function _getDirname()
	{
	    $url_arr = explode("/",strstr($_SERVER['REQUEST_URI'],'/modules/'));
	    return isset($url_arr[2]) ? $url_arr[2] : null;
	}
	
	function setupLanguage()
	{
		$languageManager =& $this->mController->mRoot->getLanguageManager();
		$languageManager->loadModuleAdminMessageCatalog($this->mModuleObject->getVar('dirname'));
		$languageManager->loadModinfoMessageCatalog($this->mModuleObject->getVar('dirname'));
	}
	
	function _processErrorModuleNotExist()
	{
		// Wmm...
		require_once XOOPS_ROOT_PATH ."/header.php";
		print "<h4>" . _MODULENOEXIST . "</h4>";
		require_once XOOPS_ROOT_PATH ."/footer.php";
		exit();
	}

	function getModuleDir()
	{
		return XOOPS_ROOT_PATH."/modules/".$this->mModuleObject->getVar('dirname')."/admin";
	}
	
	/**
	 *  Return module's directory name. This function is dependent on the design
	 * of Legacy.
	 */	
	function getDirname()
	{
		return is_object($this->mModuleObject) ? $this->mModuleObject->get('dirname') : null;
	}

	function &getXoopsModule()
	{
		return $this->mModuleObject;
	}

	function getDependRenderSystem()
	{
		return "Legacy_AdminRenderSystem";
	}
}

?>