<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

class Legacy_SiteClose extends XCube_ActionFilter
{
	function preBlockFilter()
	{
        if(($this->mController->mConfig['closesite']==1)||is_array(XCube_Utils::checkSystemModules())) {
			$this->mController->mRoot->mDelegateManager->add("Site.Login", array(&$this, "callbackSiteLogin"), XCUBE_DELEGATE_PRIORITY_FINAL);
			$this->mController->mRoot->mDelegateManager->add("Site.CheckLogin.Success",array(&$this,"callbackCheckLoginSuccess"));
		}
	}

	function callbackSiteLogin(&$xoopsUser)
	{
        $retArray = XCube_Utils::checkSystemModules();
	    $accessAllowFlag = false;
		
		if(!empty($_POST['xoops_login'])) {
            if (is_array($retArray)) {
    			define('XOOPS_CPFUNC_LOADED',1);
    		}

			$this->mController->checkLogin();
			return;
	    } elseif(is_object($this->mController->mXoopsUser)) {
			foreach ($this->mController->mXoopsUser->getGroups() as $group) {
				if (in_array($group, $this->mController->mConfig['closesite_okgrp']) || XOOPS_GROUP_ADMIN == $group) {
					$accessAllowFlag = true;
					break;
				}
			}
		}
		
        // @todo Devide following lines to another preload file
        if ($accessAllowFlag) {
            if (is_array($retArray)) {
               if (in_array(XOOPS_GROUP_ADMIN, $this->mController->mXoopsUser->getGroups())) {
                    $GLOBALS['xoopsUser'] = $this->mController->mXoopsUser;
                    if (!empty($_POST['cube_module_install'])) { //@todo use Ticket
                        require_once XOOPS_BASE_PATH."/admin/class/ModuleInstaller.class.php";
                        if (isset($_POST['uninstalled_modules']) && is_array($_POST['uninstalled_modules']) ){
                            foreach($_POST['uninstalled_modules'] as $module) {
                                $module = basename($module);
                                if (in_array($module, $retArray['uninstalled'])) {
                                    $installer = new Legacy_ModuleInstaller($module);
                                    $installer->execute();
                                }
                            }
                        }
                        if (isset($_POST['disabled_modules']) &&is_array($_POST['disabled_modules'])){
                            $moduleHandler =& xoops_gethandler('module');
                            foreach($_POST['disabled_modules'] as $module) {
                                $module = basename($module);
                                if (in_array($module, $retArray['disabled'])) {
                                    if($moduleObject =& $moduleHandler->getByDirname($module)) {
                                        $moduleObject->setVar('isactive',1);
                                        $moduleHandler->insert($moduleObject);
                                    }
                                }
                            }
                        }
                        if (isset($_POST['option_modules']) && is_array($_POST['option_modules']) ){
                            $handler =& xoops_getmodulehandler('non_installation_module','base');
                            $objects = $handler->getObjects();
                            $optionModules = array();
                            foreach($objects as $module) {
                                if (!in_array($module->getVar('dirname'), $retArray['uninstalled'])) {
                                    $optionModules[] = $module->getVar('dirname');
                                }
                            }
                            foreach($_POST['option_modules'] as $module) {
                                $module = basename($module);
                                if (in_array($module, $optionModules)) {
                                    $installer = new Legacy_ModuleInstaller($module);
                                    $installer->execute();
                                }
                            }
                        }
                        $this->mController->executeRedirect(XOOPS_URL,1);
                    } else if (!empty($_GET['cube_module_uninstall'])) {
                        require_once XOOPS_ROOT_PATH.'/class/template.php';
                        $xoopsTpl = new XoopsTpl();
                        $xoopsTpl->assign('cube_module_uninstall',htmlspecialchars($_GET['cube_module_uninstall'],ENT_QUOTES));
                        $xoopsTpl->assign( array(
                                       'xoops_sitename' => htmlspecialchars($this->mController->mConfig['sitename']),
                                       'xoops_themecss' => xoops_getcss(),
                                       'xoops_imageurl' => XOOPS_THEME_URL.'/'.$this->mController->mConfig['theme_set'].'/',
                                       ));
                        ///< @todo filebase template with absolute file path
                        $xoopsTpl->compile_check = true;
                        $xoopsTpl->display(XOOPS_ROOT_PATH.'/modules/base/templates/legacy_uninstall_modules.html');
                        exit();
                    } else if (!empty($_POST['cube_module_uninstallok'])) { //@todo use Ticket
                        require_once XOOPS_BASE_PATH."/admin/class/ModuleUninstaller.class.php";
                        $module = basename($_POST['cube_module_uninstallok']);
                        if (in_array($module, $retArray['disabled'])) {
                            $uninstaller = new Legacy_ModuleUninstaller($module);
                            $uninstaller->execute();
                        }
                        $this->mController->executeRedirect(XOOPS_URL,1);
                    } else {
                        $handler =& xoops_getmodulehandler('non_installation_module','base');
                        $objects = $handler->getObjects();
                        $optionModules = array();
                        foreach($objects as $module) {
                            $dirname = $module->getVar('dirname');
                            if (!in_array($dirname, $retArray['uninstalled'])) {
                                $optionModule['dirname']  = $dirname;
                                if (in_array($dirname, $retArray['recommended'])) {
                                    $optionModule['checked']  = 'checked="checked"';
                                    $optionModule['desc']  = _SYS_RECOMMENDED_MODULES;
                                } else {
                                    $optionModule['checked']  = '';
                                    $optionModule['desc']  = _SYS_OPTION_MODULES;
                                }
                                $optionModules[] = $optionModule;
                            }
                        }
                        require_once XOOPS_ROOT_PATH.'/class/template.php';
                        $xoopsTpl = new XoopsTpl();
                        $xoopsTpl->assign('uninstalled',$retArray['uninstalled']);
                        $xoopsTpl->assign('disabled',$retArray['disabled']);
                        $xoopsTpl->assign('option',$optionModules);
                        $xoopsTpl->assign( array(
                                       'xoops_sitename' => htmlspecialchars($this->mController->mConfig['sitename']),
                                       'xoops_themecss' => xoops_getcss(),
                                       'xoops_imageurl' => XOOPS_THEME_URL.'/'.$this->mController->mConfig['theme_set'].'/',
                                       ));
                        ///< @todo filebase template with absolute file path
                        $xoopsTpl->compile_check = true;
                        $xoopsTpl->display(XOOPS_ROOT_PATH.'/modules/base/templates/legacy_install_modules.html');
                        exit();
                    }
               } else {
                    $accessAllowFlag = false;
               }
            }
        }

	    if (!$accessAllowFlag) {
	        require_once XOOPS_ROOT_PATH.'/class/template.php';
	        $xoopsTpl = new XoopsTpl();
	        $xoopsTpl->assign( array('xoops_sitename' => htmlspecialchars($this->mController->mConfig['sitename']),
	                                   'xoops_themecss' => xoops_getcss(),
	                                   'xoops_imageurl' => XOOPS_THEME_URL.'/'.$this->mController->mConfig['theme_set'].'/',
	                                   'lang_login' => _LOGIN,
	                                   'lang_username' => _USERNAME,
	                                   'lang_password' => _PASSWORD,
	                                   'lang_siteclosemsg' => $this->mController->mConfig['closesite_text']));
            $xoopsTpl->compile_check = true;
            // @todo filebase template with absolute file path
            $xoopsTpl->display(XOOPS_ROOT_PATH . '/modules/base/templates/legacy_site_closed.html');
	        exit();
	    }
	}
	
	function callbackCheckLoginSuccess(&$xoopsUser)
	{
		//
		// This check is not needed. :)
		//
		if(!is_object($xoopsUser)) {
			return;
		}

		$user=&$eventArgs['xoopsUser'];

		// Site close
		if($this->mController->getConfig('closesite')) {
			$accessAllowed=false;

			foreach($user->getGroups() as $group) {
				if(in_array($group,$this->mController->getConfig('closesite_okgrp')) || ($group==XOOPS_GROUP_ADMIN)) {
					$accessAllowed=true;
					break;
				}
			}

			if(!$accessAllowed) {
				$this->mController->redirectHeader(XOOPS_URL,1,_NOPERM);
			}
		}
	}
}

?>