<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

class UserMailjobObject extends XoopsSimpleObject
{
	var $mUsers = array();
	var $_mUsersLoadedFlag = false;
	var $mUserCount = 0;
	
	/**
	 * @var XCube_NewDelegate
	 */
	var $mGetReplaceTitle = null;

	/**
	 * @var XCube_NewDelegate
	 */
	var $mGetReplaceBody = null;

	/**
	 * @var XCube_NewDelegate
	 */
	var $mSend = null;
	
	function UserMailjobObject()
	{
		$this->initVar('mailjob_id', XOBJ_DTYPE_INT, '', false);
		$this->initVar('title', XOBJ_DTYPE_STRING, '', true, 255);
		$this->initVar('body', XOBJ_DTYPE_TEXT, '', true);
		$this->initVar('from_name', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('from_email', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('is_pm', XOBJ_DTYPE_BOOL, '0', true);
		$this->initVar('is_mail', XOBJ_DTYPE_BOOL, '0', true);
		$this->initVar('create_unixtime', XOBJ_DTYPE_INT, time(), true);
		
		$this->mGetReplaceTitle =& new XCube_NewDelegate();
		$this->mGetReplaceTitle->register('UserMailjobObject.GetReplaceTitle');
		
		$this->mGetReplaceBody =& new XCube_NewDelegate();
		$this->mGetReplaceBody->register('UserMailjobObject.GetReplaceBody');
		
		$this->mSend =& new XCube_NewDelegate();
		$this->mSend->register('UserMailjobObject.Send');
	}

	/**
	 * Count the number of target users, and set it to mUserCount. 
	 */	
	function loadUserCount()
	{
		$handler =& xoops_getmodulehandler('mailjob_link', 'user');
		$this->mUserCount = $handler->getCount(new Criteria('mailjob_id', $this->get('mailjob_id')));
	}
	
	/**
	 * Load the uid list of target users.
	 */
	function loadUser()
	{
		if (!$this->_mUsersLoadedFlag) {
			$handler =& xoops_getmodulehandler('mailjob_link', 'user');
			$this->mUsers =& $handler->getObjects(new Criteria('mailjob_id', $this->get('mailjob_id')));
			$this->_mUsersLoadedFlag = true;
		}
	}
	
	function send($from_user)
	{
		$root =& XCube_Root::getSingleton();
		
		$this->loadUser();
		$handler =& xoops_getmodulehandler('mailjob_link', 'user');

		$userHandler =& xoops_gethandler('user');
		
		foreach ($this->mUsers as $link) {
			$to_user =& $userHandler->get($link->get('uid'));
			
			if (is_object($to_user)) {
				$this->mSend->call(new XCube_Ref($this), $to_user, $from_user);
			}
			
			$handler->delete($link);
		}
	}
	
	function getReplaceTitle(&$to_user, &$from_user)
	{
		return $this->get('title');
	}
	
	function getReplaceBody(&$to_user, &$from_user)
	{
		$t_body = $this->get('body');
		
		//
		// TODO {X_UACTLINK}
		//
		$t_body = str_replace('{X_UID}', $to_user->get('uid'), $t_body);
		$t_body = str_replace('{X_UNAME}', $to_user->get('uname'), $t_body);
		$t_body = str_replace('{X_UEMAIL}', $to_user->get('email'), $t_body);

		$this->mGetReplaceBody->call(new XCube_Ref($t_body), $to_user, $from_user);
		
		return $t_body;
	}
}

class UserMailjobHandler extends XoopsObjectGenericHandler
{
	var $mTable = "user_mailjob";
	var $mPrimary = "mailjob_id";
	var $mClass = "UserMailjobObject";
}

?>
