<?php

require_once dirname(__FILE__) . "/EasyLex_SQLScanner.class.php";

class Legacy_SQLScanner extends EasyLex_SQLScanner
{
	var $mDB_PREFIX = "";
	
	function setDB_PREFIX($prefix)
	{
		$this->mDB_PREFIX = $prefix;
	}

	/**
	 * Override.
	 */	
	function &getOperations()
	{
		$t_lines = array();
		$t_tokens = array();
		$depth = 0;
		
		foreach (array_keys($this->mTokens) as $key) {
			if ($this->mTokens[$key]->mType == EASYLEX_SQL_OPEN_PARENTHESIS) {
				$depth++;
			}
			elseif ($this->mTokens[$key]->mType == EASYLEX_SQL_CLOSE_PARENTHESIS) {
				$depth--;
			}
			
			$t_tokens[] =& $this->mTokens[$key];
			
			if (count($t_tokens) > 1 && $depth == 0) {
				if ($this->mTokens[$key]->mType == EASYLEX_SQL_SEMICOLON) {
					$t_lines[] =& $t_tokens;
					unset($t_tokens);
					$t_tokens = array();
				}
				elseif ($this->mTokens[$key]->mType == EASYLEX_SQL_LETTER && (strtoupper($this->mTokens[$key]->mValue) =='CREATE' || strtoupper($this->mTokens[$key]->mValue) =='ALTER' || strtoupper($this->mTokens[$key]->mValue) =='INSERT')) {
					array_pop($t_tokens);
					$t_lines[] =& $t_tokens;
					unset($t_tokens);
					$t_tokens = array();
					$t_tokens[] =& $this->mTokens[$key];
				}
			}
		}
		
		if (count($t_tokens) > 0) {
			$t_lines[] =& $t_tokens;
			unset($t_tokens);
		}
		
		foreach ($t_lines as $op) {
			if (count($op) >= 3) {
				if ($op[0]->mType == EASYLEX_SQL_LETTER && strtoupper($op[0]->mValue) == 'CREATE' &&
				    $op[1]->mType == EASYLEX_SQL_LETTER && strtoupper($op[1]->mValue) == 'TABLE' &&
				    ($op[2]->mType == EASYLEX_SQL_LETTER || $op[2]->mType == EASYLEX_SQL_STRING_LITERAL)) {
						$op[2]->mValue = $this->mDB_PREFIX . '_' . $op[2]->getValue();
				}
				if ($op[0]->mType == EASYLEX_SQL_LETTER && strtoupper($op[0]->mValue) == 'ALTER' &&
				    $op[1]->mType == EASYLEX_SQL_LETTER && strtoupper($op[1]->mValue) == 'TABLE' &&
				    ($op[2]->mType == EASYLEX_SQL_LETTER || $op[2]->mType == EASYLEX_SQL_STRING_LITERAL)) {
						$op[2]->mValue = $this->mDB_PREFIX . '_' . $op[2]->getValue();
				}
				if ($op[0]->mType == EASYLEX_SQL_LETTER && strtoupper($op[0]->mValue) == 'INSERT' &&
				    $op[1]->mType == EASYLEX_SQL_LETTER && strtoupper($op[1]->mValue) == 'INTO' &&
				    ($op[2]->mType == EASYLEX_SQL_LETTER || $op[2]->mType == EASYLEX_SQL_STRING_LITERAL)) {
						$op[2]->mValue = $this->mDB_PREFIX . '_' . $op[2]->getValue();
				}
			}
		}
		
		return $t_lines;
	}
}


?>