<?php
/**
 * @package XCube
 * @version $Id: XCube_Utils.class.php,v 1.1.2.5 2006/07/31 09:57:26 minahito Exp $
 */

class XCube_Utils
{
	/**
	Display redirect message and execute redirect.
	You can not continue your routine, because this method call exit().
	
	@todo I must solve direct HTML code.
	@param $url string
	@param $time intval
	@param $message If you want to multiline message, you must set message as array.
	
	@deprecated Don't use static function of XCube layer for redirect.
	*/
	function redirectHeader($url, $time, $messages = null)
	{
		$root =& XCube_Root::getSingleton();
		$root->mController->executeRedirect($url, $time, $messages);
	}
	
	function formatMessage()
	{
		$arr=func_get_args();
		
		if(count($arr)==0)
			return null;

		$message = $arr[0];
		for($i=1;$i<count($arr);$i++) {
			$message=str_replace("{".($i-1)."}",$arr[$i],$message);
		}

		return $message;
	}
	
	function formatMessageByMap($subject,$arr)
	{
		$searches=array();
		$replaces=array();
		foreach($arr as $key=>$value) {
			$searches[]="{".$key."}";
			$replaces[]=$value;
		}

		return str_replace($searches,$replaces,$subject);
	}

    function checkSystemModules() {
        $root=&XCube_Root::getSingleton();
        $systemModules = array_map('trim', explode(',',$root->getSiteConfig('Cube','SystemModules')));
        $recommendedModules = array_map('trim', explode(',',$root->getSiteConfig('Cube','RecommendedModules')));
        $moduleHandler =& xoops_gethandler('module');
        $uninstalledModules = array();
        $disabledModules = array();
        foreach($systemModules as $systemModule) {
            if(!empty($systemModule)) {
                if(!($moduleObject =& $moduleHandler->getByDirname($systemModule))) {
                    $uninstalledModules[] = $systemModule;
                } else if(!$moduleObject->getVar('isactive')) {
                    $disabledModules[] = $systemModule;
                }
            }
        }
        if ((count($uninstalledModules)==0)&&(count($disabledModules)==0)) {
            return true;
        } else {
            return array('uninstalled' =>$uninstalledModules, 'disabled'=>$disabledModules, 'recommended'=>$recommendedModules);
        }
	}
}

?>