<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/class/XCube_PageNavigator.class.php";

class User_PageNavigator extends XCube_PageNavigator
{
	function getRenderSortUrl()
	{
		return parent::renderSortUrl('sort');
	}

	function renderHidden($sort = null)
	{
		if ($mask == null) {
			$mask = array();
		}
		elseif (!is_array($mask)) {
			$mask = array($mask);
		}
	
		$ret = null;
	
		foreach ($this->mExtra as $key => $value) {
			if (!isset($mask[$key])) {
				$value = htmlspecialchars($value, ENT_QUOTES);
				$ret .= "<input type=\"hidden\" name=\"${key}\" value=\"${value}\" />";
			}
		}
	
		return $ret;
	}
	
	/**
	 * Render URL with replacing base url. This method is used to user search list.
	 * 
	 * @param $url string
	 * @param $mask mixed
	 */
	function getRenderOtherUrl($url, $mask = null)
	{
		if ($mask == null) {
			$mask = array();
		}
		if (!is_array($mask)) {
			$mask = array($mask);
		}
		
		if(count($this->mExtra) > 0) {
			$tarr=array();
			
			foreach($this->mExtra as $key=>$value) {
				if (is_array($mask) && !isset($mask[$key])) {
					$tarr[]=$key."=".urlencode($value);
				}
			}
			
			if (count($tarr)==0) {
				return $url;
			}
			
			if(strpos($url,"?")!==false) {
				return $url."&amp;".implode("&amp;",$tarr);
			}
			else {
				return $url."?".implode("&amp;",$tarr);
			}
		}
		
		return $url;
	}
}

?>
