<?php

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * Type:     function
 * Name:     xoops_optionsArray
 * Version:  0.1
 * Date:     Apr 6, 2006
 * Author:   minahito
 * Purpose:  Build option tags from array of object who have value and text in 
             own properties.
 * Input:    from = template variable that is array of object 
 *           label = property name to get the text.
 *           value = property name to get the value.
 *           default = selected value. variable (include Array).
 * 
 * -------------------------------------------------------------
 */
function smarty_function_xoops_optionsArray($params, &$smarty)
{
	//
	// We should check more.
	//
	$tags = "";
	$objectArr =& $params['from'];
	$default = isset($params['default']) ? $params['default'] : null;

	foreach ($objectArr as $object) {
		$value = htmlspecialchars($object->get($params['value']), ENT_QUOTES);
		$label = htmlspecialchars($object->get($params['label']), ENT_QUOTES);
		
		$selected = "";
		if (is_array($default) && in_array($object->get($params['value']), $default)) {
			$selected = " selected=\"selected\"";
		}
		elseif (!is_array($default) && $object->get($params['value']) == $default) {
			$selected = " selected=\"selected\"";
		}
		
		$tags .= "<option value=\"${value}\"${selected}>${label}</option>\n";
	}
	
	print $tags;
}

?>
