<?php
/**
 * @package legacy
 * @version $Id: DefaultAction.class.php,v 1.1.2.4 2006/08/05 06:22:36 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * This action shows two forms for login and lostpass. If the current user is
 * logined, forward to the userinfo page.
 */
class User_DefaultAction extends User_Action
{
	var $_mAllowRegister = false;

	function isSecure()
	{
		return false;
	}
	
	function prepare(&$controller, &$xoopsUser, $moduleConfig)
	{
		parent::prepare($controller, $xoopsUser, $moduleConfig);
		$this->_mAllowRegister = $moduleConfig['allow_register'];
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		return is_object($xoopsUser) ? USER_FRAME_VIEW_ERROR : USER_FRAME_VIEW_INPUT;
	}
	
	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("user_default.html");
		$render->setAttribute('allowRegister', $this->_mAllowRegister);
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("index.php?action=UserInfo&uid=" . $xoopsUser->get('uid'));
	}
}

?>