<?php
// $Id: xoops_form_extend.php,v 1.2 2005/08/09 11:05:23 ohwada Exp $

// 2005-08-09 K.OHWADA
// BUG 2828: submit form is not displayed correctly
// not use add_tray_xxx
// It changed too many

//=========================================================
// Xoops Form Extend
// 2004-12-05 K.OHWADA
//=========================================================

class xoops_form_extend
{
// object
	var $sform;
	var $tray;

// paramter
	var $text_size;
	var $text_max;
	var $text_url_size;
	var $text_url_max;
	var $text_url_default;
	var $textarea_rows;
	var $textarea_clos;
	var $select_size;
	var $select_multiple_default;
	var $max_image_width;
	var $max_image_height;
	var $image_border;
	var $image_alt;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function xoops_form_extend()
{
	$this->set_param_text( 50, 100);
	$this->set_param_text_url( 80, 250, 'http://');
	$this->set_param_textarea( 5, 50);
	$this->set_param_select( 1, false );
	$this->set_param_image( 160, 120, 0, 'image');
}

//---------------------------------------------------------
// form
//---------------------------------------------------------
function start_theme_form($title, $name, $action='')
{
	if ( empty($action) )
	{
		$action = xoops_getenv('PHP_SELF');
	}

	$this->sform = new XoopsThemeForm( $title, $name, $action );

	return $this->sform;
}

function display()
{
	$this->sform->display();
}

//---------------------------------------------------------
// tray
//---------------------------------------------------------
//function start_tray($caption, $delimeter="&nbsp;")
//{
//	$this->tray = new XoopsFormElementTray( $caption, $delimeter );
//	return $this->tray;
//}

//function add_element_tray()
//{
//	$this->sform->addElement( $this->tray );
//}


//---------------------------------------------------------
// simple element
//---------------------------------------------------------
function make_label($caption='', $value='' )
{
	$ele = new XoopsFormLabel($caption, $value);
	return $ele;
}

function make_text($caption, $name, $value='', $size='', $max='')
{
	if (empty($size))  $size = $this->text_size;
	if (empty($max))   $max  = $this->text_max;

	$ele = new XoopsFormText($caption, $name, $size, $max, $value);
	return $ele;
}

function make_text_url($caption, $name, $value='', $size='', $max='')
{
	if (empty($size))  $size  = $this->text_url_size;
	if (empty($max))   $max   = $this->text_url_max;
	if (empty($value)) $value = $this->text_url_default;

	$ele = new XoopsFormText($caption, $name, $size, $max, $value);
	return $ele;
}

function make_textarea($caption, $name, $value='', $rows='', $clos='')
{
	if (empty($rows))  $rows = $this->textarea_rows;
	if (empty($clos))  $clos = $this->textarea_clos;

	$ele = new XoopsFormTextArea($caption, $name, $value, $rows, $clos);
	return $ele;
}

function make_radio_array($caption, $name, $value=null, $options='' )
{
	$ele = new XoopsFormRadio($caption, $name, $value);
	$ele->addOptionArray( $options );
	return $ele;
}

function make_checkbox_array($caption, $name, $value=null, $options='' )
{
	$ele = new XoopsFormCheckBox($caption, $name, $value);
	$ele->addOptionArray( $options );
	return $ele;
}

function make_select_array($caption, $name, $value=null, $options='', $size='', $multiple='' )
{
	if (empty($size))      $size     = $this->select_size;
	if (empty($multiple))  $multiple = $this->select_multiple_default;

	$ele = new XoopsFormSelect($caption, $name, $value, $size, $multiple);
	$ele->addOptionArray( $options );
	return $ele;
}


//---------------------------------------------------------
// complex element
//---------------------------------------------------------
function make_tray_radio_multi($caption, $multi_arr)
{
	$tray = new XoopsFormElementTray( $caption, '' );

	$i = 0;
	$box = array();
	foreach ($multi_arr as $multi)
	{
		list($name, $value, $opt_value, $opt_name) = $multi;

		$box[$i] = new XoopsFormRadio( '', $name, $value );
		$box[$i]->addOption($opt_value, $opt_name);
		$tray->addElement( $box[$i] );

		$i ++;
	}

	return $tray;
}

function make_tray_checkbox_multi($caption, $multi_arr)
{
	$tray = new XoopsFormElementTray( $caption, '' );

	$i = 0;
	$box = array();
	foreach ($multi_arr as $multi)
	{
		list($name, $value, $opt_value, $opt_name) = $multi;

		$box[$i] = new XoopsFormCheckBox( '', $name, $value );
		$box[$i]->addOption($opt_value, $opt_name);
		$tray->addElement( $box[$i] );

		$i ++;
	}

	return $tray;
}

function make_tray_label_text($caption, $value1, $name2, $value2, $size='', $max='', $del="<br />\n" )
{
//	$this->start_tray($caption, $del);
//	$this->add_tray_label( '', $value1 );
//	$this->add_tray_text( '', $name2, $value2, $size, $max );
//	return $this->tray;

	$tray = new XoopsFormElementTray( $caption, $del );
	$tray->addElement( new XoopsFormLabel('', $value1) );
	$tray->addElement( $this->make_text('', $name2, $value2, $size, $max) );
	return $tray;
}

function make_tray_label_textarea($caption, $value1, $name2, $value2, $rows='', $clos='', $del="<br />\n" )
{
//	$this->start_tray($caption, $del);
//	$this->add_tray_label( '', $value1 );
//	$this->add_tray_textarea( '', $name2, $value2, $rows, $clos);
//	return $this->tray;

	$tray = new XoopsFormElementTray( $caption, $del );
	$tray->addElement( new XoopsFormLabel('', $value1) );
	$tray->addElement( $this->make_textarea('', $name2, $value2, $rows, $clos) );
	return $tray;
}

function make_tray_label_radio($caption, $value1, $name2, $value2, $options, $del="<br />\n" )
{
//	$this->start_tray($caption, $del);
//	$this->add_tray_label( '', $value1 );
//	$this->add_tray_radio_array('', $name2, $value2, $options );
//	return $this->tray;

	$tray = new XoopsFormElementTray( $caption, $del );
	$tray->addElement( new XoopsFormLabel('', $value1) );
	$tray->addElement( $this->make_radio_array('', $name2, $value2, $options ) );
	return $tray;
}

function make_tray_label_checkbox($caption, $value1, $name2, $value2, $options, $del="<br />\n" )
{
//	$this->start_tray($caption, $del);
//	$this->add_tray_label( '', $value1 );
//	$this->add_tray_checkbox_array('', $name2, $value2, $options );
//	return $this->tray;

	$tray = new XoopsFormElementTray( $caption, $del );
	$tray->addElement( new XoopsFormLabel('', $value1) );
	$tray->addElement( $this->make_checkbox_array('', $name2, $value2, $options ) );
	return $tray;
}

function make_tray_label_select($caption, $value1, $name2, $value2, $options='', $size='', $multiple='', $del="<br />\n" )
{
//	$this->start_tray($caption, $del);
//	$this->add_tray_label( '', $value1 );
//	$this->add_tray_select_array( '', $name2, $value2, $options, $size, $multiple );
//	return $this->tray;

	$tray = new XoopsFormElementTray( $caption, $del );
	$tray->addElement( new XoopsFormLabel('', $value1) );
	$tray->addElement( $this->make_select_array('', $name2, $value2, $options, $size, $multiple ) );
	return $tray;
}

function make_tray_text_radio($caption, $name1, $value1, $name2, $value2, $options, $size='', $max='', $del="<br />\n" )
{
//	$this->start_tray($caption, $del);
//	$this->add_tray_text( '', $name1, $value1, $size, $max );
//	$this->add_tray_radio_array('', $name2, $value2, $options );
//	return $this->tray;

	$tray = new XoopsFormElementTray( $caption, $del );
	$tray->addElement( $this->make_text('', $name1, $value1, $size, $max) );
	$tray->addElement( $this->make_radio_array('', $name2, $value2, $options ) );
	return $tray;
}

function make_tray_text_url_radio($caption, $name1, $value1, $name2, $value2, $options, $size='', $max='', $del="<br />\n" )
{
//	$this->start_tray($caption, $del);
//	$this->add_tray_text_url( '', $name1, $value1, $size, $max );
//	$this->add_tray_radio_array('', $name2, $value2, $options );
//	return $this->tray;

	$tray = new XoopsFormElementTray( $caption, $del );
	$tray->addElement( $this->make_text_url('', $name1, $value1, $size, $max) );
	$tray->addElement( $this->make_radio_array('', $name2, $value2, $options ) );
	return $tray;
}

function make_tray_text_url_visit($caption, $name, $value, $mark, $size='', $max='', $target='_blank', $del=" " )
{
//	$this->start_tray($caption, '');
//	$this->add_tray_text_url( '', $name, $value, $size, $max );
//	if ($value)
//	{
//		$link = $this->make_url_link($value, $mark, $target);
//		$this->add_tray_label( '', $del.$link );
//	}
//	return $this->tray;

	$tray = new XoopsFormElementTray( $caption, '' );
	$tray->addElement( $this->make_text_url('', $name, $value, $size, $max) );

	if ($value)
	{
		$link = $this->make_url_link($value, $mark, $target);
		$tray->addElement( new XoopsFormLabel('', $del.$link) );
	}

	return $tray;
}

function make_tray_text_url_image($caption, $name, $value, $size='', $max='', $border='', $alt='', $del="<br /><br />\n" )
{
//	$this->start_tray($caption, '');
//	$this->add_tray_text_url( '', $name, $value, $size, $max );
//	if ($value)
//	{
//		$this->add_tray_label( '', $del );
//		$this->add_tray_image( '', $value, $border, $alt );
//	}
//	return $this->tray;

	$tray = new XoopsFormElementTray( $caption, '' );
	$tray->addElement( $this->make_text_url('', $name, $value, $size, $max) );

	if ($value)
	{
		$tray->addElement( new XoopsFormLabel('', $del) );
		$tray->addElement( $this->make_image('', $value, $border, $alt ) );
	}

	return $tray;
}

function make_image($caption, $url, $border='', $alt='', $max_width='', $max_height='' )
{
	if (empty($border))     $border     = $this->image_border;
	if (empty($alt))        $alt        = $this->image_alt;
	if (empty($max_width))  $max_width  = $this->max_image_width;
	if (empty($max_height)) $max_height = $this->max_image_height;

	$link = $this->make_image_link( $url, $border, $alt, $max_width, $max_height );
	$ele  = new XoopsFormLabel($caption, $link );
	return $ele;
}

//---------------------------------------------------------
// button element
//---------------------------------------------------------
function make_submit_button($caption, $name, $value='')
{
	$ele = new XoopsFormButton($caption, $name, $value, 'submit');
	return $ele;
}

function make_cancel_button($caption, $name, $value='')
{
	$extra = " onclick=\"javascript:history.go(-1)\" ";
	$ele = new XoopsFormButton($caption, $name, $value, 'button');
	$ele->setExtra($extra, true);
	return $ele;
}

function make_jump_button($caption, $name, $value='', $url)
{
	$extra = " onClick=\"location='".$url."'\" ";
	$ele = new XoopsFormButton($caption, $name, $value, 'button');
	$ele->setExtra($extra, true);
	return $ele;
}


//---------------------------------------------------------
// add elemnet to tray
//---------------------------------------------------------
//function add_tray(&$formElement, $required=false)
//{
//	$this->tray->addElement($formElement, $required);
//	return $this->tray;
//}

//function add_tray_label($caption='', $value='' )
//{
//	$this->tray->addElement( new XoopsFormLabel($caption, $value) );
//	return $this->tray;
//}


//---------------------------------------------------------
// add elemnet to tray : use make_xxx
//---------------------------------------------------------
//function add_tray_text($caption, $name, $value='', $size='', $max='' )
//{
//	$this->tray->addElement(  $this->make_text($caption, $name, $value, $size, $max) );
//	return $this->tray;
//}

//function add_tray_text_url($caption, $name, $value='', $size='', $max='' )
//{
//	$this->tray->addElement(  $this->make_text_url($caption, $name, $value, $size, $max) );
//	return $this->tray;
//}

//function add_tray_textarea($caption, $name, $value='', $rows='', $clos='')
//{
//	$this->tray->addElement(  $this->make_textarea($caption, $name, $value, $rows, $clos) );
//	return $this->tray;
//}

//function add_tray_radio_array($caption, $name, $value=null, $options='' )
//{
//	$this->tray->addElement( $this->make_radio_array($caption, $name, $value, $options ) );
//	return $this->tray;
//}

//function add_tray_checkbox_array($caption, $name, $value=null, $options='' )
//{
//	$this->tray->addElement( $this->make_checkbox_array($caption, $name, $value, $options ) );
//	return $this->tray;
//}

//function add_tray_select_array($caption, $name, $value=null, $options='', $size='', $multiple='' )
//{
//	$this->tray->addElement( $this->make_select_array($caption, $name, $value, $options, $size, $multiple ) );
//	return $this->tray;
//}

//function add_tray_image($caption, $url, $border='', $alt='', $max_width='', $max_height='' )
//{
//	$this->tray->addElement( $this->make_image($caption, $url, $border, $alt, $max_width, $max_height ) );
//	return $this->tray;
//}

//function add_tray_submit_button($caption, $name, $value='')
//{
//	$this->tray->addElement( $this->make_submit_button( $caption, $name, $value ) );
//	return $this->tray;
//}

//function add_tray_jump_button($caption, $name, $value='', $url='')
//{
//	$this->tray->addElement( $this->make_jump_button( $caption, $name, $value, $url ) );
//	return $this->tray;
//}

//function add_tray_cancel_button($caption, $name, $value)
//{
//	$this->tray->addElement( $this->make_cancel_button( $caption, $name, $value ) );
//	return $this->tray;
//}

//---------------------------------------------------------
// add element to form
//---------------------------------------------------------
function add_element(&$formElement, $required=false)
{
	$this->sform->addElement( $formElement, $required );
}

function add_label($caption='', $value='')
{
	$this->sform->addElement( new XoopsFormLabel($caption, $value) );
}

function add_hidden($name, $value)
{
	$this->sform->addElement( new XoopsFormHidden($name, $value) );
}

function add_radio_yn($caption, $name, $value=null, $required=false )
{
	$this->sform->addElement( new XoopsFormRadioYN( $caption, $name, $value), $required );
}

function add_caption_full($caption, $desc='', $class='head')
{
	$ele = $this->make_caption($caption, $desc);
	$this->sform->insertBreak($ele, $class);
}

function add_text_full($name, $value='', $size='', $max='', $class='even')
{
	$ele = $this->make_text('', $name, $value, $size, $max);
	$this->sform->insertBreak($ele->render(), $class);
}


//---------------------------------------------------------
// add element to form: use make_xxx
//---------------------------------------------------------
function add_text($caption, $name, $value='', $required=false)
{
	$this->sform->addElement( $this->make_text($caption, $name, $value), $required);
}

function add_text_url($caption, $name, $value='', $required=false)
{
	$this->sform->addElement( $this->make_text_url($caption, $name, $value), $required);
}

function add_textarea($caption, $name, $value='', $required=false)
{
	$this->sform->addElement( $this->make_textarea($caption, $name, $value), $required);
}

function add_radio_array($caption, $name, $value=null, $options='', $required=false )
{
	$this->sform->addElement( $this->make_radio_array($caption, $name, $value, $options), $required);
}

function add_checkbox_array($caption, $name, $value=null, $options='', $required=false )
{
	$this->sform->addElement( $this->make_checkbox_array($caption, $name, $value, $options), $required);
}

function add_select_array($caption, $name, $value=null, $options='', $required=false )
{
	$this->sform->addElement( $this->make_select_array($caption, $name, $value, $options), $required);
}

function add_radio_multi($caption, $multi_arr)
{
	$this->sform->addElement( $this->make_tray_radio_multi($caption, $multi_arr) );
}

function add_checkbox_multi($caption, $multi_arr )
{
	$this->sform->addElement( $this->make_tray_checkbox_multi($caption, $multi_arr) );
}

function add_label_text($caption, $value1, $name2, $value2, $size='', $max='', $del="<br />\n" )
{
	$this->sform->addElement( $this->make_tray_label_text($caption, $value1, $name2, $value2, $size, $max, $del ) );
}

function add_label_textarea($caption, $value1, $name2, $value2, $rows='', $clos='', $del="<br />\n" )
{
	$this->sform->addElement( $this->make_tray_label_textarea($caption, $value1, $name2, $value2, $rows, $clos, $del ) );
}

function add_label_radio($caption, $value1, $name2, $value2, $options, $del="<br />\n" )
{
	$this->sform->addElement( $this->make_tray_label_radio($caption, $value1, $name2, $value2, $options, $del) );
}

function add_label_checkbox($caption, $value1, $name2, $value2, $options, $del="<br />\n" )
{
	$this->sform->addElement( $this->make_tray_label_checkbox($caption, $value1, $name2, $value2, $options, $del) );
}

function add_label_select($caption, $value1, $name2, $value2, $options='', $size='', $multiple='', $del="<br />\n" )
{
	$this->sform->addElement( $this->make_tray_label_select($caption, $value1, $name2, $value2, $options, $size, $multiple, $del ) );
}

function add_text_radio($caption, $name1, $value1, $name2, $value2, $options, $size='', $max='', $del="<br />\n" )
{
	$this->sform->addElement( $this->make_tray_text_radio($caption, $name1, $value1, $name2, $value2, $options, $size, $max, $del ) );
}

function add_text_url_radio($caption, $name1, $value1, $name2, $value2, $options, $size='', $max='', $del="<br />\n" )
{
	$this->sform->addElement( $this->make_tray_text_url_radio($caption, $name1, $value1, $name2, $value2, $options, $size, $max, $del ) );
}

function add_text_url_visit($caption, $name, $value, $mark, $size='', $max='', $target='_blank', $del=" " )
{
	$this->sform->addElement( $this->make_tray_text_url_visit($caption, $name, $value, $mark, $size, $max, $target, $del ) );
}

function add_text_url_image($caption, $name, $value, $size='', $max='', $border='', $alt='', $del="<br /><br />\n" )
{
	$this->sform->addElement( $this->make_tray_text_url_image($caption, $name, $value, $size, $max, $border, $alt, $del ) );
}


//---------------------------------------------------------
// add button to form
//---------------------------------------------------------
function add_submit_button($caption, $name, $value='')
{
	$this->sform->addElement( $this->make_submit_button($caption, $name, $value) );
}

function add_submit_submit_button($caption, $name1, $value1, $name2, $value2='')
{
//	$this->start_tray($caption);
//	$this->add_tray_submit_button('', $name1, $value1);
//	$this->add_tray_submit_button('', $name2, $value2);
//	$this->sform->addElement( $this->tray );

	$ele_submit1 = $this->make_submit_button( '', $name1, $value1 );
	$ele_submit2 = $this->make_submit_button( '', $name2, $value2 );

	$tray = new XoopsFormElementTray( $caption );
	$tray->addElement( $ele_submit1 );
	$tray->addElement( $ele_submit2 );
	$this->sform->addElement( $tray );
}

function add_submit_cancel_button($caption, $name1, $value1, $name2, $value2='')
{
//	$this->start_tray($caption);
//	$this->add_tray_submit_button('', $name1, $value1);
//	$this->add_tray_cancel_button('', $name2, $value2);
//	$this->sform->addElement( $this->tray );

	$ele_submit = $this->make_submit_button( '', $name1, $value1 );
	$ele_cancel = $this->make_cancel_button( '', $name2, $value2 );

	$tray = new XoopsFormElementTray( $caption );
	$tray->addElement( $ele_submit );
	$tray->addElement( $ele_cancel );
	$this->sform->addElement( $tray );
}

function add_submit_jump_button($caption, $name1, $value1, $name2, $value2='', $url2='')
{
//	$this->start_tray($caption);
//	$this->add_tray_submit_button('', $name1, $value1);
//	$this->add_tray_jump_button(  '', $name2, $value2, $url2);
//	$this->sform->addElement( $this->tray );
	
	$ele_submit = $this->make_submit_button( '', $name1, $value1 );
	$ele_jump   = $this->make_jump_button( '', $name2, $value2, $url2 );

	$tray = new XoopsFormElementTray( $caption );
	$tray->addElement( $ele_submit );
	$tray->addElement( $ele_jump );
	$this->sform->addElement( $tray );

}


//---------------------------------------------------------
// others
//---------------------------------------------------------
function make_caption($caption, $desc='')
{
	$ele = $caption;
	
	if ($desc)
	{
		$ele .= "<br /><br /><span style='font-weight: normal;'>".$desc."</span>";
	}

	return $ele;
}


//---------------------------------------------------------
// HTML link
//---------------------------------------------------------
function make_url_link($url, $name='', $target='')
{
	$url = $this->conv_js( $url );

	if ( $url && $name && $target )
	{
		$link = "<a href='".$url."' target='".$target."'>".$name."</a>";
	}
	elseif ( $url && $name )
	{
		$link = "<a href='".$url."'>".$name."</a>";
	}
	elseif ( $url && $target )
	{
		$link = "<a href='".$url."' target='".$target."'>".$url."</a>";
	}
	elseif ( $url )
	{
		$link = "<a href='".$url."'>".$url."</a>";
	}
	elseif ( $name )
	{
		$link = $name;
	}
	else
	{
		$link = '';
	}

	return $link;
}

function conv_js($text)
{
	return preg_replace('/javascript:/si' , 'java script:', $text);
}

//---------------------------------------------------------
// image
//---------------------------------------------------------
function make_image_link($image_url, $border=0, $alt='image', $max_width='', $max_height='')
{
	if (empty($max_width))  $max_width  = $this->max_image_width;
	if (empty($max_height)) $max_height = $this->max_image_height;

// read remote file
	list($width, $height) = $this->get_remote_image_size($image_url);

// size exist
	if ($width && $height)
	{
		list ($width, $height) = 
			$this->adjust_image_size($width, $height, $max_width, $max_height);
	}

	$link = $this->build_image_link($image_url, $width, $height, $border, $alt);

	return $link;
}

function get_remote_image_size($image_url)
{
	if (empty($image_url)) { return array(0,0); }

// read remote file
	$size = GetImageSize($image_url);	// PHP function
	if (!$size) { return array(0,0); }

	$width  = intval( $size[0] );
	$height = intval( $size[1] );

	return array($width, $height);
}

function adjust_image_size($width, $height, $max_width, $max_height)
{
	if ($width > $max_width)
    {
    	$mag    = $max_width/$width;
    	$width  = $max_width;
    	$height = $height*$mag;
    }

	if ($height > $max_height)
    {
    	$mag    = $max_height/$height;
    	$height = $max_height;
    	$width  = $width*$mag;
    }

    $width  = (int)$width;
    $height = (int)$height;

	return array($width, $height);
}

function build_image_link($image_url, $width=0, $height=0, $border=0, $alt='image')
{
	if ( !$image_url )               return false;
	if (  $image_url == "http://" )  return false;

	$image_src = htmlspecialchars( $image_url, ENT_QUOTES );

	$link  = "<img ";
	$link .= "src='$image_src' ";

	if ($width)
	{
		$link .= "width='$width' ";
	}

	if ($height)
	{
		$link .= "height='$height' ";
	}

	$link .= "border='$border' ";
	$link .= "alt='$alt' ";
	$link .= "/>";

	return $link;
}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function set_param_text($size, $max)
{
	$this->text_size = intval($size);
	$this->text_max  = intval($max);
}

function set_param_text_url($size, $max, $default='http://')
{
	$this->text_url_size = intval($size);
	$this->text_url_max  = intval($max);
	$this->text_url_default = $default;
}

function set_param_textarea($rows, $cols)
{
	$this->textarea_rows = intval($rows);
	$this->textarea_clos = intval($cols);
}

function set_param_select($size, $multiple=false)
{
	$this->select_size             = intval($size);
	$this->select_multiple_default = $multiple;
}

function set_param_image($width, $height, $border=0, $alt='image')
{
	$this->max_image_width  = intval($width);
	$this->max_image_height = intval($height);
	$this->image_border     = intval($border);
	$this->image_alt        = $alt;
}


//---------------------------------------------------------
}


?>
