<?php // vim: ts=4 sw=4 sts=4 fdm=marker ai noet:
/* $Id: vim2html.inc.php,v 1.3 2004/12/01 19:11:35 ishii Exp $
vim
:runtime! syntax/2html.vim
¹Ԥƽhtmlwikiϰɽ롣
եϡͽźդƤ
[]
ɽ
#vim2html(hoge.cpp.html)
ϰ֤Τ߻
#vim2html(hoge.cpp.html, 10)
ϰ֡λ֤
#vim2html(hoge.cpp.html, 10, 50)
*/

// {{{ plugin_vim2html_convert()

function plugin_vim2html_convert()
{
	global $vars;

	list( $file, $beg, $end ) = func_get_args();

	//顼å
	if ( func_num_args() < 1 || empty( $file ) )
	{
		return '<p>invalid argument(s).</p>';
	}

	$a = plugin_vim2html_body( $file, $vars['page'] );

	if( ! is_array($a) ) return "<p>file not found.[$file]</p>";
	if( ! isset($end) ) $end = count($a) - 3;
	if( ! isset($beg) ) $beg = 1;

	if( ! preg_match("/name=\"Generator\" content=\"Vim\//i", $a[3] ) )
	{
		return "<p>invalid html (only generated by VIM)</p>";
	}

	$bgcolor = trim( preg_replace("/.*bgcolor=\"(.*)\" text.*/", "\\1", $a[5] ) );
	$color = trim( preg_replace("/.*text=\"(.*)\".*/", "\\1", $a[5] ) );
	$ret = "<pre style=\"background-color: {$bgcolor}; color: {$color};\">";

	for( $i = $beg + 6; $i <= $end + 6; $i++ )
	{
		if( $i >= count($a) - 3 ) break;
		$ret .= $a[$i];
	}

	$ret .= "</pre>";

	return $ret;
}

// }}}
// {{{ plugin_vim2html_body()

function plugin_vim2html_body( $file, $page )
{
	global $WikiName,$BracketName;

	// ΰڡ̾ɤ
	if( preg_match("/^($WikiName|\[\[$BracketName\]\])$/", $file) )
	{
		$_page = get_fullname(strip_bracket( $file ), $page );
		if( is_pagename( $_page ) )
		{
			$page = $_page;
		}
	}

	$name = $file;

	if( preg_match('/^(.+)\/([^\/]+)$/', $name, $matches ) )
	{
		if( $matches[1] == '.' || $matches[1] == '..' )
		{
			$matches[1] .= '/';
		}
		$page = get_fullname( $matches[1], $page );
		$name = $matches[2];
	}

	$title = htmlspecialchars( $name );
	$file = "attach/" . encode( $page ) . '_' . encode( $name );
	if( ! is_file( $file ) )
	{
		return "<p>file not found.==> $file</p>";
	}

	$html_arr = @file( $file );

	return $html_arr;
}

// }}}

?>
