<?php
// $Id: atom_auto.php,v 1.1.1.2 2005/06/10 18:28:55 ohwada Exp $

// 2004-09-01 K.OHWADA
// use whatsnew_convert_array_array_from_utf8()

//=========================================================
// What's New Module
// ATOM auto discovery and and view
// 2004-08-22 K.OHWADA
//=========================================================

include "../../mainfile.php";
include_once XOOPS_ROOT_PATH.'/modules/whatsnew/class/class.atom_parser.php';
include_once XOOPS_ROOT_PATH.'/modules/whatsnew/include/func.rss_atom_auto.php';
include_once XOOPS_ROOT_PATH.'/modules/whatsnew/include/func.lang.php';

include XOOPS_ROOT_PATH."/header.php";

$TEMPLATE = 'db:whatsnew_atom_view.html';

$op = '';
$url_html = '';
$url_atom = '';

if ( isset($_POST['op']) )  $op = $_POST['op'];

if ( $op != 'atom' )
{
	$url_html = XOOPS_URL."/";
}

if ( isset($_POST['html']) ) $url_html = $_POST['html'];
if ( isset($_POST['atom']) ) $url_atom = $_POST['atom'];

?>
<h3><?php echo _WHATSNEW_NAME; ?></h3>
<h4><?php echo _WHATSNEW_ATOM_AUTO; ?></h4>
<hr>
<form action="atom_auto.php" method="post">
<input type="hidden" name="op" value="html">
HTML URL: <input type="text" name="html" value="<?php echo $url_html; ?>" size="100">
<input type="submit" value="<?php echo _WHATSNEW_AUTO; ?>">
</form>
HTML URL: <a href="<?php echo $url_html; ?>" target="_blank"><?php echo $url_html; ?></a><br>
<hr>
<?php

if ( $op != 'atom' )
{
	$data_html = get_remote_file($url_html);
	if ($data_html == false)
	{
		print "<h4><font color='red'>"._WHATSNEW_ERROR_CONNCET."</font></h4>\n";
		print "$url_html<br />\n";
		include XOOPS_ROOT_PATH.'/footer.php';
		exit();
	}

	list($url_rss, $url_atom) = get_rss_atom_link($data_html);
}

?>
<form action="atom_auto.php" method="post">
<input type="hidden" name="op" value="atom">
ATOM URL: <input type="text" name="atom" value="<?php echo $url_atom; ?>" size="100">
<input type="submit" value="<?php echo _WHATSNEW_SET; ?>">
</form>
ATOM URL: <a href="<?php echo $url_atom; ?>" target="_blank"><?php echo $url_atom; ?></a><br>
<hr>
<?php

if (empty($url_atom))
{
	print "<h4><font color='red'>"._WHATSNEW_ERROR_ATOM_AUTO."</font></h4>";
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$data_atom = get_remote_file($url_atom);
if ($data_atom == false)
{
	print "<h4><font color='red'>"._WHATSNEW_ERROR_CONNCET."</font></h4>\n";
	print "$url_atom<br />\n";
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

if (empty($data_atom))
{
	print "<h4><font color='red'>"._WHATSNEW_ERROR_ATOM_GET."</font></h4>";
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$parser = new atom_parser();

$ret = $parser->parse_data($data_atom);
if ($ret) 
{
	print "<h4><font color='red'>"._WHATSNEW_ERROR_PARSE."</font></h4>";
	print $parser->get_error()."<br />\n";

	print "<pre>-----\n";
	print htmlspecialchars($data_atom);
	print "-----</pre>\n";

	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$feed   = whatsnew_convert_array_from_utf8( $parser->get_feed() );
$entrys = whatsnew_convert_array_array_from_utf8( $parser->get_entrys() );

$tpl = new XoopsTpl();
$tpl->assign_by_ref('feed', $feed);

$tpl->assign(
	array(
		'lang_id'           => _WHATSNEW_ID,
		'lang_modified'     => _WHATSNEW_MODIFIED,
		'lang_issued'       => _WHATSNEW_ISSUED,
		'lang_created'      => _WHATSNEW_CREATED,
		'lang_generator'    => _WHATSNEW_GENERATOR,
		'lang_copyright'    => _WHATSNEW_COPYRIGHT,
		'lang_title'        => _WHATSNEW_TITLE,
		'lang_category'     => _WHATSNEW_CATEGORY,
		'lang_summary'      => _WHATSNEW_SUMMARY,
		'lang_content'      => _WHATSNEW_CONTENT,
		'lang_author_name'  => _WHATSNEW_AUTHOR_NAME,
		'lang_author_url'   => _WHATSNEW_AUTHOR_URL,
		'lang_author_email' => _WHATSNEW_AUTHOR_EMAIL,
		'lang_category'     => _WHATSNEW_CATEGORY,
		'lang_more'         => _MORE
	));

$count = count($entrys);
for ($i = 0; $i < $count; $i++)
{
	$tpl->append_by_ref('entrys', $entrys[$i]);
}

print $tpl->fetch($TEMPLATE);

include XOOPS_ROOT_PATH.'/footer.php';
exit();

?>
