<?php
// $Id: func.rdf.php,v 1.3 2005/08/09 02:17:10 ohwada Exp $

// 2005-08-08 K.OHWADA
// description became one line
// BUG 2824: the CDATA-section-close delimiter "]]>" MUST be escaped "]]&gt;"
// BUG 2823: date must be an W3CDTF date

// 2005-06-20 K.OHWADA
// add whatsnew_view_rdf()
// use ConvertLanguage()
// use version.php

//=========================================================
// What's New Module
// build RDF 
// http://www.hoshiba-farm.com/
// 2005-05-06 hoshiyan
//=========================================================

include_once XOOPS_ROOT_PATH.'/class/template.php';
include_once XOOPS_ROOT_PATH.'/modules/whatsnew/include/func.whatsnew.php';
include_once XOOPS_ROOT_PATH."/modules/whatsnew/include/version.php";
include_once XOOPS_ROOT_PATH.'/modules/whatsnew/class/base_language.php';

// for local language
$file_convert = XOOPS_ROOT_PATH.'/modules/whatsnew/language/'.$xoopsConfig['language'].'/convert_language.php';

if (file_exists( $file_convert )) 
{
	include_once $file_convert;
}
else
{
	include_once XOOPS_ROOT_PATH.'/modules/whatsnew/language/english/convert_language.php';
}

function whatsnew_build_rdf($cache_time=0)
{
	$TEMPLATE    = 'db:whatsnew_rdf.html';
	$FILE_CONFIG = XOOPS_ROOT_PATH."/modules/whatsnew/cache/conf.php";

	if ( file_exists($FILE_CONFIG) ) 
	{
		include $FILE_CONFIG;
	}
	else
	{
		return;
	}

// no output encode
	if (function_exists('mb_http_output')) 
	{	mb_http_output('pass');	}

	header ('Content-Type:text/xml; charset=utf-8');

	$tpl = new XoopsTpl();

	if ($cache_time > 0)
	{
		$tpl->xoops_setCaching(2);
		$tpl->xoops_setCacheTime($cache_time);
	}

	if ( !$tpl->is_cached($TEMPLATE) || ($cache_time == 0) ) 
	{
		$article_arr = whatsnew_get_new($whatsnew_module, 'rss_show', 'rss_limit', $whatsnew_rss_limit_show);
		whatsnew_assign_rdf( $tpl, $article_arr, $whatsnew_config );
	}

	$tpl->display($TEMPLATE);
}

function whatsnew_view_rdf()
{
	$TEMPLATE    = 'db:whatsnew_rdf.html';
	$FILE_CONFIG = XOOPS_ROOT_PATH."/modules/whatsnew/cache/conf.php";

	if ( file_exists($FILE_CONFIG) ) 
	{
		include $FILE_CONFIG;
	}
	else
	{
		return;
	}

	header ('Content-Type:text/html; charset=utf-8');

	$tpl = new XoopsTpl();

	$article_arr = whatsnew_get_new($whatsnew_module, 'rss_show', 'rss_limit', $whatsnew_rss_limit_show);
	whatsnew_assign_rdf( $tpl, $article_arr, $whatsnew_config );

	$xml  = $tpl->fetch($TEMPLATE);
	$body = htmlspecialchars( $xml, ENT_QUOTES );

?>
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title>whats new rss</title>
</head>
<body>
<pre>
<?php echo $body; ?>
</pre>
</body>
</html>
<?php

}

//---------------------------------------------------------
// http://blogs.law.harvard.edu/tech/rss
// required paramter
// channel elements 
//   - title
//   - link
//   - description
// item elements
//   - title
//   - link
//   - description
//---------------------------------------------------------
function whatsnew_assign_rdf( &$tpl, $article_arr, $config )
{
	$lang = new ConvertLanguage();

//	$GENERATOR = 'XOOPS WhatsNew '._WHATSNEW_VERSION;
	$GENERATOR = $config['site_url'];

	$site_name_utf8 = $lang->convert_to_utf8( htmlspecialchars( $config['site_name'], ENT_QUOTES) );
	$tpl->assign('channel_title', $site_name_utf8 );

	$site_url = $config['site_url'];
	$tpl->assign('channel_link', $site_url);

	$tpl->assign('channel_desc', $lang->convert_to_utf8( htmlspecialchars( $config['site_desc'], ENT_QUOTES) ) );

// BUG 2823: date must be an W3CDTF date
	$lastbuild = whatsnew_iso8601_date( time() );

	$tpl->assign('channel_lastbuild', $lastbuild);

	$tpl->assign('channel_generator', $GENERATOR);
	$tpl->assign('channel_language', _LANGCODE);

	if ( isset($config['image_url']) )
	{
		$tpl->assign('image_url',    $config['image_url'] );
		$tpl->assign('image_title',  $site_name_utf8 );
		$tpl->assign('image_link',   $site_url );
	}

	$max_summary = $config['rss_max_summary'];

	foreach ($article_arr as $article)
	{
		$title = $lang->convert_to_utf8( htmlspecialchars ($article['title'], ENT_QUOTES) );
		$link  = $article['link'];

		$pubdate = '';
		if ( isset($article['time']) )
		{
// BUG 2823: date must be an W3CDTF date
			$pubdate = whatsnew_iso8601_date( $article['time'] );
		}

		$desc    = '';
		$content = '';
		if ( isset($article['description']) )
		{
			$desc1 = $article['description'];
			$desc1 = whatsnew_sanitize_control_code($desc1);

// description became one line
			$desc = whatsnew_sanitize_crlf( $desc1 );

			$desc = strip_tags($desc);
			$desc = whatsnew_shorten_text( $desc, $max_summary );
			$desc = whatsnew_htmlspecialchars($desc);
			$desc = $lang->convert_to_utf8( $desc );

// BUG 2824: the CDATA-section-close delimiter "]]>" MUST be escaped "]]&gt;"
			$content = whatsnew_convert_cdata( $desc1 );
			$content = $lang->convert_to_utf8( $content );
		}

		$tpl->append('items', 
			array(
				'title'       => $title,
				'link'        => $link,
				'pubdate'     => $pubdate, 
				'description' => $desc,
				'content'     => $content
			));
	}

}

function whatsnew_clear_rdf()
{
	$TEMPLATE = 'db:whatsnew_rdf.html';

	$tpl = new XoopsTpl();
	$tpl->clear_cache($TEMPLATE);
}

?>
