<?php
// $Id: index.php,v 1.2 2005/06/21 14:38:58 ohwada Exp $

// 2005-06-20 K.OHWADA
// set image width & height
// use whatsnew_set_desc_short
// measure time

// 2005-06-06 K.OHWADA
// renewal

//=========================================================
// What's New Module
// 2004/08/20 K.OHWADA
//=========================================================

include "../../mainfile.php";
include_once XOOPS_ROOT_PATH."/modules/whatsnew/include/func.whatsnew.php";
include_once XOOPS_ROOT_PATH."/modules/whatsnew/include/func.rss.php";
include_once XOOPS_ROOT_PATH."/modules/whatsnew/include/func.atom.php";
include_once XOOPS_ROOT_PATH."/modules/whatsnew/include/func.ping.php";

$FILE_CONFIG = XOOPS_ROOT_PATH."/modules/whatsnew/cache/conf.php";

// dont send ping, even when it overlaps with modify article.
// dont send within short time.  
$TIME_PROHIBIT = 180;	// 180 sec

include XOOPS_ROOT_PATH."/header.php";

// measure time
whatsnew_time_start();

if ( file_exists($FILE_CONFIG) ) 
{
	include $FILE_CONFIG;
}
else
{
	echo "<font color='red'>"._WHATSNEW_WARNING_NOT_EXIST."</font><br>\n";
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$xoopsOption['template_main'] = "whatsnew_index.html";
$xoopsTpl->assign('rss_valid',   _WHATSNEW_RSS_VALID);

// module name
$module_name = $xoopsModule->getVar('name');
$xoopsTpl->assign('module_name', $module_name);

// happy_linux_url
include_once XOOPS_ROOT_PATH."/modules/whatsnew/class/base_language.php";
$lang = new ConvertLanguage();
$happy_linux_url = $lang->get_happy_linux_url();
$xoopsTpl->assign('happy_linux_url',  $happy_linux_url);

// get new from each module
$j = 0;
$block = array();

foreach ( $whatsnew_module as $dirname => $module) 
{
	if ($module['new_show'] != 1)  { continue; }

	$mid   = $module['mid'];
	$name  = $module['name'];
	$limit = $module['new_limit'];

// check if user has perm
	global $xoopsUser;
	$groups = ( is_object($xoopsUser) ) ? $xoopsUser->getGroups() : XOOPS_GROUP_ANONYMOUS;
	$moduleperm_handler =& xoops_gethandler('groupperm');
	// user has module access perm ?
	if (!$moduleperm_handler->checkRight('module_read', $mid, $groups)) 
	{	continue;	}

	$block[$j]['modulename'] = htmlspecialchars( $name, ENT_QUOTES );

	$dirname_show = $dirname;
	if ($dirname_show == 'system')
	{
		$dirname_show = '';
	}

	$block[$j]['dirname'] = htmlspecialchars($dirname_show, ENT_QUOTES );

	$article_arr = whatsnew_get_new_from_module($dirname, $limit);
	if ( !is_array($article_arr) || (count($article_arr) == 0) )
	{	continue;	}

	$i = 0;

	foreach ($article_arr as $article)
	{
		$line = array();

		$line['title'] = htmlspecialchars( $article['title'], ENT_QUOTES );
		$line['link']  = $article['link'];
		$line['date']  = formatTimestamp( $article['time'], 'm' );

// set image width & height
		list($image, $width, $height) = whatsnew_set_image($article, $whatsnew_new_image, $whatsnew_new_max_width, $whatsnew_new_max_height);

		$line['image']  = $image;
		$line['width']  = $width;
		$line['height'] = $height;

// set short description
		$line['desc'] = '';
		if ($i < $whatsnew_new_limit_summary)
		{
//			$desc = $article['description'];
//			$desc = whatsnew_sanitize_control_code($desc);
//			$desc = preg_replace("/(<br>){2,}/is",    "<br />", $desc);
//			$desc = preg_replace("/(<br \/>){2,}/is", "<br />", $desc);
//			$desc = strip_tags($desc);
//			$line['desc'] = whatsnew_shorten_text( $desc, $whatsnew_new_max_summary );

// use whatsnew_set_desc_short
			$line['desc'] = whatsnew_set_desc_short($article['description'], $whatsnew_new_max_summary);
		}

		$block[$j]['lines'][$i] = $line;
		$i ++;
	}

	$j ++;
}

$xoopsTpl->assign('whatsnew', $block);

// measure time
$time = sprintf("%6.3f", whatsnew_time_end() );
$xoopsTpl->assign('time_excute', $time);

include XOOPS_ROOT_PATH.'/footer.php';

exit();

?>
