<?php
// $Id: xoops_version.php,v 1.1 2004/01/29 14:45:48 buennagel Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;
$mydirname = basename( dirname( __FILE__ ) ) ;
if( ! preg_match( '/^(\D+)(\d*)$/' , $mydirname , $regs ) ) echo ( "invalid dirname: " . htmlspecialchars( $mydirname ) ) ;
$mydirnumber = $regs[2] === '' ? '' : intval( $regs[2] ) ;

$modversion['name'] = _MI_HEADLINES_NAME.$mydirnumber;
$modversion['version'] = 2.99;
$modversion['description'] = _MI_HEADLINES_DESC;
$modversion['author'] = "Kazumi Ono<br />( http://www.xoops.org/ http://jp.xoops.org/ http://www.myweb.ne.jp/ )<br />Modified by GIJOE<br />( http://www.peak.ne.jp/ )";
$modversion['credits'] = "The XOOPS Project";
$modversion['help'] = "headlines.html";
$modversion['license'] = "GPL see LICENSE";
$modversion['official'] = 1;
$modversion['image'] = "images/xhld{$mydirnumber}_slogo.gif";
$modversion['dirname'] = $mydirname;

// Sql file (must contain sql generated by phpMyAdmin or phpPgAdmin)
// All tables should not have any prefix!
$modversion['sqlfile']['mysql'] = "sql/mysql{$mydirnumber}.sql";
//$modversion['sqlfile']['postgresql'] = "sql/pgsql.sql";

// Tables created by sql file (without prefix!)
$modversion['tables'][0] = "xhld{$mydirnumber}";

// Admin things
$modversion['hasAdmin'] = 1;
$modversion['adminindex'] = "admin/index.php";
$modversion['adminmenu'] = "admin/menu.php";

// Blocks
$modversion['blocks'][1]['file'] = "headline.php";
$modversion['blocks'][1]['name'] = _MI_HEADLINES_BNAME.$mydirnumber;
$modversion['blocks'][1]['description'] = "Shows headline news via RDF/RSS news feed";
$modversion['blocks'][1]['show_func'] = 'b_xhld_show';
$modversion['blocks'][1]['edit_func'] = 'b_xhld_edit';
$modversion['blocks'][1]['template'] = "xhld{$mydirnumber}_block_rss.html";
$modversion['blocks'][1]['can_clone'] = true ;
$modversion['blocks'][1]['options'] = "{$mydirname}|1|128|A";

$modversion['blocks'][2]['file'] = "headline.php";
$modversion['blocks'][2]['name'] = _MI_HEADLINES_BNAME_MIXED.$mydirnumber;
$modversion['blocks'][2]['description'] = "Shows headline news via RDF/RSS news feed";
$modversion['blocks'][2]['show_func'] = 'b_xhld_mixed_show';
$modversion['blocks'][2]['edit_func'] = 'b_xhld_mixed_edit';
$modversion['blocks'][2]['template'] = "xhld{$mydirnumber}_block_mixed.html";
$modversion['blocks'][2]['options'] = "{$mydirname}|10|128|99";

// Menu
$modversion['hasMain'] = 1;

// Configs
/*$modversion['config'][1] = array(
	'name'			=> "snoopy_timeout" ,
	'title'			=> '_MI_HEADLINES_SNOOPY_TIMEOUT' ,
	'description'	=> '' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'int' ,
	'default'		=> '10' ,
	'options'		=> array()
) ;*/

$modversion['config'][2] = array(
	'name'			=> "mixed_mode" ,
	'title'			=> '_MI_HEADLINES_MIXPICKUP' ,
	'description'	=> '_MI_HEADLINES_MIXPICKUPD' ,
	'formtype'		=> 'yesno' ,
	'valuetype'		=> 'int' ,
	'default'		=> '1' ,
	'options'		=> array()
) ;

// added by Tom
$modversion['config'][] = array(
	'name'			=> "index_viewmode" ,
	'title'			=> '_MI_HEADLINES_INDEX_VIEWMODE' ,
	'description'	=> '_MI_HEADLINES_INDEX_VIEWMODED' ,
	'formtype'		=> 'select' ,
	'valuetype'		=> 'int' ,
	'default'		=> '0' ,
	'options'		=> array( '_MI_HEADLINES_INDEX_VIEWMODE_MIXED' => 0 , '_MI_HEADLINES_INDEX_VIEWMODE_CLASSIC' => 1 )
) ;

$modversion['config'][] = array(
	'name'			=> "mixed_maxitem" ,
	'title'			=> '_MI_HEADLINES_MIXED_MAXITEM' ,
	'description'	=> '_MI_HEADLINES_MIXED_MAXITEMD' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'int' ,
	'default'		=> '50' ,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> "mixed_maxlen" ,
	'title'			=> '_MI_HEADLINES_MIXED_MAXLEN' ,
	'description'	=> '_MI_HEADLINES_MIXED_MAXLEND' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'int' ,
	'default'		=> '50' ,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> "proxy_host" ,
	'title'			=> '_MI_HEADLINES_PROXY_HOST' ,
	'description'	=> '_MI_HEADLINES_PROXY_HOSTD' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'text' ,
	'default'		=> '' ,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> "proxy_port" ,
	'title'			=> '_MI_HEADLINES_PROXY_PORT' ,
	'description'	=> '_MI_HEADLINES_PROXY_PORTD' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'int' ,
	'default'		=> '8080' ,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> "proxy_user" ,
	'title'			=> '_MI_HEADLINES_PROXY_USER' ,
	'description'	=> '_MI_HEADLINES_PROXY_USERD' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'text' ,
	'default'		=> '' ,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> "proxy_pass" ,
	'title'			=> '_MI_HEADLINES_PROXY_PASS' ,
	'description'	=> '_MI_HEADLINES_PROXY_PASSD' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'text' ,
	'default'		=> '' ,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> "dtfmt_short" ,
	'title'			=> '_MI_HEADLINES_SHORTDTFMT' ,
	'description'	=> '_MI_HEADLINES_SHORTDTFMTD' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'text' ,
	'default'		=> _MI_DEFAULT_DTFMT_SHORT ,
	'options'		=> array()
) ;


// Templates
$modversion['templates'][1]['file'] = "xhld{$mydirnumber}_index.html";
$modversion['templates'][1]['description'] = '';
$modversion['templates'][2]['file'] = "xhld{$mydirnumber}_feed.html";
$modversion['templates'][2]['description'] = '';
$modversion['templates'][3]['file'] = "xhld{$mydirnumber}_block.html";
$modversion['templates'][3]['description'] = '';

// Keep the values of block's options when module is updated (by nobunobu)
if( ! empty( $_POST['fct'] ) && ! empty( $_POST['op'] ) && $_POST['fct'] == 'modulesadmin' && $_POST['op'] == 'update_ok' && $_POST['dirname'] == $modversion['dirname'] ) {
	include dirname( __FILE__ ) . "/include/onupdate.inc.php" ;
}

?>