<?php
// $Id: image.php,v 1.2 2003/09/03 05:14:27 gstarret Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Kazumi Ono (AKA onokazu)                                          //
// URL: http://www.myweb.ne.jp/, http://www.xoops.org/, http://jp.xoops.org/ //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //

class XoopsgalleryImage extends XoopsObject {

	function XoopsgalleryImage() {
		$this->XoopsObject();
		$this->initVar('image_id', XOBJ_DTYPE_INT, null, false);
		$this->initVar('image_name', XOBJ_DTYPE_OTHER, null, true);
		$this->initVar('image_ext', XOBJ_DTYPE_OTHER, null, true);
		$this->initVar('image_type', XOBJ_DTYPE_OTHER, null, true);
		$this->initVar('image_basedir', XOBJ_DTYPE_OTHER, null, true);
		$this->initVar('image_albumdir', XOBJ_DTYPE_OTHER, null, true);
		$this->initVar('image_created', XOBJ_DTYPE_INT, null, false);
		$this->initVar('image_comments', XOBJ_DTYPE_INT, null, false);
	}

	function getFullPath(){
		return $this->getVar('image_basedir').'/'.$this->getVar('image_albumdir').'/'.$this->getVar('image_name').'.'.$this->getVar('image_ext');
	}

	function getFullUrl(){
		return str_replace(XOOPS_ROOT_PATH, XOOPS_URL, $this->getFullPath());
	}

	function ThumbExists(){
		$myfn = $this->getVar('image_basedir').'/'.$this->getVar('image_albumdir').'/'.$this->getVar('image_name').'.thumb.'.$this->getVar('image_ext');
		return file_exists($myfn);
	}
	
	function getFullThumbPath(){
		$myfn = $this->getVar('image_basedir').'/'.$this->getVar('image_albumdir').'/'.$this->getVar('image_name').'.thumb.'.$this->getVar('image_ext');
		if (!file_exists($myfn)) $myfn = $this->GetFullPath();
		return $myfn;
	}

	function getFullThumbUrl(){
		return str_replace(XOOPS_ROOT_PATH, XOOPS_URL, $this->getFullThumbPath());
	}
}


$xoopsHandlerName = 'XoopsgalleryImageHandler';

/**
* XOOPS Gallery image handler class.  
* This class is responsible for providing data access mechanisms to the data source 
* of XOOPS Gallery image class objects.
*
*
* @author  Kazumi Ono <onokazu@xoops.org>
*/

class XoopsgalleryImageHandler extends XoopsObjectHandler
{

    function &create($isNew = true)
    {
        $image = new XoopsgalleryImage();
        if ($isNew) {
            $image->setNew();
        }
        return $image;
    }

    function &get($id)
    {
        $id = intval($id);
        if ($id > 0) {
            $sql = 'SELECT * FROM '.$this->db->prefix('xoopsgallery_image').' WHERE image_id='.$id;
            if (!$result = $this->db->query($sql)) {
                return false;
            }
            $numrows = $this->db->getRowsNum($result);
            if ($numrows == 1) {
                $image = new XoopsgalleryImage();
                $image->assignVars($this->db->fetchArray($result));
                return $image;
            }
        }
        return false;
    }

    function insert(&$image)
    {
        if (get_class($image) != 'xoopsgalleryimage') {
            return false;
        }
        if (!$image->isDirty()) {
            return true;
        }
        if (!$image->cleanVars()) {
            echo'not clean';exit;return false;
        }
        foreach ($image->cleanVars as $k => $v) {
            ${$k} = $v;
        }
        if ($image->isNew()) {
            $image_id = $this->db->genId('xoopsgallery_image_image_id_seq');
            $sql = sprintf("INSERT INTO %s (image_id, image_name, image_ext, image_type, image_basedir, image_albumdir, image_created, image_comments) VALUES (%u, '%s', '%s', '%s', '%s', '%s', %u, %u)", $this->db->prefix('xoopsgallery_image'), $image_id, $image_name, $image_ext, $image_type, $image_basedir, $image_albumdir, $image_created, $image_comments);
        } else {
            $sql = sprintf("UPDATE %s SET image_name = '%s', image_ext = '%s', image_basedir = '%s',  image_albumdir = '%s', image_type = '%s', image_created = %u, image_comments = %u  WHERE image_id = %u", $this->db->prefix('xoopsgallery_image'), $image_name, $image_ext, $image_basedir, $image_albumdir, $image_type, $image_created, $image_comments, $image_id);
        }
        if (!$result = $this->db->queryF($sql)) {
            return false;
        }

        if (empty($image_id)) {
            $image_id = $this->db->getInsertId();
            $image->assignVar('image_id', $image_id);
        }
        return $image_id;
    }

    function delete(&$image)
    {
        if (get_class($image) != 'xoopsgalleryimage') {
            return false;
        }
        $id = $image->getVar('image_id');
        $sql = sprintf("DELETE FROM %s WHERE image_id = %u", $this->db->prefix('xoopsgallery_image'), $id);
        if (!$result = $this->db->query($sql)) {
            return false;
        }
        return true;
    }

    function &getObjects($criteria = null, $id_as_key = false)
    {
        $ret = array();
        $limit = $start = 0;
        $sql = 'SELECT * FROM '.$this->db->prefix('xoopsgallery_image');
        if (isset($criteria) && is_subclass_of($criteria, 'criteriaelement')) {
            $sql .= ' '.$criteria->renderWhere();
            $sort = ($criteria->getSort() != '') ? $criteria->getSort() : image_id;
            $sql .= ' ORDER BY '.$sort.' '.$criteria->getOrder();
            $limit = $criteria->getLimit();
            $start = $criteria->getStart();
        }
        $result = $this->db->query($sql, $limit, $start);
        if (!$result) {
            return false;
        }
        while ($myrow = $this->db->fetchArray($result)) {
            $image = new XoopsgalleryImage();
            $image->assignVars($myrow);
            if (!$id_as_key) {
                $ret[] =& $image;
            } else {
                $ret[$myrow['image_id']] =& $image;
            }
            unset($image);
        }
        return $ret;
    }

    function getCount($criteria = null)
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->db->prefix('xoopsgallery_image');
        if (isset($criteria) && is_subclass_of($criteria, 'criteriaelement')) {
            $sql .= ' '.$criteria->renderWhere();
        }
        if (!$result =& $this->db->query($sql)) {
            return false;
        }
        list($count) = $this->db->fetchRow($result);
        return $count;
    }
}
?>