<?php
// $Id: config_base_handler.php,v 1.3 2006/09/27 02:59:06 ohwada Exp $

// 2006-09-20 K.OHWADA
// save conf_valuetype to DB

// 2006-07-10 K.OHWADA
// this is new file
// porting from weblinks_config_store_handler

//================================================================
// Happy Linux Framework Module
// this file contain 2 class
//   happy_linux_config_base 
//   happy_linux_config_base_handler
// 2006-07-10 K.OHWADA
//================================================================

//================================================================
// class happy_linux_config_base
// modify form system XoopsConfigItem
//================================================================
class happy_linux_config_base extends happy_linux_object
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_config_base()
{
	$this->happy_linux_object();

	$this->initVar('id',             XOBJ_DTYPE_INT, 0, false);
	$this->initVar('conf_id',        XOBJ_DTYPE_INT, 0, true);
	$this->initVar('conf_name',      XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('conf_value',     XOBJ_DTYPE_OTHER);
	$this->initVar('conf_valuetype', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('aux_int_1',      XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_int_2',      XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_text_1',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('aux_text_2',     XOBJ_DTYPE_TXTBOX, null, false, 255);

}

//---------------------------------------------------------
// set value
//---------------------------------------------------------
function setConfValueForInput(&$value, $force_slash = false)
{
	switch ( $this->get('conf_valuetype') ) 
	{
		case 'array':
			if (!is_array($value)) 
			{
				$value = explode('|', trim($value));
			}
			$this->setVar('conf_value', serialize($value), $force_slash);
			break;

		case 'text':
			$this->setVar('conf_value', trim($value), $force_slash);
			break;

		default:
			$this->setVar('conf_value', $value, $force_slash);
			break;
	}
}

//---------------------------------------------------------
// get value
//---------------------------------------------------------
function &getConfValueForOutput($format='s')
{
	switch ( $this->get('conf_valuetype') ) 
	{
		case 'int':
			$value = intval( $this->get('conf_value') );
			break;

		case 'array':
			$value = unserialize( $this->get('conf_value') );
			break;

		case 'float':
			$value = floatval( $this->get('conf_value') );
			break;

		case 'textarea':
			$value = $this->getVar('conf_value', $format);
			break;

		case 'text':
		default:
			$value = $this->getVar('conf_value', $format);
			break;
	}

	return $value; 
}

function getConfVarAll($format='s')
{
	$ret = $this->getVarAll($format);
	$ret['value_output'] = $this->getConfValueForOutput($format);
	return $ret;
}

// --- class end ---
}

//=========================================================
// class config handler
//=========================================================
class happy_linux_config_base_handler extends happy_linux_object_handler
{
	var $_cached_by_confid = array();
	var $_cached_by_name   = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_config_base_handler( $dirname, $table_name, $id_name, $class_name )
{
	$this->happy_linux_object_handler( $dirname, $table_name, $id_name, $class_name );
}

//---------------------------------------------------------
// basic function
//---------------------------------------------------------
function _build_insert_sql(&$obj)
{
	foreach ($obj->gets() as $k => $v) 
	{	${$k} = $v;	}

	$sql  = 'INSERT INTO '.$this->_table.' (';
	$sql .= 'conf_id, ';
	$sql .= 'conf_name, ';
	$sql .= 'conf_value, ';
	$sql .= 'conf_valuetype, ';
	$sql .= 'aux_int_1, ';
	$sql .= 'aux_int_2, ';
	$sql .= 'aux_text_1, ';
	$sql .= 'aux_text_2 ';
	$sql .= ') VALUES (';
	$sql .= intval($conf_id).', ';
	$sql .= $this->quote($conf_name).', ';
	$sql .= $this->quote($conf_value).', ';
	$sql .= $this->quote($conf_valuetype).', ';
	$sql .= intval($aux_int_1).', ';
	$sql .= intval($aux_int_2).', ';
	$sql .= $this->quote($aux_text_1).', ';
	$sql .= $this->quote($aux_text_2).' ';
	$sql .= ')';

	return $sql;
}

function _build_update_sql(&$obj)
{
	foreach ($obj->gets() as $k => $v) 
	{	${$k} = $v;	}

	$sql = 'UPDATE '.$this->_table.' SET ';
	$sql .= 'conf_name='.$this->quote($conf_name).', ';
	$sql .= 'conf_value='.$this->quote($conf_value).', ';
	$sql .= 'conf_valuetype='.$this->quote($conf_valuetype).', ';
	$sql .= 'aux_int_1='.intval($aux_int_1).', ';
	$sql .= 'aux_int_2='.intval($aux_int_2).', ';
	$sql .= 'aux_text_1='.$this->quote($aux_text_1).', ';
	$sql .= 'aux_text_2='.$this->quote($aux_text_2).' ';
	$sql .= 'WHERE conf_id='.intval($conf_id);

	return $sql;
}

//---------------------------------------------------------
// load
//---------------------------------------------------------
function load()
{
	$this->_cached_by_confid = array();
	$this->_cached_by_name   = array();

	$objs = $this->getObjects();

	foreach ($objs as $obj)
	{
		$arr = $obj->getConfVarAll('s');
		$this->_cached_by_confid[ $arr['conf_id'] ] = $arr;
		$this->_cached_by_name[ $arr['conf_name'] ] = $arr;
	}
}

//---------------------------------------------------------
// get_cache
//---------------------------------------------------------
function get_cache_by_confid($id)
{
	$ret = false;
	if ( isset( $this->_cached_by_confid[$id] ) )
	{
		$ret = $this->_cached_by_confid[$id];
	}
	return $ret;
}

function get_cache_by_confid_key($id, $key)
{
	$ret = false;
	if ( isset( $this->_cached_by_confid[$id][$key] ) )
	{
		$ret = $this->_cached_by_confid[$id][$key];
	}
	return $ret;
}

function get_cache_by_name($name)
{
	$ret = false;
	if ( isset( $this->_cached_by_name[$name] ) )
	{
		$ret = $this->_cached_by_name[$name];
	}
	return $ret;
}

function get_cache_by_name_key($name, $key)
{
	$ret = false;
	if ( isset( $this->_cached_by_name[$name][$key] ) )
	{
		$ret = $this->_cached_by_name[$name][$key];
	}
	return $ret;
}

//---------------------------------------------------------
// update
//---------------------------------------------------------
function update_by_confid($id, $value)
{
	$id = intval($id);
	if ($id <= 0) return false;

	$obj =& $this->get_by_confid($id);

	if ( !is_object($obj) )
	{	return false;	}

	$obj->setConfValueForInput($value, true);
	$ret = $this->update($obj);
	return $ret;

}

function update_by_name($name, $value)
{
	$id =  $this->get_cache_by_name_key($name, 'conf_id');
	$ret = $this->update_by_confid($id, $value);
	return $ret;
}

//---------------------------------------------------------
// get
//---------------------------------------------------------
function &get_by_confid($id)
{
	$obj = false;

	$sql   = 'SELECT * FROM '. $this->_table .' WHERE conf_id='.intval($id);
	$objs  =& $this->get_objects_by_sql($sql);
	$count = count($objs);

	if ( $count <= 0 )
	{	return $obj;	}

	if ( $count > 1  )  
	{
		$this->_set_errors( $this->_table.' : too many matched' );
	}

	if ( isset($objs[0]) && is_object($objs[0]) )
	{
		$obj = $objs[0];
	}

	return $obj;
}

//---------------------------------------------------------
// create_table
//---------------------------------------------------------
function create_table()
{
// BUG : cannot create table in MySQL 3.23
// remove last ';'
$sql = "
CREATE TABLE ".$this->_table." (
  id smallint(5) unsigned NOT NULL auto_increment,
  conf_id smallint(5) unsigned NOT NULL default 0,
  conf_name      varchar(255) NOT NULL default '',
  conf_valuetype varchar(255) NOT NULL default '',
  conf_value text NOT NULL,
  aux_int_1 int(5) default '0',
  aux_int_2 int(5) default '0',
  aux_text_1 varchar(255) default '',
  aux_text_2 varchar(255) default '',
  PRIMARY KEY (id),
  KEY conf_id (conf_id)
) TYPE=MyISAM
";

	$ret = $this->query($sql);
	return $ret;
}

// --- class end ---
}

?>