<?php
// $Id: system.php,v 1.4 2006/09/27 02:59:07 ohwada Exp $

// 2006-09-20 K.OHWADA
// change get_user_param() get_user_by_uid()
// add get_user_by_uname()

// 2006-07-10 K.OHWADA
// this is new file
// porting from rssc_system.php

//=========================================================
// Happy Linux Framework Module
// 2006-07-10 K.OHWADA
//=========================================================

//---------------------------------------------------------
// TODO
// global $xoopsConfig, $xoopsUser, $xoopsModule
//---------------------------------------------------------

//=========================================================
// class happy_linux_system
//=========================================================
class happy_linux_system
{
	var $_user_uid_list;
	var $_user_list;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_system()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new happy_linux_system();
	}

	return $instance;
}

//--------------------------------------------------------
// xoops constant
//--------------------------------------------------------
function get_siteurl()
{
	$url = XOOPS_URL.'/';
	return $url;
}

function get_langcode()
{
	return _LANGCODE;
}

//--------------------------------------------------------
// xoops config
//--------------------------------------------------------
function get_sitename()
{
	global $xoopsConfig;
	return $xoopsConfig['sitename'];
}

function get_slogan()
{
	global $xoopsConfig;
	return $xoopsConfig['slogan'];
}

function get_adminmail()
{
	global $xoopsConfig;
	return $xoopsConfig['adminmail'];
}

function get_anonymous()
{
	global $xoopsConfig;
	return $xoopsConfig['anonymous'];
}

function get_language()
{
	global $xoopsConfig;
	return $xoopsConfig['language'];
}

function is_japanese()
{
	$ret = $this->is_language('japanese');
	return $ret;
}

function is_language($lang)
{
	if ( $this->get_language() == $lang )
	{
		return true;
	}

	return false;
}

//--------------------------------------------------------
// xoops Meta Footer
//--------------------------------------------------------
function get_meta_author()
{
	$config_handler        =& xoops_gethandler('config');
	$xoopsConfigMetaFooter =& $config_handler->getConfigsByCat(XOOPS_CONF_METAFOOTER);
	return $xoopsConfigMetaFooter['meta_author'];
}

function get_meta_description()
{
	$config_handler        =& xoops_gethandler('config');
	$xoopsConfigMetaFooter =& $config_handler->getConfigsByCat(XOOPS_CONF_METAFOOTER);
	return $xoopsConfigMetaFooter['meta_description'];
}

//--------------------------------------------------------
// xoops user
//--------------------------------------------------------
function is_owner($uid)
{
	$uid = intval($uid);

	if ( ( $uid != 0 )&&( $uid == $this->get_uid() ) )
	{
		return true;
	}

	return false;
}

function get_uid()
{
	$user = $this->get_user_param();
	return $user['uid'];
}

function get_uname()
{
	$user = $this->get_user_param();
	return $user['uname'];
}

function get_email()
{
	$user = $this->get_user_param();
	return $user['email'];
}

function &get_user_param()
{
	global $xoopsUser;

	$uid      = 0;
	$uname    = '';
	$email    = '';
	$url      = '';
	$groups   = '';
	$isactive = false;

	if ( is_object($xoopsUser) )
	{
		$uid      = $xoopsUser->getVar('uid');
		$uname    = $xoopsUser->getVar('uname');
		$email    = $xoopsUser->getVar('email');
		$url      = $xoopsUser->getVar('url');
		$groups   = $xoopsUser->getGroups();
		$isactive = $xoopsUser->isActive();
	}

	$arr = array(
		'uid'       => $uid,
		'uname'     => $uname,
		'email'     => $email,
		'url'       => $url,
		'groups'    => $groups,
		'isactive'  => $isactive,
	);

	return $arr;
}

function is_user()
{
	global $xoopsUser;

	if ( is_object($xoopsUser) )
	{
		return true;
	}

	return false;
}

function is_module_admin()
{
	global $xoopsUser, $xoopsModule;

	if ( is_object($xoopsUser) && $xoopsUser->isAdmin( $xoopsModule->mid() )) 
	{
		return true;;
	}

	return false;
}

//--------------------------------------------------------
// xoops module
//--------------------------------------------------------
function get_mid()
{
	global $xoopsModule;
	$mid = $xoopsModule->getVar('mid');
	return $mid;
}

function get_module_name()
{
	global $xoopsModule;
	return $xoopsModule->getVar('name');
}

function get_mid_by_dirname( $dirname )
{
	$mid = false;
	$module =& $this->get_module_by_dirname( $dirname );
	if ( is_object($module) )
	{
		$mid = $module->getVar('mid');
	}
	return $mid;
}

function &get_module_by_dirname( $dirname )
{
	$module_handler =& xoops_gethandler('module');
	$module =& $module_handler->getByDirname( $dirname );
	return $module;
}


//--------------------------------------------------------
// xoops user handler
//--------------------------------------------------------
// name for "anonymous" if not found
function get_uname_by_uid( $uid, $usereal=0 )
{
	$uname = XoopsUser::getUnameFromId( $uid, $usereal );
	return $uname;
}

function get_email_by_uid( $uid )
{
	$arr = $this->get_user_by_uid( $uid );

	if ( isset($arr['email']) )
	{
		$email = $arr['email'];
		return $email;
	}

	return '';
}

function get_user_by_uid( $uid )
{
	global $xoopsConfig;
	$xoopsConfig['anonymous'];

	$ret = array(
		'uid'       => $uid,
		'uname'     => '',
		'name'      => '',
		'email'     => '',
		'groups'    => '',
		'isactive'  => false
	);

	$uid = intval($uid);
	if ($uid <= 0)  return $ret;

	$user_handler =& xoops_gethandler('user');
	$obj = $user_handler->get( $uid );

	if ( !is_object($obj) )  return $ret;

	$ret = array(
		'uid'       => $uid,
		'uname'     => $obj->getVar('uname'),
		'name'      => $obj->getVar('name'),
		'email'     => $obj->getVar('email'),
		'url'       => $obj->getVar('url'),
		'groups'    => $obj->getGroups(),
		'isactive'  => $obj->isActive(),
	);

	return $ret;
}

function &get_user_list($limit=0, $start=0)
{
	$false = false;

	$this->_user_uid_list = array();
	$this->_user_list     = array();

	$limit = intval($limit);
	$start = intval($start);
	$criteria = new CriteriaCompo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);

	$user_handler =& xoops_gethandler('user');
	$objs = $user_handler->getObjects( $criteria );

	if ( count($objs) == 0 )  return $false;

	foreach ( $objs as $obj )
	{
		$uid       = $obj->getVar('uid');
		$uname     = $obj->getVar('uname');
		$name      = $obj->getVar('name');
		$email     = $obj->getVar('email');
		$groups    = $obj->getGroups();
		$isactive  = $obj->isActive();

		$this->_user_uid_list[]              = $uid;
		$this->_user_list[$uid]['uname']     = $uname;
		$this->_user_list[$uid]['name']      = $name;
		$this->_user_list[$uid]['email']     = $email;
		$this->_user_list[$uid]['groups']    = $groups;
		$this->_user_list[$uid]['isactive']  = $isactive;
	}

	$this->_user_list[0]['uname']     = $this->get_anonymous();
	$this->_user_list[0]['name']      = '';
	$this->_user_list[0]['email']     = '';
	$this->_user_list[0]['groups']    = '';
	$this->_user_list[0]['isactive']  = false;

	return $this->_user_list;
}

function &get_user_uid_list()
{
	return $this->_user_uid_list;
}

function &get_user_by_uname($uname)
{
	$false = false;

	$criteria = new CriteriaCompo();
	$criteria->add( new criteria( 'uname', $uname, '=' ) );

	$user_handler =& xoops_gethandler('user');
	$objs = $user_handler->getObjects( $criteria );

// system error if twe or more
	if ( !is_array($objs) || ( count($objs) != 1 ) )
	{
		return $false;
	}

	$arr = array(
		'uid'       => $objs[0]->getVar('uid'),
		'uname'     => $objs[0]->getVar('uname'),
		'name'      => $objs[0]->getVar('name'),
		'email'     => $objs[0]->getVar('email'),
		'groups'    => $objs[0]->getGroups(),
		'isactive'  => $objs[0]->isActive(),
	);

	return $arr;
}

//--------------------------------------------------------
// xoops member handler
//--------------------------------------------------------
function &get_group_list()
{
	$member_handler =& xoops_gethandler('member');
	$list =& $member_handler->getGroupList();
	return $list;
}

// --- class end ---
}

?>