<?php
// $Id: rssc_parse_handler.php,v 1.6 2006/09/27 03:02:48 ohwada Exp $

// 2006-09-20 K.OHWADA
// use set_error_code()
// use RSSC_CODE_PARSE_FAILED

// 2006-06-04 K.OHWADA
// this is new file
// move from rssc_xml_parser
// use rssc_magpie_parse
// use happy_linux_error happy_linux_remote_file

//=========================================================
// Rss Center Module
// 2006-06-04 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_parse_handler') ) 
{

//=========================================================
// class rssc_parse_handler
// require rssc_magpie_parse class
//=========================================================
class rssc_parse_handler extends happy_linux_error
{
	var $_DEBUG_PRINT_ITEMS = false;

// class instance
	var $_remote;
	var $_xml_utility;

// local
	var $_xml_encoding_orig;
	var $_xml_encoding;
	var $_xml_data = '';

// encoding
	var $_local_encoding  = _CHARSET;

	var $_xml_error_code = 0;
	var $_parse_result   = '';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_parse_handler()
{
	$this->happy_linux_error();

// class instance
	$this->_remote      =& happy_linux_remote_file::getInstance();
	$this->_xml_utility =& rssc_xml_utility::getInstance();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_parse_handler();
	}

	return $instance;
}

//---------------------------------------------------------
// discover XML url & read XML & parse XML
//---------------------------------------------------------
function &discover_and_parse_by_html_url($html_url)
{
	$false = false;

	if ( !$this->_xml_utility->discover($html_url) )
	{
		$this->_set_errors( $this->_xml_utility->getErrors() );
		return $false;
	}

	$xml_mode = $this->_xml_utility->get_xml_mode();
	$xml_url  = $this->_xml_utility->get_xmlurl_by_mode();
	$xml_encoding = '';

	$obj =& $this->parse_by_url($xml_url, $xml_encoding, $xml_mode);
	if ( !is_object($obj) )
	{
		return false;
	}

	return $obj;
}

//---------------------------------------------------------
// read XML & parse XML
//---------------------------------------------------------
function &parse_by_url($xml_url, $xml_encoding='')
{
	$false = false;

	$xml_data = $this->_xml_utility->read_xml($xml_url);
	if ( !$xml_data )
	{
		$this->_set_error_code( RSSC_CODE_PARSE_NOT_READ_XML_URL );
		$this->_set_errors(      $this->_xml_utility->getErrors() );
		$this->_xml_error_code = $this->_xml_utility->getErrorCode();
		return $false;
	}

	if ( $xml_encoding )
	{
		$encoding_orig = $xml_encoding;
		$this->_xml_encoding_orig = $xml_encoding;
	}
// find encoding, if empty
	else
	{
		$encoding_orig = $this->_xml_utility->find_encoding($xml_data);

		if ( !$encoding_orig )
		{
			$this->_set_error_code( RSSC_CODE_PARSE_NOT_FIND_ENCODING );
			$this->_set_errors(      $this->_xml_utility->getErrors() );
			$this->_xml_error_code = $this->_xml_utility->getErrorCode();
			return $false;
		}

		$this->_xml_encoding_orig = $encoding_orig;

		$ret = $this->_xml_utility->get_result_code();
		if ( $ret == RSSC_CODE_XML_ENCODINGS_DEFAULT )
		{
			$this->_parse_result = sprintf( _RSSC_ASSUME_ENCODING, $encoding_orig );
		}

	}

	list($xml_converted, $encoding_converted)
		= $this->_xml_utility->convert_to_parse($xml_data, $encoding_orig);

	$obj =& $this->parse($xml_converted, $encoding_converted, $xml_url);
	return $obj;
}

//---------------------------------------------------------
// parse XML with user encoding
//---------------------------------------------------------
function &parse_by_xml($xml_data, $xml_encoding)
{
	list($xml_converted, $encoding_converted)
		= $this->_xml_utility->convert_to_parse($xml_data, $xml_encoding);

	$obj =& $this->parse($xml_converted, $encoding_converted);
	return $obj;
}

//---------------------------------------------------------
// parse XML
//---------------------------------------------------------
function &parse($xml_data, $xml_encoding, $xml_url='')
{
	$this->_xml_data     = $xml_data;
	$this->_xml_encoding = $xml_encoding;

	$false = false;

	$rss =& new rssc_magpie_parse();
	$rss->magpie_parse( $xml_data, $xml_encoding, $xml_encoding, false );

	if ( !$rss ) 
	{
		$this->_set_error_code( RSSC_CODE_PARSE_FAILED );
		$this->_set_errors( "cannot parse: url = $xml_url" );
		return $false;
	}

	if ( $rss->ERROR ) 
	{
		$this->_set_error_code( RSSC_CODE_PARSE_FAILED );
		$this->_set_errors( "cannot parse: url = $xml_url" );
		$this->_set_errors( $rss->ERROR );
		return $false;
	}

	if ( (count($rss->channel) == 0) && (count($rss->items) == 0) )
	{
		$this->_set_error_code( RSSC_CODE_PARSE_FAILED );
		$this->_set_errors( "parse data is empty: url = $xml_url" );
		return $false;
	}

// object
	$obj =& new rssc_xml();
	$obj->set_xml_encoding( $xml_encoding );
	$obj->set_local_encoding( $this->_local_encoding );
	$obj->set_vars_from_parse( $rss );
	$obj->convert_to_local();
	$obj->build_for_store();

	if ($this->_DEBUG_PRINT_ITEMS)
	{
		echo "rssc_parse_handler->parse() <br />\n";
		print_r( $rss->items );
		echo "<hr />\n";
		print_r( $obj->get_items() );
		echo "<hr />\n";
	}

	return $obj;
}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function set_local_encoding($value)
{
	$this->_local_encoding = $value;
}

function get_xml_encoding()
{
	return $this->_xml_encoding;
}

function get_xml_data()
{
	return $this->_xml_data;
}

function get_xml_error_code()
{
	return $this->_xml_error_code;
}

function get_parse_result()
{
	return $this->_parse_result;
}

//---------------------------------------------------------
// set and get property of xml_utility
//---------------------------------------------------------
function get_xml_mode()
{
	$ret = $this->_xml_utility->get_xml_mode();
	return $ret;
}

function get_rdf_url()
{
	$ret = $this->_xml_utility->get_rdf_url();
	return $ret;
}

function get_rss_url()
{
	$ret = $this->_xml_utility->get_rss_url();
	return $ret;
}

function get_atom_url()
{
	$ret = $this->_xml_utility->get_atom_url();
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>