<?php
// $Id: locate.php,v 1.2 2006/10/07 04:56:50 ohwada Exp $

// 2006-10-05 K.OHWADA
// this is new file
// porting form weblinks_language_base.php

//=========================================================
// Happy Linux Framework Module
// 2006-10-01 K.OHWADA
//=========================================================

//=========================================================
// class happy_linux_locate_base
//=========================================================
class happy_linux_locate_base
{
	var $_vars = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_locate_base()
{
	$this->_vars = array(
		'happy_linux_url' => 'http://linux2.ohwada.net/'
	);
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function build_google_search_url( $query, $google_url=null, $lang=null )
{
	if ( empty($google_url) )
	{
		$google_url = $this->get_var('google_url');
	}

	if ( empty($lang) )
	{
		$lang = _LANGCODE;
	}

	$query = happy_linux_convert_to_utf8($query);
	$query = urlencode($query);
	$url = $google_url .'search?hl='. $lang .'&q='.$query;
	return $url;
}

//---------------------------------------------------------
// get value
//---------------------------------------------------------
function &get_vars()
{
	return $this->_vars;
}

function get_var($name)
{
	$val = false;
	if ( isset($this->_vars[$name]) )
	{
		$val = $this->_vars[$name];
	}
	return $val;
}

function array_merge($arr)
{
// overwrite previus value
	$this->_vars = array_merge($this->_vars, $arr);
}

// --- class end ---
}


//=========================================================
// class happy_linux_locate_factory
//=========================================================
class happy_linux_locate_factory extends happy_linux_locate_base
{
	var $_DIRNAME = null;
	var $_DEFAULT_COUNTRY_CODE = 'us';	// United States of Americe

	var $_country_code      = null;
	var $_lang_country_code = null;
	var $_config_handler    = null;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_locate_factory()
{
	$this->happy_linux_locate_base();

// lang country code
	$lang_factory =& happy_linux_language_factory::getInstance();
	$lang_local   =& $lang_factory->get_local_instance();
	$this->_lang_country_code = $lang_local->get_country_code();
}

//---------------------------------------------------------
// get_instance
//---------------------------------------------------------
function &get_instance( $country_code=null, $prefix='happy_linux', $dirname='happy_linux' )
{
	if ( $country_code )
	{
		$instance =& $this->get_instance_by_country_code( $country_code, $prefix, $dirname );
		if ( $instance )
		{
			$this->_country_code = $country_code;
			return $instance;
		}
	}

	$instance =& $this->get_instance_by_country_code( $this->_lang_country_code, $prefix, $dirname  );
	if ( $instance )
	{
		return $instance;
	}

	$instance =& $this->get_instance_by_country_code( $this->_DEFAULT_COUNTRY_CODE, $prefix, $dirname  );
	if ( $instance )
	{
		return $instance;
	}

	$instance =& new happy_linux_locate_base();
	return $instance;
}

function &get_instance_by_country_code( $country_code, $prefix='happy_linux', $dirname='happy_linux' )
{
	$instance = false;
	$file     = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/locate/'.$country_code.'/local.php';
	$class    = $prefix.'_locate_'.$country_code;

	if ( file_exists($file) ) 
	{
		include_once $file;

		if ( class_exists($class) )
		{
			$instance =& new $class();
		}
	}

	return $instance;
}

//---------------------------------------------------------
// set & get parameter
//---------------------------------------------------------
function set_config_handler( &$handler )
{
	$this->_config_handler =& $handler;
}

function set_dirname( $dirname )
{
	$this->_DIRNAME = $dirname;
}

function get_dirname()
{
	return $this->_DIRNAME;
}

//---------------------------------------------------------
// set & get country code
//---------------------------------------------------------
function set_config_country_code()
{
	if ( is_object($this->_config_handler) )
	{
		$conf = $this->_config_handler->get_conf();
		if ( isset($conf['country_code']) )
		{
			$this->set_country_code( $conf['country_code'] );
		}
	}
}

function set_lang_country_code()
{
	$this->set_country_code( $this->_lang_country_code );
}

function set_country_code( $val )
{
	$this->_country_code = $val;
}

function get_country_code()
{
	return $this->_country_code;
}

// --- class end ---
}

?>