<?php
// $Id: weblinks_mailer.php,v 1.3 2005/10/28 11:56:02 ohwada Exp $

//=========================================================
// class weblinks_mailer
// 2005-01-20 K.OHWADA
//=========================================================
class weblinks_mailer
{
// class
	var $mailer;

// content
	var $subject;
	var $body;
	var $header;

// debug
	var $flag_send;
	var $debug;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_mailer()
{
	$this->mailer =& getMailer();

	$this->set_flag_send(0);
	$this->set_debug(1);

}

//---------------------------------------------------------
// function same as XoopsMailer
//---------------------------------------------------------
function setFromName( $value )
{
	return $this->mailer->setFromName( $value );
}

function setFromEmail( $value )
{
	return $this->mailer->setFromEmail( $value );
}

function setSubject( $value )
{
	return $this->mailer->setSubject( $value );
}

function setBody( $value )
{
	return $this->mailer->setBody( $value );
}

function useMail()
{
	return $this->mailer->useMail();
}

function setToEmails( $email )
{
	return $this->mailer->setToEmails( $email );
}

function send($debug = false)
{
	return $this->mailer->send( $debug );
}

function getSuccess()
{
	return $this->mailer->getSuccess();
}

function getErrors()
{
	return $this->mailer->getErrors();
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function prepare()
{
	$debug = $this->debug;

	global $xoopsConfig;

	if ( $this->mailer->body == "" && $this->mailer->template == "" ) 
	{
		if ($debug) 
		{
			$this->mailer->errors[] = _MAIL_MSGBODY;
		}
		return false;
	}
	elseif ( $this->mailer->template != "" ) 
	{
		$path = ( $this->mailer->templatedir != "" ) ? $this->mailer->templatedir."".$this->mailer->template : (XOOPS_ROOT_PATH."/language/".$xoopsConfig['language']."/mail_template/".$this->mailer->template);

		if ( !($fd = @fopen($path, 'r')) ) 
		{
			if ($debug) 
			{
				$this->mailer->errors[] = _MAIL_FAILOPTPL;
			}

			return false;
        }

		$this->mailer->setBody(fread($fd, filesize($path)));
	}

// for sending mail only
	if (!empty($this->mailer->priority)) 
	{
		$this->mailer->headers[] = "X-Priority: " . $this->mailer->priority;
	}

	$this->mailer->headers[] = "X-Mailer: PHP/".phpversion();
	$this->mailer->headers[] = "Return-Path: ".$this->mailer->fromEmail;
	$header = join($this->mailer->LE, $this->mailer->headers);

// TODO: we should have an option of no-reply for private messages and emails
// to which we do not accept replies.  e.g. the site admin doesn't want a
// a lot of message from people trying to unsubscribe.  Just make sure to
// give good instructions in the message.

	// add some standard tags (user-dependent tags are included later)
	global $xoopsConfig;
	$this->mailer->assign ('X_ADMINMAIL', $xoopsConfig['adminmail']);
	$this->mailer->assign ('X_SITENAME',  $xoopsConfig['sitename']);
	$this->mailer->assign ('X_SITEURL',   XOOPS_URL);

	// TODO: also X_ADMINNAME??
	// TODO: X_SIGNATURE, X_DISCLAIMER ?? - these are probably best
	//  done as includes if mail templates ever get this sophisticated

	// replace tags with actual values
	$body    = $this->mailer->body;
	$subject = $this->mailer->subject;

	foreach ( $this->mailer->assignedTags as $k => $v ) 
	{
		$body    = str_replace("{".$k."}", $v, $body);
		$subject = str_replace("{".$k."}", $v, $subject);
	}

	$body = str_replace("\r\n", "\n", $body);
	$body = str_replace("\r",   "\n", $body);
	$body = str_replace("\n", $this->mailer->LE, $body);

	$this->subject = $subject;
	$this->body    = $body;
	$this->header  = $header;

	if ( !$this->flag_send )
	{
		global $myts;
		echo nl2br( $myts->makeTboxData4Show($header) )." <br /><br />\n";
	}
}

function send_user($user)
{
	$debug = $this->debug;

	$lid   = $user["lid"];
	$email = $user["email_disp"];
	$name  = $user["name_disp"];

	// send message to specified users, if any

	// NOTE: we don't send to LIST of recipients, because the tags
	// below are dependent on the user identity; i.e. each user
	// receives (potentially) a different message

	// set some user specific variables
	$subject = str_replace("{W_NAME}", $name, $this->subject );

	$body = str_replace("{W_LID}",   $lid,   $this->body );
	$body = str_replace("{W_EMAIL}", $email, $body );
	$body = str_replace("{W_NAME}",  $name,  $body );

	// send mail
	if ( $this->flag_send )
	{
		if ( !$this->mailer->sendMail($email, $subject, $body, $this->header) ) 
		{
			if ($debug) 
			{
				$this->mailer->errors[] = sprintf(_MAIL_SENDMAILNG, $name );
			}
		}
		else 
		{
			if ($debug) 
			{
				$this->mailer->success[] = sprintf(_MAIL_MAILGOOD, $name );
			}
		}
	}
	else
	{
		global $myts;
		echo "<b>$lid</b>: ";
		echo $myts->makeTboxData4Show($name).", ";
		echo $myts->makeTboxData4Show($email).", ";
		echo $myts->makeTboxData4Show($subject)." <br />\n";
		echo nl2br( $myts->makeTareaData4Show($body) )." <br /><br />\n";
	}

	flush();

	if ( count($this->mailer->errors) > 0 ) 
	{
		return false;
	}

	return true;
}

function set_flag_send($value)
{
	$this->flag_send = intval($value);
}

function set_debug($value)
{
	$this->debug = intval($value);
}

//---------------------------------------------------------
}

?>