<?php
// $Id: rss_manage.php,v 1.3 2005/10/28 11:56:02 ohwada Exp $

// 2005-01-20 K.OHWADA
// add clear_num()

//=========================================================
// admin RSS/ATOM manage
// created from v0.9
// 2004-11-28 K.OHWADA
//=========================================================

include 'admin_header.php';
include_once XOOPS_ROOT_PATH."/include/xoopscodes.php";
include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";
include_once $MODULE_ROOT."/class/xoops_form_extend.php";
include_once $MODULE_ROOT.'/class/class.rss_atom_parser_base.php';
include_once $MODULE_ROOT.'/class/class.rss_parser.php';
include_once $MODULE_ROOT.'/class/class.atom_parser.php';
include_once $MODULE_ROOT.'/class/rss_atom_collect.php';
include_once $MODULE_ROOT.'/class/link_check.php';

// class
$check  =& link_check::getInstance();

$op = '';
if ( isset($_POST['op']) )  $op = $_POST['op'];

$limit  = 0;
$offset = 0;
if ( isset($_POST['limit']) )   $limit  = intval( $_POST['limit'] );
if ( isset($_POST['offset']) )  $offset = intval( $_POST['offset'] );

if ($limit  < 0)  $limit  = 0;
if ($offset < 0)  $offset = 0;

$total_site_rss = $tbl_link->getNumRssFlag();

xoops_cp_header();
print_top($total_site_rss);
print_form($limit, $offset);

if ($op == 'refresh_link')
{
	echo "<hr>\n";
	$check->refresh_link($limit, $offset);

// next
	$next = $offset + $limit;
	if (($limit > 0) && ($next < $total_site_rss))
	{	print_form_next($limit, $next);	}
}
elseif ($op == 'refresh_site')
{
	echo "<hr>\n";
	$check->refresh_site();
}
elseif ($op == 'clear_num')
{
	echo "<hr>\n";
	clear_num();
}
elseif ($op == 'clear_lid')
{
	echo "<hr>\n";
	clear_lid();
}
elseif ($op == 'clear_all')
{
	echo "<hr>\n";
	clear_all();
}

echo "<hr>\n";
xoops_cp_footer();
exit();


//---------------------------------------------------------
// function
//---------------------------------------------------------
function print_top($total_site_rss)
{
	global $MODULE_URL;
	global $tbl_link, $tbl_atomfeed;


	$total_link     = $tbl_link->getNumAll();
	$total_site_rss = $tbl_link->getNumRssFlag();
	$total_atomfeed = $tbl_atomfeed->getNumAll();

	$url_rss  = $MODULE_URL."/viewmark.php?mark=rss";
	$url_feed = $MODULE_URL."/viewfeed.php";

	echo "<h3>"._WEBLINKS_ADMIN_RSS_MANAGE."</h3>\n";

	echo "<table width='80%' border='0' cellspacing='1' class='outer'>";
	echo "<tr class='odd'><td>";
	echo " - <a href='index.php'>"._WEBLINKS_ADMIN_INDEX."</a>";
	echo "<br /><br />\n";
	echo "- <a href='$url_rss'>"._WLS_SITE_RSS."</a> ($total_site_rss) ";
	echo "<br /><br />\n";
	echo "- <a href='$url_feed'>"._WLS_ATOMFEED."</a> ($total_atomfeed) ";
	echo "<br /><br />\n";
	echo "- <b>"._WEBLINKS_ADMIN_RSS_MANAGE."</b>";
	echo "<br /><br />\n";
	echo "--- <a href='#refresh'>"._WEBLINKS_ADMIN_RSS_REFRESH."</a>";
	echo "<br /><br />\n";
	echo "--- <a href='#clear'>"._WEBLINKS_ADMIN_RSS_CACHE_CLEAR."</a>";
	echo "<br /><br />\n";
	echo"</td></tr></table>\n";

	echo "<br /><br />\n";
	printf(_WLS_THEREARE, $total_link);

}

function print_form($limit, $offset)
{
	global $weblinksConfig;

	$num = $weblinksConfig['rss_limit'];
	if ( isset($_POST['num']) )  $num = intval( $_POST['num'] );

	$builder = new xoops_form_extend();

	echo "<a name='refresh'></a>";
	echo "<h4>"._WEBLINKS_ADMIN_RSS_REFRESH."</h4>\n";
	echo _WEBLINKS_ADMIN_LINK_BROKEN_CHECK_CAUTION."<br />\n";

	$builder->start_theme_form( _WEBLINKS_ADMIN_RSS_REFRESH_LINK, 'refresh_link' );
	$builder->add_hidden( 'op',  'refresh_link' );
	$builder->add_text( _WEBLINKS_ADMIN_LIMIT,  'limit',  $limit,  true );
	$builder->add_text( _WEBLINKS_ADMIN_OFFSET, 'offset', $offset, true );
	$builder->add_submit_button( '', 'post', _WEBLINKS_UPDATE );
	$builder->display();

	echo "<br />\n";

	$builder->start_theme_form( _WEBLINKS_ADMIN_RSS_REFRESH_SITE, 'refresh_site' );
	$builder->add_hidden( 'op',  'refresh_site' );
	$builder->add_submit_button( '', 'post', _WEBLINKS_UPDATE );
	$builder->display();

	echo "<a name='clear'></a>";
	echo "<h4>"._WEBLINKS_ADMIN_RSS_CACHE_CLEAR."</h4>\n";

	$builder->start_theme_form( _WEBLINKS_RSS_CLEAR_NUM, 'clear_num' );
	$builder->add_hidden( 'op',  'clear_num' );
	$builder->add_text( _WEBLINKS_RSS_NUMBER, 'num', $num, true );
	$builder->add_submit_button( '', 'post', _WEBLINKS_CLEAR );
	$builder->display();

	$builder->start_theme_form( _WEBLINKS_RSS_CLEAR_LID, 'clear_lid' );
	$builder->add_hidden( 'op',  'clear_lid' );
	$builder->add_text( _WLS_LINKID, 'lid', '', true );
	$builder->add_submit_button( '', 'post', _WEBLINKS_CLEAR );
	$builder->display();

	$builder->start_theme_form( _WEBLINKS_RSS_CLEAR_ALL, 'clear_all' );
	$builder->add_hidden( 'op',  'clear_all' );
	$builder->add_submit_button( '', 'post', _WEBLINKS_CLEAR );
	$builder->display();

}

function print_form_next($limit, $offset)
{
	$action = xoops_getenv('PHP_SELF');
	$submit = sprintf(_WEBLINKS_ADMIN_CHECK_NEXT, $limit);

?>
<br />
<form action='<?php echo $action; ?>' method='post'>
<input type='hidden' name='op' value='refresh'>
<input type='hidden' name='limit' value='<?php echo $limit; ?>'>
<input type='hidden' name='offset' value='<?php echo $offset; ?>'>
<input type='submit' value='<?php echo $submit; ?>'>
</form>
<?php

}

function clear_num()
{
	global $tbl_atomfeed;

	$num = 0;
	if ( isset($_POST['num']) )  $num = intval( $_POST['num'] );

	$del = $tbl_atomfeed->clearOverNum( $num );
	if ($del == 0)
	{
		echo "<font color='blue'>"._WEBLINKS_NON."</font><br />";
		return;
	}

	$text  = "<br />\n";
	$text .= "<table><tr>";
	$text .= "<tr><td>"._WEBLINKS_NUM_RSS_CLEAR_ATOMFEED."</td>";
	$text .= "<td>$del "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "</table>\n";
	echo $text;

	return;
}

function clear_lid()
{
	global $tbl_link, $tbl_atomfeed;

	$lid = 0;
	if ( isset($_POST['lid']) )  $lid = intval( $_POST['lid'] );

	$num_feed = $tbl_atomfeed->getNumByLid($lid);

// exec
	$tbl_link->updateRssXml($lid, 0, '');
	$tbl_atomfeed->deleteByLid($lid);

	$text  = "<br /><br />\n";
	$text .= "<table><tr>";
	$text .= "<tr><td>"._WEBLINKS_NUM_RSS_CLEAR_ATOMFEED."</td>";
	$text .= "<td>$num_feed "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "</table>\n";
	echo $text;

	return;
}

function clear_all()
{
	global $tbl_link, $tbl_atomfeed;

	$num_link_all = $tbl_link->getNumAll();

	$lid_array = $tbl_link->getLidArrayByRssFlag();
	$num_link_clear = count($lid_array);

	$time_start = time();

// --- table start ---
	$time_now = get_time_now();
	echo "<br />"._WEBLINKS_ADMIN_TIME_START." $time_now<br /><br />\n";

// proc by record
	foreach($lid_array as $lid)
	{
		echo ".";
		$tbl_link->updateRssXml($lid, 0, '');
		$tbl_atomfeed->deleteByLid($lid);
	}

// --- table end ---
	$time_now    = get_time_now();
	$time_elapse = get_time_elapse($time_start);

	$text  = "<br /><br />\n";
	$text .= _WEBLINKS_ADMIN_TIME_END." $time_now<br /><br />\n";
	$text .= "<table><tr>";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_ALL."</td>";
	$text .= "<td>$num_link_all "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_NUM_RSS_CLEAR_LINK."</td>";
	$text .= "<td>$num_link_clear "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_TIME_ELAPSE."</td>";
	$text .= "<td>$time_elapse</td></tr>\n";
	$text .= "</table>\n";
	echo $text;

	return;
}

function get_time_now()
{
	return date("Y-m-d H:i:s");
}

function get_time_elapse($time_start)
{
	$time = time() - $time_start;
	$min = intval($time/60);
	$sec = $time - 60*$min;
	return  sprintf(_WEBLINKS_ADMIN_MIN_SEC, $min, $sec);
}


?>
