<?php
// $Id: news_bigstory.php,v 1.3 2004/08/03 16:48:57 hthouzard Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

function b_news_bigstory_show() {
	include_once XOOPS_ROOT_PATH.'/modules/news/include/functions.php';
    include_once XOOPS_ROOT_PATH."/modules/news/class/class.newsstory.php";
    $myts =& MyTextSanitizer::getInstance();
	$restricted=getmoduleoption('restrictindex');
	$dateformat=getmoduleoption('dateformat');
	$infotips=getmoduleoption('infotips');

	$block = array();
    $onestory = new NewsStory();
	$stories = $onestory->getBigStory(1,0,$restricted,0,1, true, 'counter');
	if(count($stories)==0) {
		$block['message'] = _MB_NEWS_NOTYET;
	} else {
		foreach ( $stories as $key => $story ) {
			$htmltitle='';
			if($infotips>0) {
				$block['infotips'] = make_infotips($story->hometext());
				$htmltitle=' title="'.$block['infotips'].'"';
			}
			$block['htmltitle']=$htmltitle;
			$block['message'] = _MB_NEWS_TMRSI;
			$block['story_title'] = $story->title('Show');
			$block['story_id'] = $story->storyid();
			$block['story_date'] = formatTimestamp($story->published(), $dateformat);
			$block['story_hits'] = $story->counter();
            $block['story_rating'] = $story->rating();
            $block['story_votes'] = $story->votes();
            $block['story_author']= $story->uname();
            $block['story_text']= $story->hometext();
            $block['story_topic_title']= $story->topic_title();
            $block['story_topic_color']= '#'.$myts->displayTarea($story->topic_color);
		}
	}
	return $block;
}
?>