<?php
// $Id: rssc_view_handler.php,v 1.7 2006/09/29 12:48:54 ohwada Exp $

// 2006-09-20 K.OHWADA
// add get_feed_count_by_mid() get_feed_list_by_mid()
// highlight_keyword

// 2006-07-08 K.OHWADA
// load image from channel
// change get_sanitized_store_by_lid()

// 2006-06-04 K.OHWADA
// add exists_link() exists_feed() getLatest()
// use view_format_sanitize()
// move getHeadlineLinks() to headline_handle
// suppress notice : Only variable references should be returned by reference

// 2006-01-20 K.OHWADA
// small change

//=========================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_view_handler') ) 
{

//=========================================================
// class rssc_view_handler
//=========================================================
class rssc_view_handler extends rssc_view_param
{
// handler
	var $_link_handler;
	var $_feed_handler;

// input & result
	var $_result_data = array();

// define by rssc_view_param
//	var $_feed_handler;
//	var $_sanitize;
//	var $_feed_start;
//	var $_feed_limit;
//	var $_feed_order;
//	var $_flag_sanitize;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_view_handler( $dirname )
{
	$this->rssc_view_param();

// class instance
	$this->_link_handler =& rssc_get_handler('link',  $dirname);
	$this->_feed_handler =& rssc_get_handler('feed',  $dirname);
}

//=========================================================
// public
//=========================================================
function exists_link($lid)
{
	$link_obj =& $this->getCache($lid);
	if ( is_object($link_obj) )
	{
		return true;
	}
	return false;
}

function exists_feed($fid)
{
	$feed_obj =& $this->_feed_handler->get($fid);
	if ( is_object($feed_obj) )
	{
		return true;
	}
	return false;
}

function &get($lid)
{
	$ret =& $this->_link_handler->get($lid);
	if ( !$ret )
	{
		$this->_set_errors( $this->_link_handler->getErrors() );
	}
	return $ret;
}

function &getCache($lid)
{
	$ret =& $this->_link_handler->getCache($lid);
	if ( !$ret )
	{
		$this->_set_errors( $this->_link_handler->getErrors() );
	}
	return $ret;
}

function &getLink($lid)
{
	$false = false;

	$link_obj =& $this->getCache($lid);
	if ( !is_object($link_obj) )
	{
		$this->_set_errors( "rssc_view_handler: no link record: lid = $lid" );
		return $false;
	}

	$link =& $link_obj->build_show();
	return $link;
}

function &getFeedByFid($fid)
{
	$feed_obj =& $this->_feed_handler->get($fid);
	$feed =& $feed_obj->get_feed_and_raws();
	$feed =& $this->view_format_sanitize_single_feed( $feed, $this->_flag_sanitize );
	return $feed;
}

function &getFeeds($lid)
{
	$feeds = array();

	$feed_objs =& $this->_feed_handler->get_objects_by_lid_order($lid, $this->_feed_order, $this->_feed_limit, $this->_feed_start );

	foreach ($feed_objs as $obj) 
	{
		$feed =& $obj->get_feed_and_raws();
		$feed =& $this->view_format_sanitize_single_feed( $feed, $this->_flag_sanitize );
		$feeds[] = $feed;
	}

	return $feeds;
}

function &getHeadlineLinksFeeds($link_limit=0, $link_start=0)
{
	$lids  =& $this->_link_handler->get_headline_lids($link_limit, $link_start);
	$links = array();

	foreach ($lids as $lid)
	{
		$link =& $this->getLink($lid);

		$feed_objs =& $this->_feed_handler->get_objects_by_lid_order($lid, $this->_feed_order, $this->_feed_limit, $this->_feed_start );
		$feeds =& $this->view_format_sanitize_feed_objs( $feed_objs );

		$link['feeds'] =& $feeds;
		$links[] =& $link;
	}

	return $links;
}

function &get_sanitized_store_by_lid($lid)
{
	$false = false;

	$channel =& $this->_link_handler->get_channel_by_lid($lid);
	if ( !$channel )
	{
		$this->_set_errors( $this->_link_handler->getErrors() );
		return $false;
	}

	$feed_objs =& $this->_feed_handler->get_objects_by_lid_order($lid, $this->_feed_order, $this->_feed_limit, $this->_feed_start );
	$feeds =& $this->view_format_sanitize_feed_objs( $feed_objs );

	$arr = array();

// load channel image textinput from channel field
	if ( isset($channel['channel']) )
	{
		$arr['channel'] = $channel['channel'];
	}

	if ( isset($channel['image']) )
	{
		$arr['image'] = $channel['image'];
	}

	if ( isset($channel['textinput']) )
	{
		$arr['textinput'] = $channel['textinput'];
	}

	$arr['items'] = $feeds;

// sanitize
	$data =& $this->view_sanitize($arr);
	return $data;
}

//---------------------------------------------------------
// for other module
//---------------------------------------------------------
function get_feed_count_by_mid($mid)
{
	$count = $this->_feed_handler->get_count_by_mid($mid);
	return $count;
}

function &get_feed_list_by_mid($mid)
{
	$feeds  = array();
	$feed_objs =& $this->_feed_handler->get_objects_by_mid_order($mid, $this->_feed_order, $this->_feed_limit, $this->_feed_start);
	$feeds =& $this->view_format_sanitize_feed_objs( $feed_objs );
	return $feeds;
}

// --- class end ---
}

// === class end ===
}

?>