<?php

/**
* $Id: backend.php,v 1.6 2005/09/22 12:30:43 malanciault Exp $
* Module: SmartSection
* Author: The SmartFactory <www.smartfactory.ca>
* Licence: GNU
*/

include_once("header.php");

include_once XOOPS_ROOT_PATH.'/class/template.php';
if (function_exists('mb_http_output')) {
	mb_http_output('pass');
}

$categoryid = isset($_GET['categoryid']) ? $_GET['categoryid'] : -1 ;

if ($categoryid != -1) {
	$categoryObj = $smartsection_category_handler->get($categoryid);
}

header ('Content-Type:text/xml; charset=utf-8');
$tpl = new XoopsTpl();
$tpl->xoops_setCaching(2);
$tpl->xoops_setCacheTime(0);
if (!$tpl->is_cached('db:smartsection_rss.html')) {
	$channel_category =  $xoopsModule->name();
	// Check if ML Hack is installed, and if yes, parse the $content in formatForML
	if (method_exists($myts, 'formatForML')) {
		$xoopsConfig['sitename'] = $myts->formatForML($xoopsConfig['sitename']);
		$channel_category =  $myts->formatForML($channel_category);		
	}
	$tpl->assign('channel_title', xoops_utf8_encode(htmlspecialchars($xoopsConfig['sitename'], ENT_QUOTES)));
	$tpl->assign('channel_link', SMARTSECTION_URL);
	$tpl->assign('channel_desc', xoops_utf8_encode(htmlspecialchars($xoopsConfig['slogan'], ENT_QUOTES)));
	$tpl->assign('channel_lastbuild', formatTimestamp(time(), 'rss'));
	$tpl->assign('channel_webmaster', $xoopsConfig['adminmail']);
	$tpl->assign('channel_editor', $xoopsConfig['adminmail']);
	
	if ($categoryid != -1) {
		$channel_category .= " > " . $categoryObj->name();
	}
	
	$tpl->assign('channel_category', $channel_category);
	$tpl->assign('channel_generator', 'SmartSection');
	$tpl->assign('channel_language', _LANGCODE);
	$tpl->assign('image_url', XOOPS_URL.'/images/logo.gif');
	$dimention = getimagesize(XOOPS_ROOT_PATH.'/images/logo.gif');
	if (empty($dimention[0])) {
		$width = 88;
	} else {
		$width = ($dimention[0] > 144) ? 144 : $dimention[0];
	}
	if (empty($dimention[1])) {
		$height = 31;
	} else {
		$height = ($dimention[1] > 400) ? 400 : $dimention[1];
	}
	$tpl->assign('image_width', $width);
	$tpl->assign('image_height', $height);
	$sarray = $smartsection_item_handler->getAllPublished(10,0,$categoryid);
	if (is_array($sarray)) {

		$count = $sarray;
		foreach ($sarray as $item) {
			$tpl->append('items', 
			      array('title' => xoops_utf8_encode(htmlspecialchars($item->title(), ENT_QUOTES)), 
			            'link' => $item->getItemUrl(), 
			            'guid' => $item->getItemUrl(), 
			            'pubdate' => formatTimestamp($item->getVar('datesub'), 'rss'), 
			            'description' => xoops_utf8_encode(htmlspecialchars($item->summary(), ENT_QUOTES))));
		}
	}
}
$tpl->display('db:smartsection_rss.html');
?>