<?php
// $Id: rssc_black_handler.php,v 1.5 2006/07/15 13:37:47 ohwada Exp $

// 2006-07-10 K.OHWADA
// use happy_linux_object happy_linux_object_handler

// 2006-06-04 K.OHWADA
// suppress notice : Only variable references should be returned by reference

// 2006-01-20 K.OHWADA
// small change

//=========================================================
// Rss Center Module
// this file contain 2 class
//   rssc_black
//   rssc_black_handler
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_black_handler') ) 
{

//=========================================================
// class black
//=========================================================
class rssc_black extends happy_linux_object
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_black()
{
	$this->happy_linux_object();

	$this->initVar('bid', XOBJ_DTYPE_INT, null, false);
	$this->initVar('lid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('uid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p1',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p2',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('p3',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('title', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('url',   XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('memo', XOBJ_DTYPE_TXTAREA);
	$this->initVar('aux_int_1',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_int_2',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_text_1', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('aux_text_2', XOBJ_DTYPE_TXTBOX, null, false, 255);
}

//---------------------------------------------------------
// get
//---------------------------------------------------------
function &getVarAll($format='n')
{
	$arr = array(
		'bid' => $this->getVar('bid', $format),
		'lid' => $this->getVar('lid', $format),
		'uid' => $this->getVar('uid', $format),
		'mid' => $this->getVar('mid', $format),
		'p1'  => $this->getVar('p1',  $format),
		'p2'  => $this->getVar('p2',  $format),
		'p3'  => $this->getVar('p3',  $format),
		'title' => $this->getVar('title', $format),
		'url'   => $this->getVar('url',   $format),
		'memo'  => $this->getVar('memo',  $format),
	);

	return $arr;
}

// --- class end ---
}

//=========================================================
// class black handler
//=========================================================
class rssc_black_handler extends happy_linux_object_handler
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_black_handler( $dirname )
{
	$this->happy_linux_object_handler($dirname, 'black', 'bid', 'rssc_black');

	$this->set_debug_db_sql(   RSSC_DEBUG_BLACK_SQL );
	$this->set_debug_db_error( RSSC_DEBUG_ERROR );

}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function _build_insert_sql(&$obj)
{
	foreach ($obj->gets() as $k => $v) 
	{	${$k} = $v;	}

	$sql = 'INSERT INTO '.$this->_table.' (lid, uid, mid, p1, p2, p3, title, url, memo, aux_int_1, aux_int_2, aux_text_1, aux_text_2) VALUES ('.$lid.', '.$uid.', '.$mid.', '.$p1.', '.$p2.', '.$p3.', '.$this->quote($title).', '.$this->quote($url).', '.$this->quote($memo).', '.$aux_int_1.', '.$aux_int_2.', '.$this->quote($aux_text_1).', '.$this->quote($aux_text_1).')';

	return $sql;
}

function _build_update_sql(&$obj)
{
	foreach ($obj->gets() as $k => $v) 
	{	${$k} = $v;	}

	$sql = 'UPDATE '.$this->_table.' SET lid='.$lid.', uid='.$uid.', mid='.$mid.', p1='.$p1.', p2='.$p2.', p3='.$p3.', title='.$this->quote($title).', url='.$this->quote($url).', memo='.$this->quote($memo).', aux_int_1='.$aux_int_1.', aux_int_2='.$aux_int_2.', aux_text_1='.$this->quote($aux_text_1).', aux_text_2='.$this->quote($aux_text_2).' WHERE bid='.$bid;

	return $sql;
}

// --- class end ---
}

// === class end ===
}

?>