<?php 
// $Id: happy_search.php,v 1.1.1.1 2006/12/01 12:19:23 ohwada Exp $ 

//=========================================================
// Happy Search
// 2006-11-11 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('happy_search') ) 
{

//=========================================================
// class happy_search
//=========================================================
class happy_search extends happy_search_modules
{
// class
	var $_myts;
	var $_google_handler;

// search search
	var $_search_results = null;

// set parameter
	var $_query_default = '';

// sort by time
	var $MAX_SHOW_ALL    = 10;
	var $MIN_SHOW_MODULE = 1;
	var $TIME_LIMIT      = 0; // unlimited

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_search()
{
	$this->happy_search_modules();

	$this->_google_handler =& happy_search_google::getInstance();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new happy_search();
	}

	return $instance;
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init( $query_default=null )
{
	$this->set_query_default( $query_default );
	$this->get_post_get_param();
	$this->set_min_keyword( $this->get_xoops_keyword_min() );
	$this->get_search_display_text();
}

function get_post_get_param()
{
	$this->get_search_post_query();
	$this->get_search_post_action();
	$this->get_post_get_andor();
	$this->get_post_get_uid();
	$this->get_post_get_mid();
	$this->get_post_get_mids();
	$this->get_post_get_start();
	$this->get_post_get_showcontext();
}

function get_search_post_query()
{
	$query = null;
	if ( $this->_post->is_post_set('query') )
	{
		$query = $this->_post->get_post_text('query');
	}
	elseif ( $this->_post->is_get_set('query') )
	{
		$query = $this->_post->get_get_text('query');
	}
	elseif ( $this->_query_default )
	{
		$query = $this->_query_default;
	}
	$this->_post_query = $query;
	return $query;
}

function get_search_post_action()
{
	$action = $this->_post->get_post_get_text('action');

	switch ( $action )
	{
		case 'results':
		case 'showall':
		case 'showallbyuser':
		case 'google';
			$ret = $action;
			break;

		case 'search';
		default:
			if ( $this->_post_query )
			{
				$ret = 'results';
			}
			else
			{
				$ret = 'search';
			}
			break;

	}

	$this->_post_action = $ret;
	return $ret;
}

//---------------------------------------------------------
// check param
//---------------------------------------------------------
function check_input_param()
{
	if ( $this->_post_action == 'google' )
	{
		$this->set_flag_cabdicate(0);
	}

	$ret1 = $this->check_post_get_param_default();
	if ($ret1 == HAPPY_SEARCH_CODE_NORMAL)
	{
		$ret2 = $this->parse_query_default();
		if ( !$ret2 )
		{
			$ret1 = HAPPY_SEARCH_CODE_KEYTOOSHORT;
		}
	}
	return $ret1;
}

//---------------------------------------------------------
// search_in_modules
//---------------------------------------------------------
function search_in_modules( $limit )
{
// always show context
	$_GET['showcontext']     = 1;
	$this->_post_showcontext = 1;

	return $this->action_results_default( $limit );
}

function sort_results_by_time( $module_results )
{
	$serial = 0;	// all article
	$art_all_arr  = array();
	$art_time_arr = array();
	$art_time_flag_arr = array();

	if ( !is_array($module_results) || (count($module_results) == 0) )
	{
		return false;
	}

	$time_limit = 0;
	if ( $this->TIME_LIMIT )
	{
		$time_limit = time() - $this->TIME_LIMIT;
	}

	foreach( $module_results as $module )
	{
		$j = 0;
		foreach ($module['results'] as $result)
		{
			$art_temp                = $result;
			$art_temp['mod_name']    = $module['name'];
			$art_temp['mod_dirname'] = $module['dirname'];
			$art_temp['serial_num']  = $serial;

			$art_all_arr[$serial]  = $art_temp;

			$time                  = $result['time'];
			$art_time_arr[$serial] = $time;

// mark time flag, if less than min show
			$flag_time = 0;
			if ( ($this->MIN_SHOW_MODULE > 0) && ($j < $this->MIN_SHOW_MODULE) && ($time > $time_limit) )
			{
				$flag_time = 1;
			}
			$art_time_flag_arr[$serial] = $flag_time;

			$j ++;
			$serial ++;
		}
	}

// sort by time
	arsort($art_time_arr, SORT_NUMERIC);

// mark time flag
	$i = 0;
	foreach ($art_time_arr as $num => $time)
	{
		if ( $time > $time_limit )
		{
			$art_time_flag_arr[$num] = 1;
		}

		$i ++;
		if ($i >= $this->MAX_SHOW_ALL) break;
	}

	$i = 0;
	$article_array = array();

// sort by time
	foreach ($art_time_arr as $num => $time)
	{
		if ( $art_time_flag_arr[$num] )
		{
			$article_array[$i++] = $art_all_arr[$num];
		}
	}

	return $article_array;
}

//---------------------------------------------------------
// search_in_google
//---------------------------------------------------------
function &get_google_post()
{
	$post =& $_GET;
	$post['query_urlencode'] = $this->get_query_urlencode();

	if ( !$this->_post->is_get_fill('search') )
	{
		$config =& $this->_google_handler->get_config();
		$post['search'] = $config['sldefault'];
	}

	return $post;
}

function search_in_google( $limit )
{
// input
	$search = $this->_google_handler->get_post_search();
	$page   = $this->_google_handler->get_post_page();
	$query  = $this->get_query_for_google();

	return $this->_google_handler->search( $query, $search, $page, $limit );
}

function &get_google_results()
{
	$ret =& $this->_google_handler->get_results();
	return $ret;
}

function get_google_error()
{
	return $this->_google_handler->get_error();
}

function &get_google_soap_error()
{
	$ret =& $this->_google_handler->get_soap_error();
	return $ret;
}

function get_google_lr_select()
{
	return $this->_google_handler->get_lr_select();
}

function get_google_sl_select()
{
	return $this->_google_handler->get_sl_select();
}

function &get_google_paginate()
{
	$ret =& $this->_google_handler->get_paginate();
	return $ret;
}

//---------------------------------------------------------
// set parameter
//---------------------------------------------------------
function set_search_flag_highlight($val)
{
	$this->set_flag_highlight( $val );
	$this->_google_handler->set_flag_highlight( $val );
}

function set_max_show_all($val)
{
	$this->MAX_SHOW_ALL = intval($val);
}

function set_min_show_module($val)
{
	$this->MIN_SHOW_MODULE = intval($val);
}

function set_time_limit($val)
{
	$this->TIME_LIMIT = intval($val);
}

function set_query_default($val)
{
	$this->_query_default = $val;
}

// --- class end --
}

// === class end ===
}

?>