<?php
// $Id: class.bin_link_check.php,v 1.9 2006/09/30 12:01:54 ohwada Exp $

// 2006-09-10 K.OHWADA
// use happy_linux

// 2006-06-21 K.OHWADA
// BUG 4060: The command line of refreshed sites are limited to 10 sites.

// 2006-05-15 K.OHWADA
// new handler

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication


//=========================================================
// WebLinks Module
// class bin_link_check
// 2004-11-28 K.OHWADA
//=========================================================

class bin_link_check extends happy_linux_bin_base
{
// class
	var $_check;

// constant
	var $_TITLE           = _WEBLINKS_ADMIN_LINK_BROKEN_CHECK;
	var $_FILENAME_RESULT = 'link_check.html';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function bin_link_check( $dirname )
{
	$this->happy_linux_bin_base( $dirname );
	$this->set_mailer( 'XOOPS rssc' );
	$this->set_result_file( $this->_FILENAME_RESULT );

	$this->_check  =& weblinks_get_handler( 'link_check',    $dirname );
	$this->_config =& weblinks_get_handler( 'config2_basic', $dirname );

	$this->_goto_admin = _WEBLINKS_ADMIN_GOTO_ADMIN_INDEX;
}

//---------------------------------------------------------
// check link broken
//---------------------------------------------------------
function check()
{
	$this->_config->init();
	$conf_data =& $this->_config->get_conf();
	$pass      =  $conf_data['bin_pass'];
	$mailto    =  $conf_data['bin_mailto'];
	$flag_send =  $conf_data['bin_send'];

	if ( !$this->_set_env_param($pass) )
	{
		return false;
	}

	$this->_check->set_flag_echo(     $this->_flag_print );
	$this->_check->set_flag_echo_lid( $this->_argv_2 );

// --- file open ---
	$this->_file_open( $this->_file_result );

	if ($this->_flag_write && $this->_fp)
	{
		$this->_check->set_write( $this->_fp );
	}

	$this->_html_header();

	$this->_check->check($this->_limit);

	$this->_html_footer();
	$this->_file_close();
// --- file close ---

	if ($flag_send)
	{
		$total_link      = $this->_check->total_link;
		$num_link_broken = $this->_check->num_link_broken;

// mail
		$text = <<<END_OF_TEXT
total  links: $total_link
broken links: $num_link_broken
END_OF_TEXT;

		$this->_send_mail($mailto, $this->_TITLE, $text);
	}
}

//---------------------------------------------------------
}

?>