<?php
// $Id: weblinks_build_rss_handler.php,v 1.2 2007/03/06 02:01:51 ohwada Exp $

// 2007-03-01 K.OHWADA
// link_basic_handler

// 2006-09-20 K.OHWADA
// this is new file
// porting from rssc_build_rssc

//=========================================================
// WebLinks Module
// 2006-09-20 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_build_rss_handler') ) 
{

//=========================================================
// class weblinks_build_rss_handler
//=========================================================
class weblinks_build_rss_handler extends happy_linux_build_rss
{
	var $_MAX_ITEMS = 20;
	var $_DIRNAME;

	var $_link_handler;
	var $_link_view;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_build_rss_handler( $dirname )
{
	$this->_DIRNAME = $dirname;

	$RDF_TEMPLATE  = WEBLINKS_ROOT_PATH.'/templates/xml/weblinks_build_rdf.html';
	$RSS_TEMPLATE  = WEBLINKS_ROOT_PATH.'/templates/xml/weblinks_build_rss.html';
	$ATOM_TEMPLATE = WEBLINKS_ROOT_PATH.'/templates/xml/weblinks_build_atom.html';

	$this->happy_linux_build_rss();
	$this->set_rdf_template(  $RDF_TEMPLATE );
	$this->set_rss_template(  $RSS_TEMPLATE );
	$this->set_atom_template( $ATOM_TEMPLATE );
	$this->set_generator(  'XOOPS WebLinks' );
	$this->set_category(   'WebLinks' );
	$this->set_rdf_title(  'WebLinks: RDF Feeds' );
	$this->set_rss_title(  'WebLinks: RSS Feeds' );
	$this->set_atom_title( 'WebLinks: ATOM Feeds' );
	$this->set_flag_force_build( 1 );	// always build

	$this->_link_handler =& weblinks_get_handler( 'link_basic', $dirname );
	$this->_link_view    =& weblinks_link_view::getInstance( $dirname );

}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init( $mode )
{
	$this->set_mode( $mode );
	$this->set_items( $this->get_latest() );
}

//---------------------------------------------------------
// link handler
//---------------------------------------------------------
function get_latest()
{
	$lid_arr =& $this->_link_handler->get_lid_array_latest( $this->_MAX_ITEMS );

	$arr = array();
	if ( is_array($lid_arr) && ( count($lid_arr) > 0 ) )
	{
		foreach ($lid_arr as $lid)
		{
			$arr[] = $this->_link_view->get_rss_by_lid( $lid );
		}
	}
	return $arr;
}

//---------------------------------------------------------
// RDF
//---------------------------------------------------------
function _build_rdf_item( $item )
{
	$ret = $this->_build_common_item( $item );
	return $ret;
}

//---------------------------------------------------------
// RSS
//---------------------------------------------------------
function _build_rss_item( $item )
{
	$arr = $this->_build_common_item( $item );

// guid
	if ( empty($arr['guid']) )
	{
		$arr['guid'] = $arr['link'];
	}

// date
	$arr['pubdate'] = $arr['date_rfc822'];

	return $arr;
}

//---------------------------------------------------------
// ATOM
//---------------------------------------------------------
function _build_atom_entry( $entry )
{
	$arr = $this->_build_common_item( $entry );

// title
	$arr['title'] = $this->_build_xml_title($entry['title'], 0, 0);

// must content or summary
	if ( empty($arr['content']) && empty($arr['summary']) )
	{
		$arr['summary'] = $arr['title'];
	}

// must author_name
	if ( empty($arr['author_name']) )
	{
		$arr['author_name']  = $this->_xml( $this->_site_author_name );
		$arr['author_uri']   = '';
		$arr['author_email'] = '';
	}

// atom id
	if ( $arr['entry_id'] )
	{
		$arr['id'] = $arr['entry_id'];
	}
	else
	{
		$atom_id = "tag:".$this->_site_tag.",".$this->_site_year."://1.1.".$this->_count_line;
		$arr['id'] = $this->_xml( $atom_id );
	}

// date
	$arr['updated']   = $arr['updated_iso8601'];
	$arr['published'] = $arr['published_iso8601'];

	$this->_count_line ++;

	return $arr;
}

//---------------------------------------------------------
// common
//---------------------------------------------------------
function _build_common_item( $item )
{
// title content 
	$title_xml   = $this->_build_xml_title(   $item['title'] );
	$content_xml = $this->_build_xml_content( $item['content'] );
	$sum_xml     = $this->_build_xml_summary( $item['content'], 0, 0 );

	$link_xml        = $this->_xml_url( $item['link'] );
	$category_xml    = $this->_xml( $item['category'] );
	$author_name_xml = $this->_xml( $item['author_name'] );

	$published_unix  = intval( $item['time_create'] );
	$updated_unix    = intval( $item['time_update'] );
	$published_rfc822_xml  = $this->_xml( date("r", $published_unix ) );
	$updated_rfc822_xml    = $this->_xml( date("r", $updated_unix ) );
	$published_iso8601_xml = $this->_xml( $this->_iso8601_date( $published_unix ) );
	$updated_iso8601_xml   = $this->_xml( $this->_iso8601_date( $updated_unix ) );

	$ret = array(
		'link'              => $link_xml,
		'guid'              => $link_xml,
		'entry_id'          => '',
		'author_uri'        => $this->_xml_url( $item['author_uri'] ),
		'author_email'      => $this->_xml(     $item['author_email'] ),
		'author_name'       => $author_name_xml,
		'title'             => $title_xml,
		'summary'           => $sum_xml,
		'description'       => $sum_xml,
		'content'           => $content_xml,
		'category'          => $category_xml,
		'published_unix'    => $published_unix,  // unixtime
		'updated_unix'      => $updated_unix,    // unixtime
		'published_rfc822'  => $published_rfc822_xml,
		'date_rfc822'       => $published_rfc822_xml,
		'updated_rfc822'    => $updated_rfc822_xml,
		'published_iso8601' => $published_iso8601_xml,
		'date_iso8601'      => $published_iso8601_xml,
		'updated_iso8601'   => $updated_iso8601_xml,
		'dc_subject'        => $category_xml,
		'dc_creator'        => $author_name_xml,
		'dc_date'           => $published_iso8601_xml,
		'content_encoded'   => $content_xml,
	);

	return $ret;
}

function _get_last_updated_unix( $items )
{
	$time = false;
	if ( isset($items[0]['time_update']) )
	{
		$time = $items[0]['time_update'];
	}
	return $time;
}

// --- class end ---
}

// === class end ===
}

?>