<?php
// $Id: weblinks_link_form_check_handler.php,v 1.4 2007/02/27 14:46:01 ohwada Exp $

// 2007-02-20 K.OHWAD
// check_captcha_by_post()

// 2006-12-03 K.OHWADA
// small change _build_html_error_msg() _check_desc_by_post()

// 2006-10-14 K.OHWADA
// BUG: check_url_double dont work correctly

// 2006-09-20 K.OHWADA
// this is new file
// move from weblinks_link_edit_handler.php

//=========================================================
// WebLinks Module
// 2006-05-20 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_form_check_handler') ) 
{

//=========================================================
// class weblinks_link_form_check_handler
//=========================================================
class weblinks_link_form_check_handler extends happy_linux_error
{
	var $_DIRNAME;

	var $_config_handler;
	var $_link_handler;
	var $_linkitem_handler;

	var $_system;
	var $_post;

// config
	var $_conf;
	var $_conf_desc_option = array();

// error message
	var $error_msg_flag_lid_full = 0;
	var $error_msg_flag_lid_part = 0;
	var $error_msg_lid_arr_full  = array();
	var $error_msg_lid_arr_part  = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_form_check_handler( $dirname )
{
	$this->happy_linux_error();

	$this->_DIRNAME = $dirname;

	$this->_config_handler   =& weblinks_get_handler( 'config2_basic',   $dirname );
	$this->_link_handler     =& weblinks_get_handler( 'link',            $dirname );
	$this->_linkitem_handler =& weblinks_get_handler( 'linkitem_define', $dirname );

	$this->_system  =& happy_linux_system::getInstance();
	$this->_post    =& happy_linux_post::getInstance();

	$this->_conf = $this->_config_handler->get_conf();

}

//---------------------------------------------------------
// POST param
//---------------------------------------------------------
function get_post_url()
{
	$url = $this->_post->get_post_text('url');
	return $url;
}

//---------------------------------------------------------
// check form
//---------------------------------------------------------
function check_form_addlink_by_post()
{
	$ret = $this->check_form_common( true, true );
	return $ret;
}

function check_form_modlink_for_owner_by_post()
{
	$ret = $this->check_form_common( true, false );
	return $ret;
}

function check_form_modlink_by_post( $is_owner=true )
{
	$ret = $this->check_form_common( $is_owner, false);
	return $ret;
}

function check_form_common( $is_owner=true, $flag_new=true )
{
	$linkitem_arr =& $this->_get_linkitem_load();

	$this->_clear_errors();

	foreach ($linkitem_arr as $id => $v )
	{
		$name  = $this->_get_linkitem_by_itemid($id, 'name');
		$mode  = $this->_get_linkitem_by_itemid($id, 'user_mode');
		$form  = $this->_get_linkitem_by_itemid($id, 'user_form');
		$title = $this->_get_linkitem_by_itemid($id, 'title');

		switch ($name)
		{
			case 'name':
			case 'mail':
			case 'usercomment':
				if (( $mode == 2 )&& $is_owner )
				{
					$this->_check_fill_by_post( $name, $title);
				}
				break;

			case 'banner':
			case 'rss_url':
				$this->_check_url_form_by_post( $name, $title, $mode);
				break;

			case 'description':
				$this->_check_desc_by_post( $name, $title, $mode);
				break;

			case 'cat':
				$this->_check_cat_by_post( $name, $title, $mode);
				break;

			case 'url':
				$this->_check_url_by_post( $name, $title, $mode, $flag_new);
				break;

			case 'passwd':
				$this->_check_passwd_by_post( $name, $title, $flag_new);
				break;

			case 'captcha':
				$this->_check_captcha_by_post();
				break;

			default:
				if ( $mode == 2 )
				{
					$this->_check_fill_by_post( $name, $title);
				}
				break;
		}
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// check routine
//---------------------------------------------------------
function _check_fill_by_post($name, $title)
{
	if ( !$this->_post->is_post_fill($name) )
	{
		$msg = sprintf(_WLS_ERROR_FILL, $title);
		$this->_set_errors( $msg );
		return false;
	}

	return true;
}

function _check_desc_by_post($name, $title, $mode)
{
	$desc = '';
	if ( isset($_POST['weblinks_description']) )
	{
		$desc = $_POST['weblinks_description'];
	}

	if ( ( $mode == 2 ) && ($desc === '') )
	{
		$msg = sprintf(_WLS_ERROR_FILL, $title);
		$this->_set_errors( $msg );
	}
}

function _check_cat_by_post( $name, $title, $mode)
{
	$flag_cid = false;
	foreach ($_POST['cid'] as $cid)
	{
		if ( intval($cid) != 0 )
		{	$flag_cid = true;	}
	}

	if ( !$flag_cid )
	{
		$msg = sprintf(_WLS_ERROR_FILL, $title);
		$this->_set_errors( $msg );
	}
}

function _check_url_form_by_post( $name, $title, $mode)
{
// bug fix: misjudge to check url

	$flag_err = false;

	if ( $mode == 2 )
	{
		if ( !$this->_post->is_post_url_fill($name) )
		{
			$msg1 = sprintf( _WLS_ERROR_FILL, $title);
			$this->_set_errors( $msg1 );
			$flag_err = true;
		}
	}

	if ( !$this->_post->is_post_url_llegal($name) )
	{
		$msg1 = sprintf( WLS_ERROR_ILLEGAL, $title);
		$this->_set_errors( $msg1 );
		$flag_err = true;
	}

	if ( $flag_err )
	{
		return false;
	}
	return true;
}

function _check_url_by_post( $name, $title, $mode, $flag_new)
{
	$this->_check_url_form_by_post( $name, $title, $mode);

	if ($flag_new)
	{
		$url = $this->get_post_url();
		$this->_check_url_double($url);
	}
}

function _check_url_double($url)
{
	$this->error_msg_flag_lid_full = 0;
	$this->error_msg_flag_lid_part = 0;
	$this->error_msg_lid_arr_full  = array();
	$this->error_msg_lid_arr_part  = array();

	if ( $this->_conf['check_double'] >= 1 )
	{
		$ret = $this->_check_url_full( $url );
		if ( !$ret )
		{
			return false;	// error
		}
	}

	if ( $this->_conf['check_double'] == 2 )
	{
		$ret = $this->_check_url_part( $url );
		if ( !$ret )
		{
			return false;	// warning
		}
	}

	return true;	// OK
}

function _check_url_full($url)
{
	if (( $url == "" )||( $url == "http://" ))
	{	return true;	}	// no check

	$this->error_msg_lid_arr_full =& $this->_get_link_lid_array_by_url($url);

	if ( count($this->error_msg_lid_arr_full) ) 
	{

// BUG: check_url_double dont work correctly
		$this->_set_error_flag();

		$this->error_msg_flag_lid_full = 1;
		return false;	// NG
	}

	return true;	// OK
}

function _check_url_part($url)
{
	if (( $url == "" )||( $url == "http://" ))
	{	return true;	}	// no check

	$arr_out = array();

	$lid_arr =& $this->_get_link_lid_array();

	foreach ($lid_arr as $lid)
	{
		$flag = 0;

		$obj = $this->get($lid);
		if ( !is_object($obj) )  { continue; }

		$url_db   = $obj->get('url');
		$url_db_r = str_replace("|", '\|', $url_db);
		$url_r    = str_replace("|", '\|', $url);

		if ( preg_match("|$url_db_r|", $url) )
		{	$flag = 1;	}

		if ( preg_match("|$url_r|", $url_db) )
		{	$flag = 1;	}

		if ($flag)
		{
			$arr_out[] = $lid;
		}
	}

	$this->error_msg_lid_arr_part = $arr_out;
	if ( count($this->error_msg_lid_arr_part) > 0 ) 
	{
		$this->_set_error_flag();
		$this->error_msg_flag_lid_part = 1;
		return false;	// NG
	}

	return true;	// OK
}

function _check_passwd_by_post( $name, $title, $flag_new )
{
	$name1 = 'passwd_new';
	$name2 = 'passwd_2';

	if ( !isset( $_POST[$name1] ) || ( $_POST[$name1] == '') )
	{
		if ( $flag_new && $this->_conf['use_passwd'] && $this->_system->is_guest() )
		{
			$msg = sprintf(_WLS_ERROR_FILL, $title);
			$this->_set_errors( $msg );
			return false;
		}

		return true;	// no check
	}

	$pass1 = $this->_post->get_post_text( $name1 );
	$pass2 = $this->_post->get_post_text( $name2 );

	if ( strlen($pass1) < $this->_conf['passwd_min'] ) 
	{
		$msg = _WEBLINKS_ERROR.": ".sprintf(_US_PWDTOOSHORT, $this->_conf['passwd_min'] );
		$this->_set_errors( $msg );
		return false;
	}

	if ($pass1 != $pass2) 
	{
		$msg = _WEBLINKS_ERROR.": "._US_PASSNOTSAME;
		$this->_set_errors( $msg );
		return false;
	}

	return true;
}

function _check_captcha_by_post()
{
// check if geust
	if ( $this->_conf['use_captcha'] && file_exists(XOOPS_ROOT_PATH.'/modules/captcha/include/api.php') ) 
	{
		include_once XOOPS_ROOT_PATH.'/modules/captcha/include/api.php';
		if ( !$captcha_api->validate_post_if_guest() )
		{
			$this->_set_errors( _WEBLINKS_ERROR_CAPTCHA );
			return false;
		}
	}
	return true;
}

//---------------------------------------------------------
// error message
//---------------------------------------------------------
function get_error_msg_addlink()
{
	$text = '';

	if ( $this->_error_flag )
	{
		$text .= $this->get_error_msg_modlink();
	}

	if ( $this->error_msg_flag_lid_full ) 
	{
		$text .= $this->_build_html_error_msg(_WLS_ERROR_URL_EXIST );
		$text .= $this->_build_html_error_url( $this->error_msg_lid_arr_full );
	}

	if ( $this->error_msg_flag_lid_part ) 
	{
		$text .= $this->_build_html_error_msg(_WLS_WARNING_URL_EXIST );
		$text .= $this->_build_html_error_url( $this->error_msg_lid_arr_part );
	}

	return $text;
}

function get_error_msg_modlink()
{
	$text = $this->_build_html_error_msg( $this->getErrors('s') );
	return $text;
}

function _build_html_error_msg( $error )
{
	$msg = '';
	if ( $error )
	{
		$msg = '<h4 style="color: #ff0000;">'.$error."</h4>\n";
	}
	return $msg;
}

function _build_html_error_url($lid_arr)
{
	$text = "<ul>";

	foreach( $lid_arr as $lid )
	{
		$text .= $this->_build_html_error_url_single($lid);
	}

	$text .= "</ul>\n";

	return $text;
}

function _build_html_error_url_single($lid)
{
	$obj = $this->_link_handler->get($lid);
	if ( !is_object($obj) )  { return ''; }

	$title_s = $obj->getVar('title');
	$lid_s   = sprintf("%03d", $lid);
	$url_single = WEBLINKS_URL.'/singlelink.php?lid='.$lid;
	$text = '<li><a href="'.$url_single.'" target="_blank">'.$lid_s.': '.$title_s."</a></li>\n";
	return $text;
}

//---------------------------------------------------------
// link_handler
//---------------------------------------------------------
function &_get_link_lid_array()
{
	$ret =& $this->_link_handler->getList();
	return $ret;
}

function &_get_link_lid_array_by_url($url)
{
	$criteria = new criteriaCompo();
	$criteria->add( new criteria('url', $url, '=') );
	$ret =& $this->_link_handler->getList($criteria);
	return $ret;
}

//---------------------------------------------------------
// linkitem_define_handler
//---------------------------------------------------------
function &_get_linkitem_load()
{
	$ret =& $this->_linkitem_handler->load();
	return $ret;
}

function _get_linkitem_by_itemid($id, $key)
{
	return $this->_linkitem_handler->get_by_itemid($id, $key);
}

function _get_linkitem_by_name($name, $key)
{
	return $this->_linkitem_handler->get_by_name($name, $key);
}

// --- class end ---
}

// === class end ===
}

?>