<?php
// $Id: admin_import_base_class.php,v 1.5 2006/09/27 03:02:48 ohwada Exp $

// 2006-09-20 K.OHWADA
// use XoopsGTicket
// use build_lib_box_limit_offset() : remove admin_import_form

// 2006-07-10 K.OHWADA
// this is new file
// move from admin_import_class.php

//=========================================================
// RSS Center Module
// 2006-07-10 K.OHWADA
//=========================================================

//=========================================================
// class admin_import_base
//=========================================================
class admin_import_base extends happy_linux_basic_handler
{
	var $_LIMIT = 100;

	var $_link_handler;
	var $_black_handler;
	var $_white_handler;
	var $_feed_handler;

	var $_form;
	var $_system;
	var $_strings;

// local
	var $_lid_list_by_p1   = array();
	var $_lid_list_by_url  = array();
	var $_link_objs_by_lid = array();
	var $_table_rssc_link;
	var $_table_rssc_feed;
	var $_table_rssc_black;
	var $_table_rssc_white;

	var $_dirname_orig;
	var $_mid = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_import_base()
{
	$this->happy_linux_basic_handler( RSSC_DIRNAME );

	$this->_system  =& happy_linux_system::getInstance();
	$this->_strings =& happy_linux_strings::getInstance();
	$this->_form    =& happy_linux_form_lib::getInstance();

	$this->_link_handler  =& rssc_get_handler( 'link',  RSSC_DIRNAME );
	$this->_black_handler =& rssc_get_handler( 'black', RSSC_DIRNAME );
	$this->_white_handler =& rssc_get_handler( 'white', RSSC_DIRNAME );
	$this->_feed_handler  =& rssc_get_handler( 'feed',  RSSC_DIRNAME );

	$this->_table_rssc_link  = $this->prefix( 'link'  );
	$this->_table_rssc_feed  = $this->prefix( 'feed'  );
	$this->_table_rssc_black = $this->prefix( 'black' );
	$this->_table_rssc_white = $this->prefix( 'white' );
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_import_base();
	}

	return $instance;
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function get_mid()
{
	$this->_mid = $this->_system->get_mid_by_dirname( $this->_dirname_orig );
	return $this->_mid;
}

function set_dirname_orig($val)
{
	$this->_dirname_orig = $val;
}

function exist_module()
{
	if ($this->_mid)
	{
		return true;
	}
	return false;
}

function get_msg_not_installed()
{
	$msg = $this->_dirname_orig." module is not installed \n";
	return $msg;
}

//---------------------------------------------------------
// private
//---------------------------------------------------------
function _print_finish()
{
	echo "<br /><hr />\n";
	echo "<h4>FINISHED</h4>\n";
	echo "<a href='index.php'>GOTO Admin Menu</a><br />\n";
}

//---------------------------------------------------------
// link_handler
//---------------------------------------------------------
function _exist_url($url)
{
	$list =& $this->_link_handler->get_list_by_rssurl( $url );
	if ( is_array($list) && (count($list) > 0) )
	{
		return true;
	}
	return false;
}

function _set_lid_list()
{
	$link_objs =& $this->_link_handler->getObjects();

	$arr1 = array();
	$arr2 = array();
	$arr3 = array();

	foreach ( $link_objs as $obj )
	{
		$lid = $obj->get('lid');
		$url = $obj->get('url');
		$p1  = $obj->get('p1');

		if ( $p1 )
		{
			$arr1[ $p1 ]  = $lid;
		}

		if ( $url )
		{
			$arr2[ $url ] = $lid;
		}

		$arr3[ $lid ] = $obj;
	}

	$this->_lid_list_by_p1   = $arr1;
	$this->_lid_list_by_url  = $arr2;
	$this->_link_objs_by_lid = $arr3;

}

function _get_feed_lid($arr)
{
	$lid = $arr['lid'];
	$url = $arr['site_url'];

	if ( isset( $this->_list_list_by_p1[$lid] ) )
	{
		$val = $this->_list_list_by_p1[$lid];
	}
	elseif ( isset( $this->_lid_list_by_url[$url] ) )
	{
		$val = $this->_lid_list_by_url[$url];
	}
	else
	{
		$val = 0;
	}

	return $val;
}

function _get_feed_uid($lid)
{
	$ret = 0;
	$obj =& $this->_get_link_obj_by_lid($lid);
	if ( is_object($obj) )
	{
		$ret = $obj->get('uid');
	}
	return $ret;
}

function _get_feed_p1($lid)
{
	$ret = 0;
	$obj =& $this->_get_link_obj_by_lid($lid);
	if ( is_object($obj) )
	{
		$ret = $obj->get('p1');
	}
	return $ret;
}

function &_get_link_obj_by_lid($lid)
{
	$obj = false;
	if ( isset($this->_link_objs_by_lid[$lid]) )
	{
		$obj = $this->_link_objs_by_lid[$lid];
	}
	return $obj;
}

function _exist_feed($link)
{
	$count =& $this->_feed_handler->get_count_by_link($link);
	if ( $count )
	{
		return true;
	}
	return false;
}

//---------------------------------------------------------
// form
//---------------------------------------------------------
function _print_form_next($title, $op, $submit, $offset=0)
{
	echo "<br /><hr />\n";
	echo "<h4>".$title."</h4>\n";

	if ($offset)
	{
		$next = $offset + $this->_LIMIT;
		echo "Import ".$offset." - ".$next." th record<br />\n";
	}

// show form
	$limit  = 0;
	$desc   = '';
	$action = '';
	$text = $this->_form->build_lib_box_limit_offset($title, $desc, $limit, $offset, $op, $submit, $action);
	echo $text;
}

function check_token()
{
	$ret = $this->_form->check_token();
	return $ret;
}

// --- class end ---
}

?>