<?php
// $Id: mail_users.php,v 1.13 2007/07/22 11:23:55 ohwada Exp $

// 2007-07-16 K.OHWADA
// XC 2.1
// mailusers.php
// admin_mail_form

// 2007-05-18 K.OHWADA
// XC 2.1: remove $AUTHOR

// 2006-05-06 K.OHWADA
// BUG 4565: cannot show user manage, when too many links or users
// change print_form()

// 2006-12-10 K.OHWADA
// use user_name() user_mail()

// 2006-09-20 K.OHWADA
// use happy_linux
// use XoopsGTicket

// 2006-05-15 K.OHWADA
// new handler
// add class admin_mail_users
// use token ticket

// 2006-03-15 K.OHWADA
// use weblinks_pagenavi_basic::getInstance()

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// mailusers
// porting from xoops mailusers.php
// 2005-01-20 K.OHWADA
//=========================================================
include 'admin_header.php';
include_once XOOPS_ROOT_PATH.'/class/xoopsformloader.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_mailer.php';

$XOOPS_LANGUAGE = $xoopsConfig['language'];

// XC 2.1 dont have system module
if ( file_exists(XOOPS_ROOT_PATH.'/modules/system/language/'.$XOOPS_LANGUAGE.'/admin.php') ) 
{
	include_once XOOPS_ROOT_PATH.'/modules/system/language/'.$XOOPS_LANGUAGE.'/admin.php';
}
elseif ( file_exists(XOOPS_ROOT_PATH.'/modules/system/language/english/admin.php') ) 
{
	include_once XOOPS_ROOT_PATH.'/modules/system/language/english/admin.php';
}
else
{
	define('_MD_AM_DBUPDATED', _WLS_DBUPDATED);
}

if ( file_exists(XOOPS_ROOT_PATH.'/modules/system/language/'.$XOOPS_LANGUAGE.'/admin/mailusers.php') ) 
{
	include_once XOOPS_ROOT_PATH.'/modules/system/language/'.$XOOPS_LANGUAGE.'/admin/mailusers.php';
}
elseif ( file_exists(WEBLINKS_ROOT_PATH.'/language/'.$XOOPS_LANGUAGE.'/mailusers.php') ) 
{
	include_once WEBLINKS_ROOT_PATH.'/language/'.$XOOPS_LANGUAGE.'/mailusers.php';
}
else
{
	include_once WEBLINKS_ROOT_PATH.'/language/english/mailusers.php';
}


//=========================================================
// class admin_mail_users
//=========================================================
class admin_mail_users
{
	var $_MAX_USER = 50;

	var $_link_handler;
	var $_form;
	var $_post;
	var $_system;

	var $_start = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_mail_users()
{
	$this->_link_handler  =& weblinks_get_handler('link', WEBLINKS_DIRNAME);

	$this->_form     =& admin_mail_form::getInstance();
	$this->_form->set_max_user( $this->_MAX_USER );

	$this->_post     =& happy_linux_post::getInstance();
	$this->_system   =& happy_linux_system::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_mail_users();
	}
	return $instance;
}

//---------------------------------------------------------
// post parameter
//---------------------------------------------------------
function get_post_op()
{
	return $this->_post->get_post_text('op');
}

function _get_post_start()
{
	$this->_start = $this->_post->get_post_int('start');
	return $this->_start;
}

function _calc_end( $total )
{
	$end = $total;
	if ($total > ($this->_start + $this->_MAX_USER))
	{
		$end = $this->_start + $this->_MAX_USER;
	}
	return $end;
}

//---------------------------------------------------------
// send user
//---------------------------------------------------------
function send_user()
{
	if ( !isset($_POST['user_list']) || !is_array($_POST['user_list']) )
	{
		echo '<h4 style="color: #ff0000">'._AM_WEBLINKS_NO_EMAIL.'</h4>'."\n";
		return;
	}

	$user_list = $_POST['user_list'];

	$added    = array();
    $added_id = array();

   	foreach ($user_list as $uid) 
   	{
       	if ( !in_array($uid, $added_id) ) 
       	{
           	$added[]    =& new XoopsUser($uid);
            $added_id[] = $uid;
        }
    }

    $total = count($added); 

	$from_name  = $this->_post->get_post_text('from_name');
	$from_email = $this->_post->get_post_text('from_email');
	$subject    = $this->_post->get_post_text('subject');
	$body       = $this->_post->get_post_text('body');
    $start      = $this->_get_post_start();
    $end        = $this->_calc_end( $total );

    if ( $total > 0 ) 
    {
        $end = $this->_calc_end( $total );
        $xoopsMailer =& getMailer();
        
        for ( $i = $start; $i < $end; $i++) 
        {
        	$xoopsMailer->setToUsers( $added[$i] );
        }
        
        $xoopsMailer->setFromName(  $from_name );
        $xoopsMailer->setFromEmail( $from_email );
        $xoopsMailer->setSubject(   $subject );
        $xoopsMailer->setBody(      $body );
       	$xoopsMailer->useMail();
		$xoopsMailer->send(true);

        echo $xoopsMailer->getSuccess();
        echo $xoopsMailer->getErrors();

        if ( $total > $end ) 
        {
        	$this->_form->print_form_next( $end );
        }
        else 
        {
        	echo "<h4>"._AM_SENDCOMP."</h4>";
        }
	}
	else 
	{
    	echo "<h4>"._AM_NOUSERMATCH."</h4>";
    }
}

//---------------------------------------------------------
// send link users
//---------------------------------------------------------
function send_link()
{
	if ( !isset($_POST['link_list']) || !is_array($_POST['link_list']) )
	{
		echo '<h4 style="color: #ff0000">'._AM_WEBLINKS_NO_EMAIL.'</h4>'."\n";
		return;
	}

	$link_list = $_POST['link_list'];

	$total = 0;
	if ( is_array($link_list) )
	{
		$total = count($link_list);
	}

	$from_name  = $this->_post->get_post_text('from_name');
	$from_email = $this->_post->get_post_text('from_email');
	$subject    = $this->_post->get_post_text('subject');
	$body       = $this->_post->get_post_text('body');
	$start      = $this->_get_post_start();
	$end        = $this->_calc_end( $total );

	printf(_WEBLINKS_THERE_ARE_EMAIL, $total);
	echo "<br />\n";
	printf(_WEBLINKS_SEND_NUM, $start + 1, $end);
	echo "<br /><br />\n";

	$users = array();

	for ( $i=$start; $i<$end; $i++) 
	{
		$lid = intval( $link_list[$i] );
		$obj =& $this->_link_handler->get($lid);

		$user_name = $obj->user_name('n');
		$user_mail = $obj->user_mail('n');

		$users[] = array(
			'lid'   => $lid,
			'name'  => $user_name,
			'email' => $user_mail,
		);
	}

// mail start
	$debug = true;
	$mailer = new weblinks_mailer();
	$mailer->set_flag_send( true );

	$mailer->setFromName( $from_name );
	$mailer->setFromEmail( $from_email );
	$mailer->setSubject( $subject );
	$mailer->setBody( $body );
	$mailer->prepare();

	foreach ( $users as $user ) 
	{
		$mailer->set_to_users( $user );
	}

	$ret = $mailer->send_users( true );

	echo "<h4>"._AM_SENDCOMP."</h4>\n";
	echo $mailer->getLogs('s');

	if ( !$ret )
	{
		echo '<h4 style="color: #ff0000">'.'Mail Failed'.'</h4>'."\n";
		echo $mailer->getErrors('s');
	}
// mail end

	if ($total > $end)
	{
		$this->_form->print_form_next( $end );
	}
}

//---------------------------------------------------------
// send_email
//---------------------------------------------------------
function send_email()
{
	$to_email   = $this->_post->get_post_text('to_email');
	if ( empty($to_email) )
	{
		echo '<h4 style="color: #ff0000">'._AM_WEBLINKS_NO_EMAIL.'</h4>'."\n";
		$this->print_form_email();
		return;
	}

	$from_name  = $this->_post->get_post_text('from_name');
	$from_email = $this->_post->get_post_text('from_email');
	$subject    = $this->_post->get_post_text('subject');
	$body       = $this->_post->get_post_text('body');

// mail start
	$mailer = new weblinks_mailer();

	$mailer->setFromName(  $from_name );
	$mailer->setFromEmail( $from_email );
	$mailer->setSubject( $subject );
	$mailer->setBody( $body );
	$mailer->useMail();
	$mailer->setToEmails( $to_email );

	$ret = $mailer->send( true );
	if ( $ret )
	{
		echo "<h4>"._AM_SENDCOMP."</h4>\n";
		echo $mailer->get_mailer_success();
	}
	else
	{
		echo '<h4 style="color: #ff0000">'.'Mail Failed'.'</h4>'."\n";
		echo $mailer->get_mailer_errors();
	}

}

//---------------------------------------------------------
// form
//---------------------------------------------------------
function print_form_user()
{
	if ( !isset($_POST['memberslist_id']) || !is_array($_POST['memberslist_id']) )
	{
		echo '<h4 style="color: #ff0000">'._AM_WEBLINKS_NO_EMAIL.'</h4>'."\n";
		return;
	}

	$this->_form->print_form( 'user' );
}

function print_form_link()
{
	if ( !isset($_POST['memberslist_id']) || !is_array($_POST['memberslist_id']) )
	{
		echo '<h4 style="color: #ff0000">'._AM_WEBLINKS_NO_EMAIL.'</h4>'."\n";
		return;
	}

	$this->_form->print_form( 'link' );
}

function print_form_email()
{
	$this->_form->print_form( 'email' );
}

function check_token()
{
	$ret = $this->_form->check_token();
	return $ret;
}

// --- class end ---
}


//=========================================================
// class admin_mail_users
//=========================================================
class admin_mail_form extends happy_linux_form_lib
{
	var $_link_handler;
	var $_system; 
	var $_post;

	var $_MAX_USER;
	var $_SITENAME;
	var $_ADMINMAIL;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_mail_form()
{
	$this->happy_linux_form_lib();

	$this->_link_handler =& weblinks_get_handler('link', WEBLINKS_DIRNAME);
	$this->_system       =& happy_linux_system::getInstance();
	$this->_post         =& happy_linux_post::getInstance();

	$this->_SITENAME  = $this->_system->get_sitename();
	$this->_ADMINMAIL = $this->_system->get_adminmail();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_mail_form();
	}
	return $instance;
}

//---------------------------------------------------------
// set parameter
//---------------------------------------------------------
function set_max_user( $val )
{
	$this->_MAX_USER = intval($val);
}

//---------------------------------------------------------
// form
//---------------------------------------------------------
function print_form( $mode )
{
	switch ($mode)
	{
		case  'user':
			$param = $this->_get_param_user();
			break;

		case  'link':
			$param = $this->_get_param_link();
			break;

		case  'email':
		default:
			$param = $this->_get_param_email();
			break;
	}

	$op           = $param['op'];
	$user_list    = $param['user_list'];
	$link_list    = $param['link_list'];
	$users_label  = $param['users_label'];
	$subject_cap  = $param['subject_caption'];
	$body_cap     = $param['body_caption'];
	$body         = $param['body'];

	$from_name  = htmlspecialchars( $this->_SITENAME, ENT_QUOTES );
	$from_email = $this->_ADMINMAIL;
	$subject    = $this->_get_subject();

	echo $this->build_form_begin( 'mail_users' );
	echo $this->build_token();
	echo $this->build_html_input_hidden('op',    $op);
	echo $this->build_html_input_hidden('start', 0);

	foreach ( $user_list as $uid )
	{
		echo $this->build_html_input_hidden('user_list[]', $uid);
	}

	foreach ( $link_list as $lid )
	{
		echo $this->build_html_input_hidden('link_list[]', $lid);
	}

	echo $this->build_form_table_begin();
	echo $this->build_form_table_title( _AM_SENDMTOUSERS );
	echo $this->build_form_table_line( _AM_SENDTOUSERS2, $users_label );
	echo $this->build_form_table_text( _AM_MAILFNAME, 'from_name',  $from_name );
	echo $this->build_form_table_text( _AM_MAILFMAIL, 'from_email', $from_email );
	echo $this->build_form_table_text(     $subject_cap, 'subject', $subject );
	echo $this->build_form_table_textarea( $body_cap,    'body',    $body );
	echo $this->build_form_table_submit( '', 'submit', _WEBLINKS_SENDMAIL );
	echo $this->build_form_table_end();
	echo $this->build_form_end();
}

function print_form_next( $start_next )
{
	$op         = $this->_post->get_post_text('op');
	$user_list  = $this->_post->get_post('user_list');
	$link_list  = $this->_post->get_post('link_list');
	$from_name  = $this->_post->get_post_text('from_name');
	$from_email = $this->_post->get_post_text('from_email');
	$subject    = $this->_post->get_post_text('subject');
	$body       = $this->_post->get_post_text('body');

	$submit     = sprintf( _WEBLINKS_SEND_NEXT, $this->_MAX_USER );

	echo "<br />\n";
	echo $this->build_form_begin( 'mail_users' );
	echo $this->build_token();
	echo $this->build_html_input_hidden('op',         $this->sanitize_text($op) );
	echo $this->build_html_input_hidden('start',      intval($start_next) );
	echo $this->build_html_input_hidden('from_name',  $this->sanitize_text($from_name) );
	echo $this->build_html_input_hidden('from_email', $this->sanitize_text($from_email) );
	echo $this->build_html_input_hidden('subject',    $this->sanitize_text($subject) ) ;
	echo $this->build_html_input_hidden('body',       $this->sanitize_textarea($body) );

	if ( is_array($user_list) && count($user_list) )
	{
		foreach ( $user_list as $uid )
		{
			echo $this->build_html_input_hidden('user_list[]', $uid);
		}
	}

	if ( is_array($link_list) && count($link_list) )
	{
		foreach ( $link_list as $lid )
		{
			echo $this->build_html_input_hidden('link_list[]', $lid);
		}
	}

	echo $this->build_form_table_begin();
	echo $this->build_form_table_title( _AM_SENDMTOUSERS );
	echo $this->build_form_table_submit( '', 'submit', $this->sanitize_text($submit) );
	echo $this->build_form_table_end();
	echo $this->build_form_end();

}

//---------------------------------------------------------
// private
//---------------------------------------------------------
function _get_param_user()
{
	$subject_caption  = _AM_MAILSUBJECT."<br /><br />\n";
	$subject_caption .= "<span style='font-size:x-small;font-weight:bold;'>"._AM_MAILTAGS."</span><br />\n";
	$subject_caption .= "<span style='font-size:x-small;font-weight:normal;'>"._AM_MAILTAGS2."</span>";

	$body_caption  = _AM_MAILBODY."<br /><br />\n";
	$body_caption .= "<span style='font-size:x-small;font-weight:bold;'>"._AM_MAILTAGS."</span><br />\n";
	$body_caption .= "<span style='font-size:x-small;font-weight:normal;'>"._AM_MAILTAGS1."<br />\n";
	$body_caption .= _AM_MAILTAGS2."<br />"._AM_MAILTAGS3."<br />"._AM_MAILTAGS4."</span>";

	$user_list   = array();
	$users_label = '';

	if ( isset($_POST['memberslist_id']) && is_array($_POST['memberslist_id']) )
	{
		$user_list =& $_POST['memberslist_id'];
	   	$user_count = count($user_list);
       	$display_names = '';
    	
    	for ( $i = 0; $i < $user_count; $i++ ) 
    	{
    		$uid   = intval( $user_list[$i] );
    		$uname = $this->_system->get_uname_by_uid( $uid );

        	$display_names .= "<a href='".XOOPS_URL."/userinfo.php?uid=". $uid ."' target='_blank'>". $uname ."</a>, ";
    	}
    
    	$users_label = substr($display_names, 0, -2);
	}

	$param = array(
		'op'              => 'send_user',
		'user_list'       => $user_list,
		'link_list'       => array(),
		'users_label'     => $users_label,
		'subject_caption' => $subject_caption,
		'body_caption'    => $body_caption,
		'body'            => $this->_get_body( '{X_UNAME}' ),
	);
	return $param;
}

function _get_param_link()
{
	$subject_caption  = _AM_MAILSUBJECT."<br /><br />\n";
	$subject_caption .= "<span style='font-size:x-small;font-weight:bold;'>"._AM_MAILTAGS."</span><br />\n";
	$subject_caption .= "<span style='font-size:x-small;font-weight:normal;'>"._WEBLINKS_MAIL_TAGS1."</span><br />\n";

	$body_caption  = _AM_MAILBODY."<br /><br />\n";
	$body_caption .= "<span style='font-size:x-small;font-weight:bold;'>"._AM_MAILTAGS."</span><br />\n";
	$body_caption .= "<span style='font-size:x-small;font-weight:normal;'>"._WEBLINKS_MAIL_TAGS1."<br />\n";
	$body_caption .= _WEBLINKS_MAIL_TAGS2."<br />\n";
	$body_caption .= _WEBLINKS_MAIL_TAGS3."<br />\n";

	$link_list   = array();
	$users_label = '';

	if ( isset($_POST['memberslist_id']) && is_array($_POST['memberslist_id']) )
	{
		$link_list  =& $_POST['memberslist_id'];
		$link_count =  count( $link_list );
		$display_names = '';

		for ( $i = 0; $i < $link_count; $i++ ) 
		{
			$lid = intval( $link_list[$i] );

			$obj =& $this->_link_handler->get($lid);
			$user_name_s = $obj->user_name('s');
			$user_mail_s = $obj->user_mail('s');

			if ( $user_name_s && $user_mail_s )
			{
				$name_d = "<a href='mailto:".$user_mail_s."'>" . $user_name_s . "</a>";
			}

			if ( empty($name_d) )
			{
				$name_d = '<span style="color:#ff0000;">---</span>';
			}

			$display_names .= $name_d .', ';
		}

		$users_label = substr($display_names, 0, -2);
	}

	$param = array(
		'op'              => 'send_link',
		'user_list'       => array(),
		'link_list'       => $link_list,
		'users_label'     => $users_label,
		'subject_caption' => $subject_caption,
		'body_caption'    => $body_caption,
		'body'            => $this->_get_body( '{W_NAME}' ),
	);
	return $param;
}

function _get_param_email()
{
	$subject_caption = _AM_MAILSUBJECT."<br /><br />\n";
	$body_caption    = _AM_MAILBODY."<br /><br />\n";

	$users_label = $this->build_html_input_text('to_email', '');

	$param = array(
		'op'              => 'send_email',
		'user_list'       => array(),
		'link_list'       => array(),
		'users_label'     => $users_label,
		'subject_caption' => $subject_caption,
		'body_caption'    => $body_caption,
		'body'            => $this->_get_body( 'xxx' ),
	);
	return $param;
}

function _get_subject()
{
	$text = sprintf(_WEBLINKS_SUBJECT_FROM, $this->_SITENAME );
	return $text;
}

function _get_body( $name='' )
{
	$SITE_URL = XOOPS_URL.'/';

	$hello     = sprintf( _WEBLINKS_HELLO, $name );
	$webmaster = _WEBLINKS_WEBMASTER;

	$text = <<<END_OF_TEXT
$hello

-----------
$this->_SITENAME ({$SITE_URL}) 
$webmaster
$this->_ADMINMAIL
-----------
END_OF_TEXT;

	return $text;
}

// --- class end ---
}

//=========================================================
// main
//=========================================================
$mail_users =& admin_mail_users::getInstance();

$op = $mail_users->get_post_op();

if ( $op == 'form_user' ) 
{
	xoops_cp_header();
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
	echo "<h4>"._WEBLINKS_ADMIN_SENDMAIL."</h4>\n";

	$mail_users->print_form_user();
}
elseif ( $op == 'send_user' ) 
{
	if ( !( $mail_users->check_token() ) )
	{
		redirect_header("mail_users.php", 5, "Token Error");
		exit();
	}

	xoops_cp_header();
	weblinks_admin_print_header();
	echo "<h4>"._WEBLINKS_ADMIN_SENDMAIL."</h4>\n";
	$mail_users->send_user();
}
elseif ( $op == 'form_link' ) 
{
	xoops_cp_header();
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
	echo "<h4>"._WEBLINKS_ADMIN_SENDMAIL."</h4>\n";

	$mail_users->print_form_link();
}
elseif ( $op == 'send_link' )
{
	if ( !( $mail_users->check_token() ) )
	{
		redirect_header("user_list.php", 5, "Token Error");
		exit();
	}

	xoops_cp_header();
	weblinks_admin_print_header();
	echo "<h4>"._WEBLINKS_ADMIN_SENDMAIL."</h4>\n";
	$mail_users->send_link();
}
elseif ( $op == 'send_email' )
{
	if ( !( $mail_users->check_token() ) )
	{
		xoops_cp_header();
		weblinks_admin_print_header();
		echo "<h4>"._WEBLINKS_ADMIN_SENDMAIL."</h4>\n";
		xoops_error( "Token Error" );
		$mail_users->print_form_email();
	}
	else
	{
		xoops_cp_header();
		weblinks_admin_print_header();
		echo "<h4>"._WEBLINKS_ADMIN_SENDMAIL."</h4>\n";
		$mail_users->send_email();
	}
}
else
{
	xoops_cp_header();
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
	echo "<h4>"._WEBLINKS_ADMIN_SENDMAIL."</h4>\n";
	$mail_users->print_form_email();
}

echo "<br /><hr /><br />\n";
echo "<a href='index.php'>"._WEBLINKS_ADMIN_GOTO_ADMIN_INDEX."</a></br />\n";

xoops_cp_footer();
exit();

?>