<?php
// $Id: whatsnew_install.php,v 1.2 2007/11/16 15:12:13 ohwada Exp $

//=========================================================
// What's New Module
// 2007-11-11 K.OHWADA
//=========================================================

if( ! class_exists('whatsnew_install') ) 
{

//=========================================================
// class whatsnew_install
//=========================================================
class whatsnew_install extends happy_linux_module_install
{
	var $_DIRNAME;

	var $_module_table;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function whatsnew_install( $dirname )
{
	$this->_DIRNAME = $dirname;

	$this->happy_linux_module_install();
	$this->set_config_define_class( whatsnew_config_define::getInstance( $dirname ) );
	$this->set_config_table_name( $dirname.'_config' );
	
	$this->_module_table = $this->prefix( $dirname.'_module' );
}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new whatsnew_install( $dirname );
	}
	return $instance;
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function check_install()
{
	if ( !$this->check_init_config() )
	{	return false;	}

	return true;
}

function install()
{
	$this->init_config();
	$this->set_msg( $this->get_init_config_msg() );

	return $this->return_flag_error();
}

function check_update()
{
	if ( !$this->_check_config_220() )
	{	return false;	}

	if ( !$this->_check_module_220() )
	{	return false;	}

	if ( !$this->check_update_config() )
	{	return false;	}

	return true;
}

function update()
{
	if ( !$this->_check_config_220() )
	{
		$this->clear_error();
		$this->_update_config_220();
		$this->truncate_table( $this->_config_table );
		$this->set_msg( $this->build_update_msg( $this->_config_table ) );
	}

	if ( !$this->_check_module_220() )
	{
		$this->clear_error();
		$this->_update_module_220();
		$this->truncate_table( $this->_module_table );
		$this->set_msg( $this->build_update_msg( $this->_module_table ) );
	}

	$this->update_config();
	$this->set_msg( $this->get_update_config_msg() );

	$this->clear_all_template();
	$this->set_msg( $this->build_tpl_msg() );

	return $this->return_flag_error();
}

//---------------------------------------------------------
// config table
//---------------------------------------------------------
function _check_config_220()
{
	return $this->exists_column( $this->_config_table, 'conf_valuetype' );
}

function _update_config_220()
{
$sql = "
  ALTER TABLE ". $this->_config_table ." ADD COLUMN (
  conf_valuetype varchar(255) NOT NULL default ''
)";

	return $this->query($sql);
}

//---------------------------------------------------------
// module table
//---------------------------------------------------------
function _check_module_220()
{
	return $this->exists_column( $this->_module_table, 'plugin' );
}

function _update_module_220()
{
$sql = "
  ALTER TABLE ". $this->_module_table ." ADD COLUMN (
  plugin varchar(255) default ''
)";

	return $this->query($sql);
}

//---------------------------------------------------------
// template
//---------------------------------------------------------
function clear_all_template()
{
	$dir_tpl = XOOPS_ROOT_PATH .'/modules/'. $this->_DIRNAME .'/templates';

	$this->clear_error();

	$this->clear_compiled_tpl_by_dir( $dir_tpl .'/parts' );
	$this->clear_compiled_tpl_by_dir( $dir_tpl .'/xml' );

	return $this->return_errors();
}

// --- class end ---
}

// === class end ===
}

?>