<?php
// $Id: block_latest.php,v 1.12 2007/10/13 07:02:36 ohwada Exp $

// 2007-10-10 K.OHWADA
// enclosure in link table
// BUG: display not-show feed

// 2007-08-01 K.OHWADA
// sanitize.php

// 2007-01-19 K.OHWADA
// b_rssc_shoten_text -> b_rssc_shorten_text
// clean up space

// 2006-12-02 K.OHWADA
// assign updated_unix and all

// 2006-10-26 K.OHWADA
// assign fid

// 2006-09-20 K.OHWADA
// show blog

// 2006-07-08 K.OHWADA
// corresponding to podcast
// add enclosure

// 2006-06-04 K.OHWADA
// assign site_title site_url

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================

include_once XOOPS_ROOT_PATH.'/modules/happy_linux/include/sanitize.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/include/multibyte.php';

// --- block function begin ---
if( !function_exists( 'b_rssc_show_latest' ) ) 
{

//---------------------------------------------------------
// show latest feeds
// $options
// [0] module directory name (rssc)
//---------------------------------------------------------
function b_rssc_show_latest( $options )
{
	global $xoopsDB;

	$DIRNAME = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0] ;

	$table_feed = $xoopsDB->prefix( $DIRNAME.'_feed' );
	$table_link = $xoopsDB->prefix( $DIRNAME.'_link' );

	$block = array();
	$block['lang_more'] = _BL_RSSC_MORE;
	$block['dirname']   = $DIRNAME;

// podcast
	$block['lang_podcast'] = _BL_RSSC_PODCAST;
	$block['unit_kb']      =  BL_RSSC_UNIT_KB;

// config data
	$conf_data = b_rssc_get_conf( $DIRNAME );
	if ( !$conf_data )
	{
		return $block;
	}

	$limit       = $conf_data['block_latest_perpage'];
	$num_content = $conf_data['block_latest_num_content'];
	$mode_date   = $conf_data['block_latest_mode_date'];
	$show_site   = $conf_data['block_latest_show_site'];

	$param = array(
		'max_title'   => $conf_data['block_latest_max_title'],
		'max_summary' => $conf_data['block_latest_max_summary'],
		'max_content' => $conf_data['block_latest_max_content'],
		'is_japanese' => happy_linux_is_japanese(),
	);

	$order  = b_rssc_get_order(  $conf_data['block_latest_order'], true );
	$future = b_rssc_get_future( $conf_data['basic_future_days'] );

	$sql  = 'SELECT f.*, l.enclosure as enclosure_mode FROM ';
	$sql .= $table_feed.' f, ';
	$sql .= $table_link.' l ';
	$sql .= ' WHERE f.act=1';
	$sql .= ' AND f.updated_unix <'.$future;
	$sql .= ' AND f.published_unix <'.$future;
	$sql .= ' AND f.lid=l.lid';
	$sql .= ' ORDER BY '.$order;

	$res = $xoopsDB->query($sql, $limit, 0);
	if ( !$res )
	{
		return $block;
	}

	$feeds = array();

	while ($row = $xoopsDB->fetchArray($res)) 
	{
		$feeds[] = b_rssc_make_feed( $row, $param );
	}

	list( $show_short, $show_middle, $show_long ) = b_rssc_show_date( $mode_date );

	$block['feeds']       = $feeds;
	$block['num_content'] = $num_content;
	$block['show_site']   = $show_site;
	$block['show_short']  = $show_short;
	$block['show_middle'] = $show_middle;
	$block['show_long']   = $show_long;

	return $block;
}

//---------------------------------------------------------
// show headline
// $options
// [0] module directory name (rssc)
//---------------------------------------------------------
function b_rssc_show_headline( $options )
{
	global $xoopsDB;

	$DIRNAME = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0] ;

	$table_link   = $xoopsDB->prefix( $DIRNAME.'_link' );
	$table_feed   = $xoopsDB->prefix( $DIRNAME.'_feed' );

	$block = array();
	$block['lang_more'] = _BL_RSSC_MORE;
	$block['dirname']   = $DIRNAME;

// podcast
	$block['lang_podcast'] = _BL_RSSC_PODCAST;
	$block['unit_kb']      =  BL_RSSC_UNIT_KB;

// config data
	$conf_data = b_rssc_get_conf( $DIRNAME );
	if ( !$conf_data )
	{
		return $block;
	}

	$link_limit  = $conf_data['block_headline_links_perpage'];
	$limit       = $conf_data['block_headline_feeds_perlink'];
	$num_content = $conf_data['block_headline_num_content'];
	$mode_date   = $conf_data['block_headline_mode_date'];

	$param = array(
		'max_title'   => $conf_data['block_headline_max_title'],
		'max_summary' => $conf_data['block_headline_max_summary'],
		'max_content' => $conf_data['block_headline_max_content'],
		'is_japanese' => happy_linux_is_japanese(),
	);

	$order  = b_rssc_get_order(  $conf_data['block_headline_order'] );
	$future = b_rssc_get_future( $conf_data['basic_future_days'] );

// link data
	$sql1 = 'SELECT * FROM '.$table_link.' WHERE headline > 0 ORDER BY headline ASC';

	$res1 = $xoopsDB->query($sql1, $link_limit, 0);
	if ( !$res1 )
	{
		return  $block;
	}

	$links = array();

	while ($row1 = $xoopsDB->fetchArray($res1)) 
	{
		$feeds = array();

		$lid       = intval( $row1['lid'] );

		$link = array();
		$link['lid']       = $lid;
		$link['enclosure'] = intval( $row1['enclosure'] );
		$link['url']       = happy_linux_sanitize_url(  $row1['url'] );
		$link['title']     = happy_linux_sanitize_text( $row1['title'] );

// feed data
// BUG: display not-show feed
		$sql2  = 'SELECT * FROM '.$table_feed;
		$sql2 .= ' WHERE lid='.intval($lid);
		$sql2 .= ' AND updated_unix <'.  $future;
		$sql2 .= ' AND published_unix <'.$future;
		$sql2 .= ' AND act=1';
		$sql2 .= ' ORDER BY '.$order;

		$res2 = $xoopsDB->query($sql2, $limit, 0);

		while ($row2 = $xoopsDB->fetchArray($res2)) 
		{
			$feeds[] = b_rssc_make_feed( $row2, $param );
		}

		$link['feeds'] = $feeds;
		$links[] = $link;
	}

	list( $show_short, $show_middle, $show_long ) = b_rssc_show_date( $mode_date );

	$block['links']       = $links;
	$block['num_content'] = $num_content;
	$block['show_short']  = $show_short;
	$block['show_middle'] = $show_middle;
	$block['show_long']   = $show_long;

	return $block;
}

//---------------------------------------------------------
// show blog
// $options
// [0] module directory name (rssc)
//---------------------------------------------------------
function b_rssc_show_blog( $options )
{
	global $xoopsDB;

	$DIRNAME = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0] ;

	$table_link = $xoopsDB->prefix( $DIRNAME.'_link' );
	$table_feed = $xoopsDB->prefix( $DIRNAME.'_feed' );

	$block = array();
	$block['dirname'] = $DIRNAME;

// podcast
	$block['lang_podcast'] = _BL_RSSC_PODCAST;
	$block['unit_kb']      =  BL_RSSC_UNIT_KB;

// config data
	$conf_data = b_rssc_get_conf( $DIRNAME );
	if ( !$conf_data )
	{
		return $block;
	}

	$lid         = $conf_data['block_blog_lid'];
	$limit       = $conf_data['block_blog_perpage'];
	$num_content = $conf_data['block_blog_num_content'];
	$mode_date   = $conf_data['block_blog_mode_date'];

	$param = array(
		'max_title'   => $conf_data['block_blog_max_title'],
		'max_summary' => $conf_data['block_blog_max_summary'],
		'max_content' => $conf_data['block_blog_max_content'],
		'is_japanese' => happy_linux_is_japanese(),
	);

	$future = b_rssc_get_future( $conf_data['basic_future_days'] );
	$order  = b_rssc_get_order(  $conf_data['block_blog_order'] );

// no link id
	if ($lid == 0)
	{
		$block['feed_show']  = false;
		$block['lang_error'] = _BL_RSSC_NO_LINK_ID;
		return $block;
	}

	$link = array();

// link data
	$sql1 = 'SELECT * FROM '.$table_link.' WHERE lid='.$lid;
	$res1 = $xoopsDB->query($sql1);
	if ( !$res1 )
	{
		return  $block;
	}

	$row1 = $xoopsDB->fetchArray($res1);

	$link['enclosure'] = intval( $row1['enclosure'] );

// feed data
// BUG: display not-show feed
	$sql2  = 'SELECT * FROM '.$table_feed;
	$sql2 .= ' WHERE lid='.intval($lid);
	$sql2 .= ' AND updated_unix <'.  $future;
	$sql2 .= ' AND published_unix <'.$future;
	$sql2 .= ' AND act=1';
	$sql2 .= ' ORDER BY '.$order;

	$res2  = $xoopsDB->query($sql2, $limit, 0);
	$feeds = array();

	while ($row2 = $xoopsDB->fetchArray($res2)) 
	{
		$feeds[] = b_rssc_make_feed( $row2, $param );
	}

	$site_title = '---';
	$site_link  = '';

	if ( count($feeds) )
	{
		if ( isset($feeds[0]['site_title']) )
		{
			$site_title = $feeds[0]['site_title'];
		}
		if ( isset($feeds[0]['site_link']) )
		{
			$site_link = $feeds[0]['site_link'];
		}
	}
	else
	{
		$block['feed_show']  = false;
		$block['lang_error'] = _BL_RSSC_NO_FEED;
		return $block;
	}

	list( $show_short, $show_middle, $show_long ) = b_rssc_show_date( $mode_date );

	$block['feed_show']   = true;
	$block['site_title']  = $site_title;
	$block['site_link']   = $site_link;
	$block['link']        = $link;
	$block['feeds']       = $feeds;
	$block['num_content'] = $num_content;
	$block['show_short']  = $show_short;
	$block['show_middle'] = $show_middle;
	$block['show_long']   = $show_long;

	return $block;
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function b_rssc_get_conf( $DIRNAME )
{
	global $xoopsDB;
	$table_config = $xoopsDB->prefix( $DIRNAME.'_config' );

// config data
	$conf = array();

	$sql = 'SELECT * FROM '.$table_config.' ORDER BY conf_id ASC';

	$res = $xoopsDB->query($sql, 0, 0);
	if ( !$res )
	{
		return false;
	}

	while ($row = $xoopsDB->fetchArray($res)) 
	{
		$conf[ $row['conf_name'] ] = $row['conf_value'];
	}

	return $conf;
}

function b_rssc_get_future($value)
{
	$time = time() + 86400 * intval($value);	// days
	return $time;
}

function b_rssc_get_order( $value, $flag=false )
{
	$prefix = '';
	if ( $flag )
	{
		$prefix = 'f.';
	}

	switch ( $value )
	{
		case 1:
			$order = $prefix.'published_unix DESC, '.$prefix.'fid DESC';
			break;

		case 0:
		default:
			$order = $prefix.'updated_unix DESC, '.$prefix.'fid DESC';
			break;
	}

	return $order;
}

function b_rssc_make_feed( &$row, &$param )
{
	$max_title   = $param['max_title'];
	$max_summary = $param['max_summary'];
	$max_content = $param['max_content'];
	$is_japanese = isset( $param['is_japanese'] ) ? $param['is_japanese'] : false;

	$site_title     = $row['site_title'];
	$title          = $row['title'];
	$content        = $row['content'];
	$published_unix = intval( $row['published_unix'] );
	$updated_unix   = intval( $row['updated_unix'] );
	$enclosure_mode = isset( $row['enclosure_mode'] ) ? intval( $row['enclosure_mode'] ) : 0;

	$site_title = happy_linux_mb_build_summary( $site_title, $max_title, '...', $is_japanese );
	$site_title = b_rssc_substitute_title($site_title);

	$title = happy_linux_mb_build_summary( $title, $max_title, '...', $is_japanese );
	$title = b_rssc_substitute_title($title);

	$summary = happy_linux_mb_build_summary( $content, $max_summary, '...', $is_japanese );

// unlimit , when $max_content = -1
	if ( $max_content == 0 )
	{
		$content = '';
	}
	elseif ( $max_content > 0 )
	{
		$content = happy_linux_mb_build_summary($content, $max_content);
	}

	$feed = array(
		'fid'  => intval( $row['fid'] ),
		'lid'  => intval( $row['lid'] ),
		'uid'  => intval( $row['uid'] ),
		'mid'  => intval( $row['mid'] ),
		'p1'   => intval( $row['p1'] ),
		'p2'   => intval( $row['p2'] ),
		'p3'   => intval( $row['p3'] ),

		'site_link'    => happy_linux_sanitize_url(  $row['site_link'] ),
		'link'         => happy_linux_sanitize_url(  $row['link'] ),
		'author_uri'   => happy_linux_sanitize_text( $row['author_uri'] ),
		'site_title'   => happy_linux_sanitize_text( $site_title ),
		'title'        => happy_linux_sanitize_text( $title ),
		'summary'      => happy_linux_sanitize_text( $summary ),
		'entry_id'     => happy_linux_sanitize_text( $row['entry_id'] ),
		'guid'         => happy_linux_sanitize_text( $row['guid'] ),
		'category'     => happy_linux_sanitize_text( $row['category'] ),
		'author_name'  => happy_linux_sanitize_text( $row['author_name'] ),
		'author_email' => happy_linux_sanitize_text( $row['author_email'] ),
		'type_cont'    => happy_linux_sanitize_text( $row['type_cont'] ),
		'content'      => $content,

		'published_unix' => $published_unix,
		'updated_unix'   => $updated_unix,
		'updated_long'   => formatTimestamp( $updated_unix, 'l' ),
		'updated_short'  => formatTimestamp( $updated_unix, 's' ),
		'updated_mysql'  => formatTimestamp( $updated_unix, 'mysql' ),

		'enclosure_url'       => happy_linux_sanitize_url(  $row['enclosure_url'] ),
		'enclosure_type'      => happy_linux_sanitize_text( $row['enclosure_type'] ),
		'enclosure_length'    => intval( $row['enclosure_length'] ),
		'enclosure_length_kb' => intval( $row['enclosure_length']/1024 ),
		'enclosure_mode'      => $enclosure_mode,
	);

	return $feed;
}

function b_rssc_substitute_title($str)
{
	if ( strlen($str) > 0 )
	{
		return $str;
	}
	return "---";
}

function b_rssc_show_date( $mode )
{
	$show_short  = false;
	$show_middle = false;
	$show_long   = false;

	switch ( $mode )
	{
		case 0:
			break;

		case 2:
			$show_middle = true;
			break;

		case 3:
			$show_long = true;
			break;

		case 1:
		default:
			$show_short = true;
			break;
	}

	return array( $show_short, $show_middle, $show_long );
}

// --- block function begin end ---
}

?>