<?php
// $Id: rssc_view_param.php,v 1.11 2008/01/31 16:25:36 ohwada Exp $

// 2008-01-20 K.OHWADA
// _execute_plugin()

// 2007-10-10 K.OHWADA
// set_is_japanese()
// enclosure in link table

// 2007-08-01 K.OHWADA
// get_module_header()

// 2007-06-01 K.OHWADA
// happy_linux_rss_viewer
// add create() view_format_sanitize_feed_rows()
// use get_cache_ltype_by_item()

// 2006-09-01 K.OHWADA
// add view_format_sanitize_single_feed_obj() : remove view_format_sanitize_feeds()
// add get_get_keywords()
// highlight_keyword

// 2006-07-22 K.OHWADA
// page title

// 2006-07-10 K.OHWADA
// use happy_linux_error happy_linux_post etc

// 2006-06-04 K.OHWADA
// add view_format_sanitize() etc

//=========================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_view_param') ) 
{

//=========================================================
// class rssc_view_param
//=========================================================
class rssc_view_param extends happy_linux_rss_viewer
{
	var $_DIRNAME;

// handler
	var $_config_handler;
	var $_link_handler;
	var $_feed_handler;
	var $_plugin;
	var $_system;

	var $_conf;

// input parameter
	var $_feed_order = RSSC_C_ORDER_TEXT_UPDATED;
	var $_feed_start =  0;
	var $_feed_limit = 10;
	var $_flag_sanitize  = false;
	var $_flag_ltype     = false;
	var $_flag_enclosure = false;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_view_param( $dirname )
{
	$this->_DIRNAME = $dirname;

	$this->happy_linux_rss_viewer();

// handler
	$this->_config_handler =& rssc_get_handler('config_basic', $dirname);
	$this->_link_handler   =& rssc_get_handler('link_basic',   $dirname);
	$this->_feed_handler   =& rssc_get_handler('feed_basic',   $dirname);
	$this->_plugin         =& rssc_plugin::getInstance( $dirname );
	$this->_system         =& happy_linux_system::getInstance();

}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_view_param( $dirname );
	}
	return $instance;
}

function _init_view_param()
{
	$this->_conf =& $this->_config_handler->get_conf();

	$this->set_mode_content_script(     $this->_conf['html_script'] );
	$this->set_mode_content_style(      $this->_conf['html_style'] );
	$this->set_mode_content_link(       $this->_conf['html_link'] );
	$this->set_mode_content_comment(    $this->_conf['html_comment'] );
	$this->set_mode_content_cdata(      $this->_conf['html_cdata'] );
	$this->set_mode_content_onmouse(    $this->_conf['html_attr_onmouse'] );
	$this->set_mode_content_attr_style( $this->_conf['html_attr_style'] );
	$this->set_mode_content_javascript( $this->_conf['html_javascript'] );
	$this->set_flag_content_tags(       $this->_conf['html_flag_other_tags'] );
	$this->set_content_tags(            $this->_conf['html_other_tags'] );
	$this->set_is_japanese(             $this->_system->is_japanese() );

	$this->_plugin->init_once();

}

//---------------------------------------------------------
// view sanitize
//---------------------------------------------------------
function &view_format_sanitize_feed_objs( &$feed_objs, $flag_sanitize=true )
{
	$feeds = array();
	if ( is_array($feed_objs) && ( count($feed_objs) > 0 ) )
	{
		foreach ($feed_objs as $obj)
		{
			$feeds[] =& $this->view_format_sanitize_single_feed_obj( $obj, $flag_sanitize );
		}
	}
	return $feeds;
}

function &view_format_sanitize_single_feed_obj( &$feed_obj, $flag_sanitize=true )
{
	$feed = array();
	if ( is_object($feed_obj) )
	{
		$feed =& $this->view_format_sanitize_single_feed( $feed_obj->getVarAll(), $flag_sanitize );
	}
	return $feed;
}

function &view_format_sanitize_feed_rows( &$feed_rows, $flag_sanitize=true )
{
	$feeds = array();
	if ( is_array($feed_rows) && ( count($feed_rows) > 0 ) )
	{
		foreach ($feed_rows as $row)
		{
			$feeds[] = $this->view_format_sanitize_single_feed_row( $row, $flag_sanitize );
		}
	}
	return $feeds;
}

function &view_format_sanitize_single_feed_row( &$feed_row, $flag_sanitize=true )
{
	$feed = array();
	if ( is_array($feed_row) )
	{
		$feed = $this->view_format_sanitize_single_feed( $feed_row, $flag_sanitize );
	}
	return $feed;
}

function &view_format_sanitize_single_feed( &$orig, $flag_sanitize=true )
{
	$item = $this->_execute_plugin( $orig );

	$feed = $this->view_format_sanitize_single_item( $item, $flag_sanitize );

	if ( isset($item['lid']) )
	{
	 	$lid = $item['lid']; 
		if ( $this->_flag_ltype )
		{
			$feed['ltype'] = $this->_link_handler->get_cache_ltype_by_lid( $lid );
		}
		if ( $this->_flag_enclosure )
		{
			$feed['enclosure_mode'] = $this->_link_handler->get_cache_enclosure_by_lid( $lid );
		}
	}
	return $feed;
}

function _execute_plugin( $item )
{
	$temp = $item;

	if ( isset($item['lid']) )
	{
	 	$plugin_line = $this->_link_handler->get_cache_post_plugin_by_lid( $item['lid'] );

		$ret1 = $this->_plugin->execute_single( $temp, $plugin_line );
		if ( $ret1 )
		{
			$res1 = $this->_plugin->get_item();
			if ( is_array($res1) && count($res1) )
			{
				$temp = $res1;
			}
		}
	}

	$ret2 = $this->_plugin->execute_single( $temp, $this->_conf['post_plugin'] );
	if ( $ret2 )
	{
		$res2 = $this->_plugin->get_item();
		if ( is_array($res2) && count($res2) )
		{
			$temp = $res2;
		}
	}

	return $temp;
}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function setFeedOrder($value)
{
	switch ( intval($value) )
	{
		case RSSC_C_ORDER_INT_PUBLISHED:
			$order = RSSC_C_ORDER_TEXT_PUBLISHED;
			break;

		case RSSC_C_ORDER_INT_UPDATED:
		default:
			$order = RSSC_C_ORDER_TEXT_UPDATED;
			break;
	}

	$this->_feed_order = $order;
}

function setFeedStart($value)
{
	$this->_feed_start = intval($value);
}

function setFeedLimit($value)
{
	$this->_feed_limit = intval($value);
}

function setFlagSanitize($value)
{
	$this->_flag_sanitize = (bool)$value;
}

function set_flag_ltype($value)
{
	$this->_flag_ltype = (bool)$value;
}

function set_flag_enclosure($value)
{
	$this->_flag_enclosure = (bool)$value;
}

function setFutureDays($value)
{
	$this->_feed_handler->set_future($value);
}

//---------------------------------------------------------
// template common
//---------------------------------------------------------
function &get_tpl_common_param()
{
	$arr = array(
		'lang_edit'             => _EDIT,
		'lang_home'             => _HAPPY_LINUX_HOME,
		'lang_main'             => _HAPPY_LINUX_MAIN,
		'lang_goto_admin'       => _HAPPY_LINUX_GOTO_ADMIN,
		'lang_no_record'        => _HAPPY_LINUX_NO_RECORD,
		'lang_headline'         => _RSSC_HEADLINE,
		'lang_latest'           => _RSSC_LATEST_FEEDS,
		'lang_lastupdate'       => _RSSC_LASTUPDATE,
		'lang_no_feed'          => _RSSC_NO_FEED,
		'lang_single_link'      => _RSSC_SINGLE_LINK,
		'lang_single_link_utf8' => _RSSC_SINGLE_LINK_UTF8,
		'lang_podcast'          => _RSSC_PODCAST,
		'unit_kb'               =>  RSSC_UNIT_KB,
		'dirname'               => $this->_DIRNAME,
		'module_name'           => $this->get_module_name('s'),
		'is_module_admin'       => $this->_system->is_module_admin(),
		'xoops_module_header'   => $this->_get_module_header(),
	);
	return $arr;
}

function get_module_name( $format='s' )
{
	return $this->_system->get_module_name( $format );
}

// some block use xoops_module_header
function _get_module_header()
{
	$url   = XOOPS_URL . '/modules/' . $this->_DIRNAME . '/rssc.css';
	$text  = '<link href="'. $url . '" rel="stylesheet" type="text/css" media="all" />'."\n";
	$text .= $this->_system->get_template_vars('xoops_module_header')."\n";
	return $text;
}

// --- class end ---
}

// === class end ===
}

?>