<?php
// $Id: loadpage.php,v 1.1.1.1 2009/03/07 19:35:02 ohwada Exp $

//===================================================================
// simple url Netcommons
// 2009-03-08 K.OHWADA
//===================================================================

//===================================================================
// convert from simplified url
//
// page_xx.html
// -> index.php?action=pages_view_main&page_id=xx
//
// bbs_xx_xx.html#_xx
// -> index.php?action=pages_view_main&active_action=bbs_view_main_post&post_id=xx&block_id=xx#_xx
//
// journal_xx_xx.html#_xx
// -> index.php?action=pages_view_main&active_action=journal_view_main_detail&post_id=xx&block_id=xx#_xx
//
// cabinet_xx_xx_xx_xx_xx.html
// -> index.php?action=cabinet_action_main_download&block_id=xx&room_id=xx&cabinet_id=xx&file_id=xx&upload_id=xx
//===================================================================

// param
$url = null ;

$request = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : null ;
$host    = isset($_SERVER['HTTP_HOST'])   ? $_SERVER['HTTP_HOST']   : null ;

$urlpath  = parse_url( $host.$request );
$fragment = isset($urlpath['fragment'])   ? $urlpath['fragment']   : null ;

if ( preg_match('/page_(\d+)\.html/', $request, $matchs ) ) {
	$page_id = $matchs[1] ;
	$_GET['action']  = 'pages_view_main';
	$_GET['page_id'] = $page_id;
//	$url = 'index.php?action=pages_view_main&page_id='.$page_id;

}elseif ( preg_match('/bbs_(\d+)_(\d+)\.html/', $request, $matchs ) ) {
	$post_id  = $matchs[1] ;
	$block_id = $matchs[2] ;
	$_GET['action']        = 'pages_view_main';
	$_GET['active_action'] = 'bbs_view_main_post';
	$_GET['post_id']       = $post_id;
	$_GET['block_id']      = $block_id;
//	$url= 'index.php?action=pages_view_main&active_action=bbs_view_main_post&post_id='.$post_id.'&block_id='.$block_id.'#'.$fragment;

} elseif ( preg_match('/journal_(\d+)_(\d+)\.html/', $request, $matchs ) ) {
	$post_id  = $matchs[1] ;
	$block_id = $matchs[2] ;
	$_GET['action']        = 'pages_view_main';
	$_GET['active_action'] = 'journal_view_main_detail';
	$_GET['post_id']       = $post_id;
	$_GET['block_id']      = $block_id;
//	$url= 'index.php?action=pages_view_main&active_action=journal_view_main_detail&post_id='.$post_id.'&block_id='.$block_id.'#'.$fragment;

} elseif ( preg_match('/cabinet_(\d+)_(\d+)_(\d+)_(\d+)_(\d+)\.html/', $request, $matchs ) ) {
	$block_id   = $matchs[1] ;
	$room_id    = $matchs[2] ;
	$cabinet_id = $matchs[3] ;
	$file_id    = $matchs[4] ;
	$upload_id  = $matchs[5] ;
	$url = 'index.php?action=cabinet_action_main_download&block_id='.$block_id.'&room_id='.$room_id.'&cabinet_id='.$cabinet_id.'&file_id='.$file_id.'&upload_id='.$upload_id;
}

// redirect
if ( $url ) {
	header( 'Location: '.$url );
}

include 'index.php';

?>