<?php
// $Id: Action.class.php,v 1.1.1.1 2009/03/31 10:21:38 ohwada Exp $

//=========================================================
// Googlesearch Netcommons
// 2009-03-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Googlesearch登録コンポーネント
 *
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Googlesearch_Components_Action
{
	/**
	 * @var DBオブジェクトを保持
	 *
	 * @access	private
	 */
	var $_db = null;

	/**
	 * @var Requestオブジェクトを保持
	 *
	 * @access	private
	 */
	var $_request = null;
	
	/**
	 * コンストラクター
	 *
	 * @access	public
	 */
	function Googlesearch_Components_Action()
	{
		$container =& DIContainerFactory::getContainer();
		$this->_db =& $container->getComponent("DbObject");
		$this->_request =& $container->getComponent("Request");
	}
	/**
	 * Googlesearchのpartsレコードを削除する
	 *
     * @return boolean	true or false
	 * @access	public
	 */
	function deleteGooglesearch() 
	{
		$params = array(
			"parts_id" => $this->_request->getParameter("parts_id")
		);
    	if (!$this->_db->deleteExecute("googlesearch_parts", $params)) {
    		return false;
    	}
		return true;
	}

	/**
	 * Googlesearchのblockレコードを登録する
	 *
     * @return boolean	true or false
	 * @access	public
	 */
	function setBlock() 
	{
		$block_id = $this->_request->getParameter("block_id");

// blockレコード読み出し
		$params = array($block_id);
		$sql = "SELECT block_id ".
				"FROM {googlesearch_block} ".
				"WHERE block_id = ?";
		$block_ids = $this->_db->execute($sql, $params);
		if ($block_ids === false) {
			$this->_db->addError();
			return false;
		}

// blockレコード追加・更新
		$params = array(
			"block_id" => $block_id,
			"parts_id" => $this->_request->getParameter("parts_id")
		);
		if (!empty($block_ids)) {
			$result = $this->_db->updateExecute("googlesearch_block", $params, "block_id", true);
		} else {
			$result = $this->_db->insertExecute("googlesearch_block", $params, true);
		}
        if (!$result) {
			return false;
		}

		return true;
	}

	/**
	 * Googlesearchのpartsレコードを登録する
	 *
     * @return boolean	true or false
	 * @access	public
	 */
	function setParts()
	{
		$container =& DIContainerFactory::getContainer();
        $session =& $container->getComponent("Session");
        $site_id = $session->getParameter("_site_id");
        $user_id = $session->getParameter("_user_id");
        $user_name = $session->getParameter("_handle");
        $time = timezone_date();
        
		$params = array(
			"parts_name"       => $this->_request->getParameter("parts_name"),
			"site_use"         => $this->_request->getParameter("site_use"),
			"site_label"       => $this->_request->getParameter("site_label"),
			"site_restriction" => $this->_request->getParameter("site_restriction"),
			"site_expand"      => $this->_request->getParameter("site_expand"),
			"web_use"          => $this->_request->getParameter("web_use"),
			"search_draw"      => $this->_request->getParameter("search_draw"),
			"search_execute"   => $this->_request->getParameter("search_execute"),
		);
		$params_footer = array(
			"insert_time" =>$time,
			"insert_site_id" => $site_id,
			"insert_user_id" => $user_id,
			"insert_user_name" => $user_name
		);
		$params_update_footer = array(
			"update_time" =>$time,
			"update_site_id" => $site_id,
			"update_user_id" => $user_id,
			"update_user_name" => $user_name
		);

// partsレコード追加・更新
		$parts_id = $this->_request->getParameter("parts_id");
		if (empty($parts_id)) {
			$params = array_merge($params, $params_footer, $params_update_footer);
			$result = $this->_db->insertExecute("googlesearch_parts",$params, false, "parts_id");
		} else {
			$params = array_merge($params, $params_update_footer);
			$params['parts_id'] = $parts_id;
			$result = $this->_db->updateExecute("googlesearch_parts", $params, "parts_id", false);
		}
		if (!$result) {
			return false;
		}

		if (!empty($parts_id)) {
        	return true;
        }

// blockレコード登録
		$parts_id = $result;
		$this->_request->setParameter("parts_id", $parts_id);
        $this->setBlock();

		return "create";
	}

}
?>