/* $Id: googlemap_location.js,v 1.2 2009/01/05 09:00:38 ohwada Exp $ */

/* ========================================================
 * Googlemap Netcommons
 * 2009/01/01 K.OHWADA
 * http://code.google.com/apis/maps/index.html
 * ========================================================
 */

var googlemap_init_flag = false;

/* georss */
var googlemap_map_obj = null;
var googlemap_client_geocoder  = null;
var googlemap_location_marker  = null;
var googlemap_draggable_marker = null;
var googlemap_bounds      = null;
var googlemap_bounds_zoom = null;
var googlemap_drag_icon   = null;
var googlemap_base_icon   = null;
var googlemap_small_icon  = null;

/* japanese inverse geocoder */
var googlemap_address_jp;
var googlemap_pref_jp;
var googlemap_city_jp;
var googlemap_town_jp;
var googlemap_number_jp;

/* 37.0 -95.0 : Chetopa Kansas: center point of USA */
var googlemap_default_latitude  =  37.0;
var googlemap_default_longitude = -95.0;
var googlemap_default_zoom = 4;
var googlemap_location_marker_html = "Chetopa Kansas, USA";

var googlemap_geo_url = "";

var googlemap_zoom_max = 17;
var googlemap_zoom_geocode_default = 12;
var googlemap_zoom_accuracy = 12;
var googlemap_zoom_accuracy_tokyo_univ = 12;

var googlemap_xoops_langcode = "en";
var googlemap_lang_latitude  = "Latitude";
var googlemap_lang_longitude = "Longitude";
var googlemap_lang_zoom      = "Zoom Level";
var googlemap_lang_not_compatible = "Your browser cannot use GoogleMaps";
var googlemap_lang_no_match_place = "There are no place to match the address";
var googlemap_xoops_url    = "";
var googlemap_dirname      = "";
var googlemap_module_url   = "";
var googlemap_marker_url   = "";
var googlemap_opener_mode  = "parent";

var googlemap_map_control  = 'large';
var googlemap_map_type     = '';
var googlemap_geocode_kind = '';
var googlemap_type_control = 'default';

var googlemap_use_scale_control         = false;
var googlemap_use_overview_map_control  = true;
var googlemap_use_location_marker       = false;
var googlemap_use_location_marker_click = true;
var googlemap_use_draggable_marker = true;
var googlemap_use_search_marker    = true;
var googlemap_set_current_location = true;
var googlemap_use_costum_icon = false;

var googlemap_use_nishioka_inverse    = false;
var googlemap_use_set_parent_location = false;
var googlemap_use_set_parent_address  = false;
var googlemap_use_get_parent_location = false;

var googlemap_id_latitude  = "googlemap_latitude";
var googlemap_id_longitude = "googlemap_longitude";
var googlemap_id_zoom      = "googlemap_zoom";

var googlemap_info = new Array();
var googlemap_icon = new Array();

/* debug */
var googlemap_debug_geocoder_tokyo_univ = false;
var googlemap_debug_inverse_nishioka    = false;

/* --------------------------------------------------------
 * public functon
 * --------------------------------------------------------
 */
function googlemap_load_marks() 
{
	if ( GBrowserIsCompatible() ) {
		googlemap_show_marks();
	} else {
		alert( googlemap_lang_not_compatible );
	}
}
function googlemap_load_get_location() 
{
	if ( GBrowserIsCompatible() ) {
		googlemap_show_get_location();
	} else {
		alert( googlemap_lang_not_compatible );
	}
}
function googlemap_load_get_location_marks() 
{
	if ( GBrowserIsCompatible() ) {
		googlemap_show_get_location_marks();
	} else {
		alert( googlemap_lang_not_compatible );
	}
}
function googlemap_load_search() 
{
	if ( GBrowserIsCompatible() ) {
		googlemap_show_search();
	} else {
		alert( googlemap_lang_not_compatible );
	}
}
function googlemap_load_georss() 
{
	if ( GBrowserIsCompatible() ) {
		googlemap_show_georss();
	} else {
		alert( googlemap_lang_not_compatible );
	}
}
function googlemap_searchAddress( addr )
{
	if ( googlemap_geocode_kind == 'latlng' ) {
		googlemap_geocoder_LatLng( addr )
	} else if ( googlemap_geocode_kind == 'tokyo_univ' ) {
		googlemap_geocoder_tokyoUniv( addr );
	} else {
		googlemap_geocoder_Locations( addr );
	}
}
function googlemap_setCenter( lat, lng, zoom )
{
	googlemap_map_obj.setCenter( new GLatLng( parseFloat( lat ) , parseFloat( lng ) ) );
	googlemap_map_obj.setZoom( Math.floor( zoom ) );
}

function googlemap_on_load_marks() 
{
	if ( googlemap_init_flag == false ) {
		googlemap_load_marks();
		googlemap_init_flag = true;
	}
}

function googlemap_on_get_location_marks() 
{
	if ( googlemap_init_flag == false ) {
		googlemap_load_get_location_marks();
		googlemap_init_flag = true;
	}
}

function googlemap_init_flag_true() 
{
	googlemap_init_flag = true;
}

/* --------------------------------------------------------
 * private functon
 * --------------------------------------------------------
 */

function googlemap_show_marks() 
{
	googlemap_initMap();
	googlemap_setCenter( googlemap_default_latitude, googlemap_default_longitude, googlemap_default_zoom );

/* MUST be setMapType() after setCenter() */
	googlemap_setMapType();
	googlemap_addOverviewMapControl();

	if ( googlemap_use_location_marker ) {
		googlemap_location_marker = new GMarker( googlemap_map_obj.getCenter() );
		googlemap_map_obj.addOverlay( googlemap_location_marker );

		if ( googlemap_use_location_marker_click ) {
			googlemap_clickMarker();
		}
	}

	for ( i=0 ; i<googlemap_info.length ; i++ ) {
		googlemap_map_obj.addOverlay( googlemap_createMarker_info( googlemap_info[i] ) );
	}
}
function googlemap_show_get_location() 
{
	googlemap_initMap();
	googlemap_initIcon();

	now_lat  = googlemap_default_latitude;
	now_lng  = googlemap_default_longitude;
	now_zoom = googlemap_default_zoom;
	now_addr = null;

	googlemap_client_geocoder = new GClientGeocoder();
	googlemap_moveendMap();

	parent_flag  = false;
	parent_param = googlemap_getParentLatitude();
	if ( parent_param ) {
		parent_flag = parent_param[0];
	}

/* if parent param is set */
	if( parent_flag ) {
		now_lat  = parent_param[1];
		now_lng  = parent_param[2];
		now_zoom = parent_param[3];
	}

	googlemap_setCenter( now_lat, now_lng, now_zoom );

	addr = googlemap_getParentAddress();
	if ( addr ) {
		document.getElementById("googlemap_search").value = addr.googlemap_htmlspecialchars();

/* if parent param is NOT set */
		if( parent_flag == false ) {
			googlemap_searchAddress(addr);
		}
	}

}
function googlemap_show_get_location_marks() 
{
	googlemap_initMap();
	googlemap_initIcon();

	now_lat  = googlemap_default_latitude;
	now_lng  = googlemap_default_longitude;
	now_zoom = googlemap_default_zoom;
	now_addr = null;

	googlemap_client_geocoder = new GClientGeocoder();
	googlemap_moveendMap();

	if ( googlemap_use_get_parent_location) {
		parent_flag  = false;
		parent_param = googlemap_getParentLatitude();
		if ( parent_param ) {
			parent_flag = parent_param[0];
		}

/* if parent param is set */
		if( parent_flag ) {
			now_lat  = parent_param[1];
			now_lng  = parent_param[2];
			now_zoom = parent_param[3];
		}
	}

	googlemap_setCenter( now_lat, now_lng, now_zoom );

	addr = googlemap_getParentAddress();
	if ( addr ) {
		document.getElementById("googlemap_search").value = addr.googlemap_htmlspecialchars();

/* if parent param is NOT set */
		if( parent_flag == false ) {
			googlemap_searchAddress(addr);
		}
	}

/* marks */
	for ( i=0 ; i<googlemap_info.length ; i++ ) {
		googlemap_map_obj.addOverlay( googlemap_createMarker_info( googlemap_info[i] ) );
	}

}
function googlemap_show_search() 
{
	googlemap_initMap();
	googlemap_initIcon();
	googlemap_client_geocoder = new GClientGeocoder();
	googlemap_moveendMap();
	googlemap_setCenter( googlemap_default_latitude, googlemap_default_longitude, googlemap_default_zoom );
	googlemap_setMapType();
	googlemap_addOverviewMapControl();

	now_addr = null;
	if ( document.getElementById("googlemap_search") != null ) {
		now_addr = document.getElementById("googlemap_search").value;
	}
	googlemap_searchAddress( now_addr );

}

function googlemap_show_georss() 
{
	googlemap_initMap();
	googlemap_setCenter( googlemap_default_latitude, googlemap_default_longitude, googlemap_default_zoom );
	googlemap_setMapType();
	googlemap_addOverviewMapControl();

	var googlemap_geo_xml = new GGeoXml( googlemap_geo_url );
	googlemap_map_obj.addOverlay( googlemap_geo_xml );
}

/* init map */
function googlemap_initMap() 
{
	googlemap_module_url = googlemap_xoops_url  + '/modules/' + googlemap_dirname
	googlemap_marker_url = googlemap_module_url + '/images/markers';

	googlemap_map_obj = new GMap2( document.getElementById("googlemap_map") );

	if ( googlemap_map_control == 'large' ) {
		googlemap_map_obj.addControl( new GLargeMapControl() );
	} else if ( googlemap_map_control == 'small' ) {
		googlemap_map_obj.addControl( new GSmallMapControl() );
	} else if ( googlemap_map_control == 'zoom' ) {
		googlemap_map_obj.addControl( new GSmallZoomControl() );
	}

	if ( googlemap_type_control == 'default' ) {
		googlemap_map_obj.addControl( new GMapTypeControl() );
	} else if ( googlemap_type_control == 'physical' ) {
		googlemap_map_obj.addControl( new GMapTypeControl() );
		googlemap_map_obj.addMapType( G_PHYSICAL_MAP );
	}

	if ( googlemap_use_scale_control ) {
		googlemap_map_obj.addControl( new GScaleControl() );
	}
}
function googlemap_setMapType() 
{
	if ( googlemap_map_type == 'satellite' ) {
		googlemap_map_obj.setMapType( G_SATELLITE_MAP );
	} else if ( googlemap_map_type == 'hybrid' ) {
		googlemap_map_obj.setMapType( G_HYBRID_MAP );
	} else if ( googlemap_map_type == 'physical' ) {
		googlemap_map_obj.setMapType( G_PHYSICAL_MAP );
	}
}
function googlemap_addOverviewMapControl() 
{
	if ( googlemap_use_overview_map_control ) {
		googlemap_map_obj.addControl( new GOverviewMapControl() );
	}
}
function googlemap_initIcon() 
{
	if ( googlemap_use_costum_icon ) {
		googlemap_drag_icon = new GIcon();
		googlemap_drag_icon.image = googlemap_marker_url + "/marker_green_cross_s.png";
		googlemap_drag_icon.iconSize = new GSize(18, 30);
		googlemap_drag_icon.iconAnchor = new GPoint(9, 30);
		googlemap_drag_icon.infoWindowAnchor = new GPoint(9, 2);

		googlemap_base_icon = new GIcon();
		googlemap_base_icon.iconSize = new GSize(20, 34);
		googlemap_base_icon.iconAnchor = new GPoint(9, 34);
		googlemap_base_icon.infoWindowAnchor = new GPoint(9, 2);

		googlemap_small_icon = new GIcon();
		googlemap_small_icon.image = googlemap_marker_url + "/marker_small.png";
		googlemap_small_icon.iconSize = new GSize(12, 20);
		googlemap_small_icon.iconAnchor = new GPoint(5, 20);
		googlemap_small_icon.infoWindowAnchor = new GPoint(9, 2);

	} else {
		googlemap_drag_icon = G_DEFAULT_ICON;
	}
}

/* map moveend */
function googlemap_moveendMap() 
{
	GEvent.addListener(googlemap_map_obj, "moveend", function() {

		center = googlemap_map_obj.getCenter();
		xx = center.x;
		yy = center.y;
		zz = googlemap_map_obj.getZoom();

		if ( googlemap_use_set_parent_location ) {
			googlemap_setParentLatitude( yy, xx, zz );
		}

		if ( googlemap_set_current_location ) {
			current_location = googlemap_lang_latitude + ': ' + yy + ' / ' + googlemap_lang_longitude + ': ' + xx + ' / ' + googlemap_lang_zoom + ': ' + zz;
			document.getElementById("googlemap_current_location").innerHTML = current_location; 
		}

		if ( googlemap_use_nishioka_inverse ) {
			googlemap_inverse_nishioka( xx, yy );
		}

		if ( googlemap_use_draggable_marker ) {
			googlemap_showDraggableMarker();
		}

	} );

}

/* marker click */
function googlemap_clickMarker() 
{
	GEvent.addListener( googlemap_location_marker, "click", function() {
		googlemap_location_marker.openInfoWindowHtml( googlemap_location_marker_html );
	} );
}

/* draggable marker */
function googlemap_showDraggableMarker() 
{
	if ( googlemap_draggable_marker != null ) {
		googlemap_map_obj.removeOverlay( googlemap_draggable_marker );
	}
	var map_option = { icon:googlemap_drag_icon , draggable:true , bouncy:true , bounceGravity:0.5 } 
	googlemap_draggable_marker = new GMarker( 
		googlemap_map_obj.getCenter(), map_option ); 
	googlemap_map_obj.addOverlay( googlemap_draggable_marker );
	googlemap_dragendMarker();
}
function googlemap_dragendMarker() 
{
	GEvent.addListener( googlemap_draggable_marker, "dragend", function() {
		window.setTimeout( function() {
			googlemap_map_obj.panTo( googlemap_draggable_marker.getPoint() );
		}, 1000 );
	});
}

/* geocoder Locations */
function googlemap_geocoder_Locations( addr )
{
	if ( addr ) {
		googlemap_client_geocoder.getLocations( addr , function( response ) {
			if ( !response || response.Status.code != 200 ) {
				alert( googlemap_lang_no_match_place + "\n" + addr );
			} else {
				googlemap_geocoder_LocationsResponse( response );
			}
		} );
	}
}
function googlemap_geocoder_LocationsResponse( response )
{
/* clear all marker */
	googlemap_map_obj.clearOverlays();

	var length = response.Placemark.length;
	var googlemap_list = '<ol>';

	for(var i = 0; i< length; i++) {

/* location */
		place = response.Placemark[i];
		addr = place.address;
		lng  = place.Point.coordinates[0];
		lat  = place.Point.coordinates[1];
		zoom = place.AddressDetails.Accuracy + googlemap_zoom_accuracy;
		zoom = googlemap_maxZoom( zoom );

/* add marker */
		if ( googlemap_use_search_marker ) {
			googlemap_addMarker( i, lat, lng, zoom, addr );
		}
		googlemap_setBounds( i, lat, lng, zoom );
		googlemap_list += googlemap_getSearchList( i, lat, lng, zoom, addr );
	}

	googlemap_list += '</ol>';
	googlemap_setCenterBounds( length );
	document.getElementById("googlemap_list").innerHTML = googlemap_list;
}
function googlemap_addMarker( index, lat, lng, zoom, addr )
{
	icon = googlemap_createIcon( index );
	html = googlemap_getSearchHtml( index, lat, lng, zoom, addr );
	googlemap_map_obj.addOverlay( googlemap_createMarker( lat, lng, icon, html ) );
}
function googlemap_createIcon( index ) 
{
	letter = googlemap_getSmallLetter( index );

	if ( letter ) {
		var icon = new GIcon(googlemap_base_icon);
		icon.image = googlemap_marker_url + "/marker_" + letter + ".png";
	} else {
		var icon = new GIcon(googlemap_small_icon);
	}

	return icon;
}
function googlemap_createMarker( lat, lng, icon, html ) 
{
	var marker = new GMarker( new GLatLng( parseFloat( lat ) , parseFloat( lng ) ), icon );
	GEvent.addListener(marker, "click", function() {
		marker.openInfoWindowHtml( html );
	});
	return marker;
}
function googlemap_createMarker_info( info ) 
{
	var icon_id = parseInt( info[2] );

	var icon;
	if ( ( icon_id > 0  ) && ( googlemap_icon[ icon_id ] != null ) ){
		icon = googlemap_icon[ icon_id ];
	} else {
		icon = G_DEFAULT_ICON;
	}
	var marker = googlemap_createMarker( info[0], info[1], icon, info[3] ) ;
	return marker;
}
function googlemap_setBounds( index, lat, lng, zoom )
{
	var point = new GLatLng( parseFloat( lat ) , parseFloat( lng ) );
	if (( Math.floor( index ) == 0 )||( googlemap_bounds_zoom == null)) {
		googlemap_bounds_zoom = Math.floor( zoom );
		googlemap_bounds = new GLatLngBounds( point );
	}
	googlemap_bounds.extend( point );
}
function googlemap_setCenterBounds( length )
{
	var northEastPoint = googlemap_bounds.getNorthEast();
	var southWestPoint = googlemap_bounds.getSouthWest();
	lat = (northEastPoint.lat() + southWestPoint.lat()) / 2;
	lng = (northEastPoint.lng() + southWestPoint.lng()) / 2;

	zoom = googlemap_bounds_zoom;
	if ( length > 1 ) {
		zoom = googlemap_map_obj.getBoundsZoomLevel( googlemap_bounds );
	}

	googlemap_setCenter( lat, lng, zoom );
}
function googlemap_getSearchList( index, lat, lng, zoom, addr )
{
	html = googlemap_getSearchHtml( index, lat, lng, zoom, addr );
	list = '<li>' + html + '</li>' + "\n";
	return list;
}
function googlemap_getSearchHtml( index, lat, lng, zoom, addr)
{
	letter = googlemap_getCapitalLetter( index );
	if ( letter == '' ) {
		letter = index + 1;
	}

	func = "googlemap_setCenter(" + lat + ', '  + lng + ', ' + zoom + ")";
	link = '<a href="javascript:void(0)" onClick="' + func + '">' + addr.googlemap_htmlspecialchars() + '</a>';
	html = '<b>' + letter + '</b> ' + link;
	return html;
}
function googlemap_getCapitalLetter( index ) 
{
	var char = '';
	if (index < 26)
	{
		char = String.fromCharCode("A".charCodeAt(0) + index);
	}
	return char;
}
function googlemap_getSmallLetter( index ) 
{
	var char = '';
	if (index < 26)
	{
		char = String.fromCharCode("a".charCodeAt(0) + index);
	}
	return char;
}
function googlemap_maxZoom( z )
{
	if ( z > googlemap_zoom_max ) {
		z = googlemap_zoom_max;
	}
	return z;
}

/* geocoder LatLng */
function googlemap_geocoder_LatLng( addr )
{
	if ( addr ) {
		googlemap_client_geocoder.getLatLng(addr, function( point ) {
			if ( !point ) {
				alert( googlemap_lang_no_match_place + "\n" + addr );
			} else {
				googlemap_map_obj.setCenter( point, Math.floor( googlemap_zoom_geocode_default ) );
			}
		} );
	}

}

/* set & get parent */
function googlemap_getParentLatitude() 
{
	lat  = 0;
	lng  = 0;
	zoom = 0;
	flag = false;

	if ( googlemap_opener_mode == 'self' ) {
		if ( document.getElementById( googlemap_id_latitude ) != null ) {
			lat  = document.getElementById( googlemap_id_latitude ).value;
		}
		if ( document.getElementById( googlemap_id_longitude ) != null ) {
			lng  = document.getElementById( googlemap_id_longitude ).value;
		}
		if ( document.getElementById( googlemap_id_zoom ) != null ) {
			zoom = document.getElementById( googlemap_id_zoom ).value;
		}
	} else if (( googlemap_opener_mode == 'opener' )&&( opener != null )) {
		if ( opener.document.getElementById( googlemap_id_latitude ) != null ) {
			lat  = opener.document.getElementById( googlemap_id_latitude).value;
		}
		if ( opener.document.getElementById( googlemap_id_longitude ) != null ) {
			lng  = opener.document.getElementById( googlemap_id_longitude ).value;
		}
		if ( opener.document.getElementById( googlemap_id_zoom ) != null ) {
			zoom = opener.document.getElementById( googlemap_id_zoom ).value;
		}
	} else if (( googlemap_opener_mode == 'parent' )&&( parent != null )) {
		if ( parent.document.getElementById( googlemap_id_latitude ) != null ) {
			lat  = parent.document.getElementById( googlemap_id_latitude ).value;
		}
		if ( parent.document.getElementById( googlemap_id_longitude ) != null ) {
			lng  = parent.document.getElementById( googlemap_id_longitude ).value;
		}
		if ( parent.document.getElementById( googlemap_id_zoom ) != null ) {
			zoom = parent.document.getElementById( googlemap_id_zoom ).value;
		}
	}

/* if parent param is set */
	if( (lat != 0) || (lng != 0) || (zoom != 0) ) {
		flag = true;
	}

	arr = new Array(flag, lat, lng, zoom);
	return arr;
}

function googlemap_setParentLatitude( latitude , longitude , zoom )
{
	if ( googlemap_opener_mode == 'self' ) {
		if ( document.getElementById( googlemap_id_latitude ) != null) {
			 document.getElementById( googlemap_id_latitude ).value = latitude;
		}
		if ( document.getElementById( googlemap_id_longitude ) != null) {
			 document.getElementById( googlemap_id_longitude ).value = longitude;
		}
		if ( document.getElementById( googlemap_id_zoom ) != null) {
			 document.getElementById( googlemap_id_zoom ).value = Math.floor( zoom );
		}
	} else if (( googlemap_opener_mode == 'opener' )&&( opener != null)) {
		if ( opener.document.getElementById( googlemap_id_latitude ) != null) {
			 opener.document.getElementById( googlemap_id_latitude ).value = latitude;
		}
		if ( opener.document.getElementById( googlemap_id_longitude ) != null) {
			 opener.document.getElementById( googlemap_id_longitude ).value = longitude;
		}
		if ( opener.document.getElementById( googlemap_id_zoom ) != null) {
			 opener.document.getElementById( googlemap_id_zoom ).value = Math.floor( zoom );
		}
	} else if (( googlemap_opener_mode == 'parent' )&&( parent != null)) {
		if ( parent.document.getElementById( googlemap_id_latitude ) != null) {
			 parent.document.getElementById( googlemap_id_latitude ).value = latitude;
		}
		if ( parent.document.getElementById( googlemap_id_longitude ) != null) {
			 parent.document.getElementById( googlemap_id_longitude ).value = longitude;
		}
		if ( parent.document.getElementById( googlemap_id_zoom ) != null) {
			 parent.document.getElementById( googlemap_id_zoom ).value = Math.floor( zoom );
		}
	}
}
function googlemap_getParentAddress()
{
	addr = '';

	if ( googlemap_opener_mode == 'self' ) {
		if ( document.getElementById("googlemap_address") != null ) {
			addr = document.getElementById("googlemap_address").value;
		}
	} else if (( googlemap_opener_mode == 'opener' )&&( opener != null )) {
		if ( opener.document.getElementById("googlemap_address") != null ) {
			addr = opener.document.getElementById("googlemap_address").value;
		}
	} else if (( googlemap_opener_mode == 'parent' )&&( parent != null )) {
		if ( parent.document.getElementById("googlemap_address") != null ) {
			addr = parent.document.getElementById("googlemap_address").value;
		}
	}

	return addr;
}
function googlemap_setParentAddress( addr )
{
	if (( addr != null )&&( addr != '' )) {
		if ( googlemap_opener_mode == 'self' ) {
			if ( document.getElementById("googlemap_address") != null) {
				document.getElementById("googlemap_address").value = addr.googlemap_htmlspecialchars();
			}
		} else if (( googlemap_opener_mode == 'opener' )&&( opener != null)) {
			if ( opener.document.getElementById("googlemap_address") != null) {
				opener.document.getElementById("googlemap_address").value = addr.googlemap_htmlspecialchars();
			}
		} else if (( googlemap_opener_mode == 'parent' )&&( parent != null)) {
			if ( parent.document.getElementById("googlemap_address") != null) {
				parent.document.getElementById("googlemap_address").value = addr.googlemap_htmlspecialchars();
			}
		}
	}
}

/* reference: mygmap module's myggooglemap_map.js */
String.prototype.googlemap_htmlspecialchars = function() {
	var googlemap_tmp = this.toString();
	googlemap_tmp = googlemap_tmp.replace(/\//g, "");
	googlemap_tmp = googlemap_tmp.replace(/&/g, "&amp;");
	googlemap_tmp = googlemap_tmp.replace(/"/g, "&quot;");
	googlemap_tmp = googlemap_tmp.replace(/'/g, "&#39;");
	googlemap_tmp = googlemap_tmp.replace(/</g, "&lt;");
	googlemap_tmp = googlemap_tmp.replace(/>/g, "&gt;");
	return googlemap_tmp;
}

/* --------------------------------------------------------
 * for japanese
 * --------------------------------------------------------
 */
/* japanese inverse geocoder */
function googlemap_geocoder_tokyoUniv( addr )
{
	if ( addr ) {
		var url = googlemap_module_url + '/tokyo_univ_geocode.php?query=' + encodeURI( addr );

		GDownloadUrl( url , function( data , responseCode ) {
			if( googlemap_debug_geocoder_tokyo_univ ) {
				alert( data );
			}
			if( responseCode == 200 ) {
				xml = GXml.parse( data );

/* fixed javascript errors with IE6 by souhalt */
				if ( xml.documentElement != null ) {
					candidate = xml.documentElement.getElementsByTagName("candidate");
					if ( candidate.length == 0 ) {
						alert( googlemap_lang_no_match_place + "\n" + addr );
					} else {
						googlemap_geocoder_tokyoUnivResponse( xml );
					}
				} else {
					alert( googlemap_lang_no_match_place + "\n" + addr );
				}

			}
		});
	}
}
function googlemap_geocoder_tokyoUnivResponse( xml )
{
/* clear all marker */
	googlemap_map_obj.clearOverlays();

	var candidate = xml.documentElement.getElementsByTagName("candidate");
	var iconf = xml.documentElement.getElementsByTagName("iConf")[0].firstChild.nodeValue;
	var length = candidate.length;

	var googlemap_list = '<ol>';

	iconf = Math.floor( iconf );
	if ( iconf >= 2 && iconf <= 5 ) {
		zoom = iconf + googlemap_zoom_accuracy_tokyo_univ;
	} else {
		zoom = googlemap_zoom_geocode_default;
	}
	zoom = googlemap_maxZoom( zoom );

	for(var i = 0; i< length; i++) {

/* location */
		place = candidate[i];
		addr = place.getElementsByTagName("address")[0].firstChild.nodeValue;
		lat  = place.getElementsByTagName('latitude')[0].firstChild.nodeValue;
		lng  = place.getElementsByTagName('longitude')[0].firstChild.nodeValue;

/* add marker */
		if ( googlemap_use_search_marker ) {
			googlemap_addMarker( i, lat, lng, zoom, addr );
		}
		googlemap_setBounds( i, lat, lng, zoom );
		googlemap_list += googlemap_getSearchList( i, lat, lng, zoom, addr );
	}

	googlemap_setCenterBounds( length );
	googlemap_list += '</ol>';
	document.getElementById("googlemap_list").innerHTML = googlemap_list;
}

/* japanese inverse geocoder */
function googlemap_inverse_nishioka( lon, lat )
{
	var url = googlemap_module_url + '/nishioka_inverse.php?lon=' + lon + '&lat=' + lat;

	GDownloadUrl( url , function( data , responseCode ) {
		if( googlemap_debug_inverse_nishioka ) {
			alert( data );
		}
		if( responseCode == 200 ) {
			var xml = GXml.parse( data );

/* fixed javascript errors with IE6 by souhalt */
			if ( xml.documentElement != null ) {
				googlemap_inverse_nishiokaResponse( xml );
			}

		}
	});
}

function googlemap_inverse_nishiokaResponse( xml )
{
	googlemap_address_jp = null;
	googlemap_pref_jp    = null;
	googlemap_city_jp    = null;
	googlemap_town_jp    = null;
	googlemap_number_jp  = null;

	var error = null;
	var addr  = null;

	if ( xml.documentElement.getElementsByTagName("address")[0] != null) {
		googlemap_address_jp = xml.documentElement.getElementsByTagName("address")[0].firstChild.nodeValue;
	}
	if ( xml.documentElement.getElementsByTagName("pref")[0] != null) {
		googlemap_pref_jp = xml.documentElement.getElementsByTagName("pref")[0].firstChild.nodeValue;
	}
	if ( xml.documentElement.getElementsByTagName("city")[0] != null) {
		googlemap_city_jp = xml.documentElement.getElementsByTagName("city")[0].firstChild.nodeValue;
	}
	if ( xml.documentElement.getElementsByTagName("town")[0] != null) {
		googlemap_town_jp = xml.documentElement.getElementsByTagName("town")[0].firstChild.nodeValue;;
	}
	if ( xml.documentElement.getElementsByTagName("number")[0] != null) {
		googlemap_number_jp = xml.documentElement.getElementsByTagName("number")[0].firstChild.nodeValue;
	}
	if ( xml.documentElement.getElementsByTagName("Message")[0] != null) {
		error = xml.documentElement.getElementsByTagName("Message")[0].firstChild.nodeValue;
	}

	if ( googlemap_address_jp != null ) {
		addr = googlemap_address_jp;
	} else if ( error != null ) { 
		addr = error;
	} else {
		addr = "unknown";
	}
	document.getElementById("googlemap_current_address").innerHTML = addr;

	if ( googlemap_use_set_parent_address ) {
		googlemap_setParentAddress( googlemap_address_jp );
	}
}

/* set location*/
function googlemap_setParentCenterLocation()
{
	center = googlemap_map_obj.getCenter();
	xx = center.x;
	yy = center.y;
	zz = googlemap_map_obj.getZoom();
	googlemap_setParentLatitude( yy, xx, zz );
}
