<?php
// $Id: Install.class.php,v 1.1.1.1 2009/03/31 10:21:38 ohwada Exp $

//=========================================================
// Googlesearch Netcommons
// 2009-03-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Googlesearch追加アクションクラス
 *
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Googlesearch_Install extends Action
{
	var $googlesearchAction = null;
    /**
     * Googlesearch追加アクション
     *
     * @access  public
     */
    function execute()
    {
    	$container =& DIContainerFactory::getContainer();
		$request   =& $container->getComponent("Request");

// refer whatsnew/components/View.class
		$session  =& $container->getComponent("Session");
		$meta     = $session->getParameter("_meta");
		$sitename = $meta["sitename"];

// 見本を作成する
        $request->setParameter("parts_name",       GOOGLESEARCH_SAMPLE_NAME);
        $request->setParameter("site_label",       $sitename );
        $request->setParameter("site_restriction", BASE_URL.'/' );
        $request->setParameter("site_use",         GOOGLESEARCH_DEFAULT_SITE_USE);
        $request->setParameter("site_expand",      GOOGLESEARCH_DEFAULT_SITE_EXPAND);
        $request->setParameter("web_use",          GOOGLESEARCH_DEFAULT_WEB_USE);
        $request->setParameter("search_draw",      GOOGLESEARCH_DEFAULT_SEARCH_DRAW);
        $request->setParameter("search_execute",   GOOGLESEARCH_SAMPLE_SEARCH_EXCUTE);

// partsレコード登録
        if (!$this->googlesearchAction->setParts()) {
        	return false;
        }
		return true;
    }
}
?>