<?php
// $Id: List.class.php,v 1.1.1.1 2009/03/31 10:21:34 ohwada Exp $

//=========================================================
// Googlesearch Netcommons
// 2009-03-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Googlesearch一覧画面表示
 *
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Googlesearch_View_Edit_List extends Action
{
	// パラメータを受け取るため
	var $module_id = null;
	var $block_id = null;
	var $scroll = null;

	// 使用コンポーネントを受け取るため
	var $googlesearchView = null;
	var $request = null;
	var $filterChain = null;

	// validatorから受け取るため
	var $googlesearchCount = null;

	// 値をセットするため
	var $visibleRows = null;
	var $googlesearchList = null;
	var $currentGooglesearchID = null;

    /**
     * Googlesearch一覧画面表示アクション
     *
     * @access  public
     */
	function execute()
	{
    	//scrollが_ON以外の場合、Config変数を取得し limitを設定する
        if ($this->scroll != _ON) {
        	//Config変数の取得
			$config = $this->googlesearchView->getConfig( $this->module_id );
			$this->visibleRows = $config['list_row_count'];

	        $this->request->setParameter("limit", $this->visibleRows);
	        $this->currentGooglesearchID = $this->googlesearchView->getCurrentGooglesearchID();
	        if ($this->currentGooglesearchID === false) {
	        	return "error";
	        }
		}

		//partsレコード一覧を取得する
		$this->googlesearchList = $this->googlesearchView->getGooglesearchList();
        if (empty($this->googlesearchList)) {
        	return "error";
        }

        //scrollが_ONの時、「テーマなし」に設定する。
        if ($this->scroll == _ON) {
			$view =& $this->filterChain->getFilterByName("View");
			$view->setAttribute("define:theme", 0);
        	return "scroll";
        }
        
        return "screen";
    }
}
?>
