<?php
// $Id: Admin.class.php,v 1.3 2011/03/19 15:55:18 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2010-08-01
//=========================================================

//---------------------------------------------------------
// change log
// 2011-03-01 K.OHWADA
// Exauth_Common
//---------------------------------------------------------

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR.'/webapp/components/exauth/Common.class.php' ;

class Exauth_Admin extends Exauth_Common
{
	// コンポーネント
	var $_configAction = null;

	// セットされる変数
	var $_block_id = null;

/**
 * コンストラクター
 *
 * @access	public
 */
	function Exauth_Admin() 
	{
		$this->Exauth_Common();

//		$this->init_dicontainer('admin.dicon.ini');
		$this->init_component_common();
		$this->init_component();
//		$this->init_smarty_assign('admin.maple.ini');
	}

    function set_dirname_admin( $dirname )
	{
		$this->set_dirname( $dirname );
		$this->init_module_id();
		$this->init_language();
	}

    function init_component()
    {
		$this->_configAction =& $this->_container->getComponent("configAction");
	}

    function init_language()
	{
		$lang = $this->_session->getParameter('_lang');
		$file = WEBAPP_DIR . '/modules/'. $this->_dirname .'/language/'. $lang .'/admin.inc.php';
		include_once $file;
	}

//---------------------------------------------------------
// Exauthadmin_Components_View
//---------------------------------------------------------
    function set_block_id( $id )
    {
		$this->_block_id = $id;
	}

    function view()
    {
		// dummy
	}

    function action()
    {
		// dummy
	}

//---------------------------------------------------------
// view
//---------------------------------------------------------
    function build_view( $lang )
    {
		return $this->fetch_template( 
			$this->build_assign( $lang ), 
			$this->get_module_template_main_dir(),
			$this->build_template_by_dirname( $this->_dirname ) );
    }

    function build_assign( $lang )
	{
		$arr = array(
			'id'       => $this->_block_id ,
			'action'   => $this->build_action() ,
			'lang'     => $lang ,
		);
		return $arr;
	}

    function build_template_by_dirname( $dirname )
    {
		$str = $dirname.'_admin.html';
		return $str;
	}

    function build_action()
    {
		$arr = array(
			'base_url' => BASE_URL ,
			'config'   => $this->get_module_config( $this->_module_id ) ,
		);
		return $arr;
	}

//---------------------------------------------------------
// config を設定する
//---------------------------------------------------------
    function update_config( $key )
	{
		if ( empty($this->_module_id) ) {
			return false;
		}

		$value = isset($_POST[$key]) ? $_POST[$key] : null;
    	return $this->upd_config_value_with_modid( 
			$this->_module_id, $key, $value );
	}

    function upd_config_value_with_modid( 
		$conf_modid, $conf_name, $conf_value, $conf_catid=_MAIN_CONF_CATID )
	{
    	return $this->_configAction->updConfigValue( 
			 $conf_modid, $conf_name, $conf_value, $conf_catid );
	}

//---------------------------------------------------------
// テンプレートを表示する
//---------------------------------------------------------
	function fetch_template( $assign, $template_dir, $template )
	{
		$renderer = new SmartyTemplate;
		$renderer->setTemplateDir(  $template_dir );
		$renderer->assign( $assign );
		$result = $renderer->fetch( $template );
		return $result;
	}

// === class end ===
}

?>